/*
 * Decompiled with CFR 0.152.
 */
package pl.setblack.nee.ctx.web;

import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import pl.setblack.nee.ctx.web.BasicAuthKt;
import pl.setblack.nee.ctx.web.BasicAuthProvider;
import pl.setblack.nee.effects.Out;
import pl.setblack.nee.effects.security.SecurityCtx;
import pl.setblack.nee.effects.security.SecurityError;
import pl.setblack.nee.effects.security.SecurityErrorType;
import pl.setblack.nee.effects.security.SecurityProvider;
import pl.setblack.nee.security.UserRealm;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u0014*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0003\u0013\u0014\u0015B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ \u0010\r\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100\u000eH\u0016J(\u0010\u0011\u001a\u001a\u0012\u0004\u0012\u00020\u000f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00100\u000e2\u0006\u0010\u0012\u001a\u00020\u0006H\u0002R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lpl/setblack/nee/ctx/web/BasicAuthProvider;", "USERID", "ROLE", "Lpl/setblack/nee/effects/security/SecurityProvider;", "headerVal", "Lio/vavr/control/Option;", "", "userRealm", "Lpl/setblack/nee/security/UserRealm;", "(Lio/vavr/control/Option;Lpl/setblack/nee/security/UserRealm;)V", "base64Decoder", "Ljava/util/Base64$Decoder;", "kotlin.jvm.PlatformType", "getSecurityContext", "Lpl/setblack/nee/effects/Out;", "Lpl/setblack/nee/effects/security/SecurityError;", "Lpl/setblack/nee/effects/security/SecurityCtx;", "parseHeader", "baseAuth", "AnonymousSecurityContext", "Companion", "UserSecurityContext", "nee-ctx-web-ktor"})
public final class BasicAuthProvider<USERID, ROLE>
implements SecurityProvider<USERID, ROLE> {
    private final Base64.Decoder base64Decoder;
    private final Option<String> headerVal;
    private final UserRealm<USERID, ROLE> userRealm;
    @NotNull
    public static final String basicAuthHeaderPrefix = "Basic ";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Out<SecurityError, SecurityCtx<USERID, ROLE>> getSecurityContext() {
        Object object = this.headerVal.map(new Function<String, Out<SecurityError, ? extends SecurityCtx<USERID, ROLE>>>(this){
            final /* synthetic */ BasicAuthProvider this$0;

            public final Out<SecurityError, SecurityCtx<USERID, ROLE>> apply(@NotNull String baseAuth) {
                Intrinsics.checkNotNullParameter((Object)baseAuth, (String)"baseAuth");
                return (Out)Try.of((CheckedFunction0)((CheckedFunction0)new CheckedFunction0<Out<SecurityError, ? extends SecurityCtx<USERID, ROLE>>>(this, baseAuth){
                    final /* synthetic */ getSecurityContext.1 this$0;
                    final /* synthetic */ String $baseAuth;

                    public final Out<SecurityError, SecurityCtx<USERID, ROLE>> apply() {
                        return BasicAuthProvider.access$parseHeader(this.this$0.this$0, this.$baseAuth);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$baseAuth = string;
                    }
                })).getOrElseGet((Function)getSecurityContext.2.INSTANCE);
            }
            {
                this.this$0 = basicAuthProvider;
            }
        }).getOrElse((Supplier)getSecurityContext.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"headerVal.map { baseAuth\u2026urityContext())\n        }");
        return (Out)object;
    }

    private final Out<SecurityError, SecurityCtx<USERID, ROLE>> parseHeader(String baseAuth) {
        Out out;
        if (StringsKt.startsWith$default((String)baseAuth, (String)basicAuthHeaderPrefix, (boolean)false, (int)2, null)) {
            Out out2;
            String string = baseAuth;
            int n = basicAuthHeaderPrefix.length();
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            byte[] decodedAut = this.base64Decoder.decode(string3);
            Intrinsics.checkNotNullExpressionValue((Object)decodedAut, (String)"decodedAut");
            int colonIndex = ArraysKt.indexOf((byte[])decodedAut, (byte)((byte)58));
            if (colonIndex > 0) {
                byte[] byArray = ArraysKt.sliceArray((byte[])decodedAut, (IntRange)RangesKt.until((int)0, (int)colonIndex));
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(\"UTF-8\")");
                Charset charset2 = charset;
                boolean bl2 = false;
                boolean bl3 = false;
                String login = new String(byArray, charset2);
                char[] pass = BasicAuthKt.toCharArray(ArraysKt.sliceArray((byte[])decodedAut, (IntRange)RangesKt.until((int)(colonIndex + 1), (int)decodedAut.length)));
                out2 = (Out)this.userRealm.loginUser(login, pass).map(new Function<USERID, Out<SecurityError, ? extends SecurityCtx<USERID, ROLE>>>(this, pass){
                    final /* synthetic */ BasicAuthProvider this$0;
                    final /* synthetic */ char[] $pass;

                    public final Out<SecurityError, SecurityCtx<USERID, ROLE>> apply(USERID user) {
                        ArraysKt.fill$default((char[])this.$pass, (char)((char)0), (int)0, (int)0, (int)6, null);
                        return Out.Companion.right(new UserSecurityContext<USERID, ROLE>(user, BasicAuthProvider.access$getUserRealm$p(this.this$0)));
                    }
                    {
                        this.this$0 = basicAuthProvider;
                        this.$pass = cArray;
                    }
                }).getOrElse(new Supplier<Out<SecurityError, ? extends SecurityCtx<USERID, ROLE>>>(login){
                    final /* synthetic */ String $login;

                    public final Out<SecurityError, SecurityCtx<USERID, ROLE>> get() {
                        return Out.Companion.left((Object)new SecurityErrorType.WrongCredentials(this.$login));
                    }
                    {
                        this.$login = string;
                    }
                });
            } else {
                out2 = Out.Companion.left((Object)new SecurityErrorType.MalformedCredentials("no colon inside header: " + baseAuth));
            }
            out = out2;
            Intrinsics.checkNotNullExpressionValue((Object)out2, (String)"if (colonIndex > 0) {\n  \u2026          )\n            }");
        } else {
            out = Out.Companion.left((Object)new SecurityErrorType.MalformedCredentials("no basic auth header: " + baseAuth));
        }
        return out;
    }

    public BasicAuthProvider(@NotNull Option<String> headerVal, @NotNull UserRealm<USERID, ROLE> userRealm2) {
        Intrinsics.checkNotNullParameter(headerVal, (String)"headerVal");
        Intrinsics.checkNotNullParameter(userRealm2, (String)"userRealm");
        this.headerVal = headerVal;
        this.userRealm = userRealm2;
        this.base64Decoder = Base64.getDecoder();
    }

    public static final /* synthetic */ Out access$parseHeader(BasicAuthProvider $this, String baseAuth) {
        return $this.parseHeader(baseAuth);
    }

    public static final /* synthetic */ UserRealm access$getUserRealm$p(BasicAuthProvider $this) {
        return $this.userRealm;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00020\u0006H\u0016J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lpl/setblack/nee/ctx/web/BasicAuthProvider$AnonymousSecurityContext;", "USERID", "ROLE", "Lpl/setblack/nee/effects/security/SecurityCtx;", "()V", "getCurrentUser", "Lpl/setblack/nee/effects/Out;", "Lpl/setblack/nee/effects/security/SecurityError;", "hasRole", "", "role", "(Ljava/lang/Object;)Z", "nee-ctx-web-ktor"})
    public static final class AnonymousSecurityContext<USERID, ROLE>
    implements SecurityCtx<USERID, ROLE> {
        @NotNull
        public Out<SecurityError, USERID> getCurrentUser() {
            return Out.Companion.left((Object)SecurityErrorType.UnknownUser.INSTANCE);
        }

        public boolean hasRole(ROLE role) {
            return false;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0002\u0010\u0001*\u0004\b\u0003\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B!\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00028\u00020\nH\u0016J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\u000fR\u0010\u0010\u0004\u001a\u00028\u0002X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpl/setblack/nee/ctx/web/BasicAuthProvider$UserSecurityContext;", "USERID", "ROLE", "Lpl/setblack/nee/effects/security/SecurityCtx;", "user", "userRealm", "Lpl/setblack/nee/security/UserRealm;", "(Ljava/lang/Object;Lpl/setblack/nee/security/UserRealm;)V", "Ljava/lang/Object;", "getCurrentUser", "Lpl/setblack/nee/effects/Out;", "Lpl/setblack/nee/effects/security/SecurityError;", "hasRole", "", "role", "(Ljava/lang/Object;)Z", "nee-ctx-web-ktor"})
    public static final class UserSecurityContext<USERID, ROLE>
    implements SecurityCtx<USERID, ROLE> {
        private final USERID user;
        private final UserRealm<USERID, ROLE> userRealm;

        @NotNull
        public Out<SecurityError, USERID> getCurrentUser() {
            return Out.Companion.right(this.user);
        }

        public boolean hasRole(ROLE role) {
            return this.userRealm.hasRole(this.user, role);
        }

        public UserSecurityContext(USERID user, @NotNull UserRealm<USERID, ROLE> userRealm2) {
            Intrinsics.checkNotNullParameter(userRealm2, (String)"userRealm");
            this.user = user;
            this.userRealm = userRealm2;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lpl/setblack/nee/ctx/web/BasicAuthProvider$Companion;", "", "()V", "basicAuthHeaderPrefix", "", "nee-ctx-web-ktor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

