/*
 * Decompiled with CFR 0.152.
 */
package dev.neeffect.nee.security;

import dev.neeffect.nee.effects.jdbc.JDBCProvider;
import dev.neeffect.nee.security.DBUserRealmKt;
import dev.neeffect.nee.security.PBKDF2Hasher;
import dev.neeffect.nee.security.User;
import dev.neeffect.nee.security.UserRealm;
import dev.neeffect.nee.security.UserRole;
import io.vavr.collection.List;
import io.vavr.control.Option;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ldev/neeffect/nee/security/DBUserRealm;", "Ldev/neeffect/nee/security/UserRealm;", "Ldev/neeffect/nee/security/User;", "Ldev/neeffect/nee/security/UserRole;", "dbProvider", "Ldev/neeffect/nee/effects/jdbc/JDBCProvider;", "(Ldev/neeffect/nee/effects/jdbc/JDBCProvider;)V", "checkDBRow", "Lio/vavr/control/Option;", "resultSet", "Ljava/sql/ResultSet;", "password", "", "userLogin", "", "jdbcConnection", "Ljava/sql/Connection;", "findUserInDB", "statement", "Ljava/sql/PreparedStatement;", "hasRole", "", "user", "role", "loadRoles", "Lio/vavr/collection/List;", "userId", "Ljava/util/UUID;", "loginUser", "Companion", "nee-security-jdbc"})
public final class DBUserRealm
implements UserRealm<User, UserRole> {
    private final JDBCProvider dbProvider;
    @NotNull
    private static final PBKDF2Hasher passwordHasher;
    public static final int uuidByteSize = 16;
    private static final int userIdColumn = 1;
    private static final int saltColumn = 2;
    private static final int passHashColumn = 3;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Option<User> loginUser(@NotNull String userLogin, @NotNull char[] password) {
        Option<User> option;
        Intrinsics.checkNotNullParameter((Object)userLogin, (String)"userLogin");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Object object = this.dbProvider.getConnection().getResource();
        boolean bl = false;
        boolean bl2 = false;
        Connection jdbcConnection = (Connection)object;
        boolean bl3 = false;
        AutoCloseable autoCloseable = jdbcConnection.prepareStatement("select  id, salt, password  from users where login = ?");
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            PreparedStatement statement = (PreparedStatement)autoCloseable;
            boolean bl6 = false;
            PreparedStatement preparedStatement = statement;
            Intrinsics.checkNotNullExpressionValue((Object)preparedStatement, (String)"statement");
            option = this.findUserInDB(preparedStatement, userLogin, password, jdbcConnection);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Option<User> findUserInDB(PreparedStatement statement, String userLogin, char[] password, Connection jdbcConnection) {
        Option<User> r;
        Option<User> option;
        PreparedStatement preparedStatement = statement;
        boolean bl = false;
        boolean bl2 = false;
        PreparedStatement $this$run = preparedStatement;
        boolean bl3 = false;
        $this$run.setString(1, userLogin);
        AutoCloseable autoCloseable = $this$run.executeQuery();
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            Option<User> option2;
            ResultSet resultSet = (ResultSet)autoCloseable;
            boolean bl6 = false;
            if (resultSet.next()) {
                ResultSet resultSet2 = resultSet;
                Intrinsics.checkNotNullExpressionValue((Object)resultSet2, (String)"resultSet");
                option2 = this.checkDBRow(resultSet2, password, userLogin, jdbcConnection);
            } else {
                option2 = Option.none();
            }
            option = option2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Option<User> option3 = r = option;
        Intrinsics.checkNotNullExpressionValue(option3, (String)"statement.run {\n        \u2026}\n            r\n        }");
        return option3;
    }

    private final Option<User> checkDBRow(ResultSet resultSet, char[] password, String userLogin, Connection jdbcConnection) {
        Option option;
        byte[] byArray = resultSet.getBytes(1);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"resultSet.getBytes(userIdColumn)");
        UUID user = DBUserRealmKt.toUUID(byArray);
        byte[] salt = resultSet.getBytes(2);
        byte[] passwordHash = resultSet.getBytes(3);
        Intrinsics.checkNotNullExpressionValue((Object)salt, (String)"salt");
        byte[] inputHash = passwordHasher.hashPassword(password, salt);
        byte[] byArray2 = passwordHash;
        boolean bl = false;
        if (Arrays.equals(byArray2, inputHash)) {
            Option option2 = Option.some((Object)new User(user, userLogin, this.loadRoles(jdbcConnection, user), null, 8, null));
            option = option2;
            Intrinsics.checkNotNullExpressionValue((Object)option2, (String)"Option.some(User(user, u\u2026s(jdbcConnection, user)))");
        } else {
            Option option3 = Option.none();
            option = option3;
            Intrinsics.checkNotNullExpressionValue((Object)option3, (String)"Option.none()");
        }
        return option;
    }

    public boolean hasRole(@NotNull User user, @NotNull UserRole role) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        return user.getRoles().contains((Object)role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<UserRole> loadRoles(Connection jdbcConnection, UUID userId) {
        List list;
        AutoCloseable autoCloseable = jdbcConnection.prepareStatement("SELECT role_name FROM user_roles WHERE user_id = ?");
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            List list2;
            PreparedStatement statement = (PreparedStatement)autoCloseable;
            boolean bl3 = false;
            statement.setBytes(1, DBUserRealmKt.toBytes(userId));
            AutoCloseable autoCloseable2 = statement.executeQuery();
            boolean bl4 = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                ResultSet resultSet = (ResultSet)autoCloseable2;
                boolean bl6 = false;
                List roles = List.empty();
                while (resultSet.next()) {
                    String roleName;
                    String string = roleName = resultSet.getString(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"roleName");
                    roles = roles.prepend((Object)new UserRole(string));
                }
                list2 = roles;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            List list3 = list2;
            list = list3;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jdbcConnection.prepareSt\u2026s\n            }\n        }");
        return list;
    }

    public DBUserRealm(@NotNull JDBCProvider dbProvider) {
        Intrinsics.checkNotNullParameter((Object)dbProvider, (String)"dbProvider");
        this.dbProvider = dbProvider;
    }

    static {
        Companion = new Companion(null);
        passwordHasher = new PBKDF2Hasher();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/neeffect/nee/security/DBUserRealm$Companion;", "", "()V", "passHashColumn", "", "passwordHasher", "Ldev/neeffect/nee/security/PBKDF2Hasher;", "getPasswordHasher", "()Ldev/neeffect/nee/security/PBKDF2Hasher;", "saltColumn", "userIdColumn", "uuidByteSize", "nee-security-jdbc"})
    public static final class Companion {
        @NotNull
        public final PBKDF2Hasher getPasswordHasher() {
            return passwordHasher;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

