/*
 * Decompiled with CFR 0.152.
 */
package dev.neeffect.nee.security;

import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\u0004j\u0002`\b\u00a8\u0006\n"}, d2={"Ldev/neeffect/nee/security/PBKDF2Hasher;", "", "()V", "hashPassword", "", "password", "", "salt", "Ldev/neeffect/nee/security/Salt;", "HashParams", "nee-security-jdbc"})
public final class PBKDF2Hasher {
    @NotNull
    public final byte[] hashPassword(@NotNull char[] password, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        PBEKeySpec pBEKeySpec = new PBEKeySpec(password, salt, 32761, 128);
        boolean bl = false;
        boolean bl2 = false;
        PBEKeySpec keySpec = pBEKeySpec;
        boolean bl3 = false;
        SecretKey secretKey = HashParams.INSTANCE.getAlgorithm().generateSecret(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"algorithm.generateSecret(keySpec)");
        byte[] byArray = secretKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"PBEKeySpec(password, sal\u2026eySpec).encoded\n        }");
        return byArray;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ldev/neeffect/nee/security/PBKDF2Hasher$HashParams;", "", "()V", "algorithm", "Ljavax/crypto/SecretKeyFactory;", "kotlin.jvm.PlatformType", "getAlgorithm", "()Ljavax/crypto/SecretKeyFactory;", "algorithmName", "", "iterationCount", "", "keyLength", "nee-security-jdbc"})
    public static final class HashParams {
        @NotNull
        public static final String algorithmName = "PBKDF2WithHmacSHA1";
        public static final int iterationCount = 32761;
        public static final int keyLength = 128;
        private static final SecretKeyFactory algorithm;
        @NotNull
        public static final HashParams INSTANCE;

        public final SecretKeyFactory getAlgorithm() {
            return algorithm;
        }

        private HashParams() {
        }

        static {
            HashParams hashParams;
            INSTANCE = hashParams = new HashParams();
            algorithm = SecretKeyFactory.getInstance(algorithmName);
        }
    }
}

