/*
 * Decompiled with CFR 0.152.
 */
package pl.smsapi.api.action.contacts;

import java.net.URLEncoder;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.json.JSONObject;
import pl.smsapi.StringUtils;
import pl.smsapi.api.action.AbstractAction;
import pl.smsapi.api.action.contacts.Contacts;

public class ContactsList
extends AbstractAction<Contacts> {
    protected TreeMap<String, String> query = new TreeMap();

    @Override
    protected String endPoint() {
        if (this.query.isEmpty()) {
            return "contacts";
        }
        return "contacts?" + this.query.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue())).collect(Collectors.joining("&"));
    }

    @Override
    protected String httpMethod() {
        return "GET";
    }

    public ContactsList filterByPhoneNumber(String phoneNumber) {
        this.query.put("phone_number", phoneNumber);
        return this;
    }

    public ContactsList filterByEmail(String email) {
        this.query.put("email", email);
        return this;
    }

    public ContactsList filterByFirstName(String firstName) {
        this.query.put("first_name", firstName);
        return this;
    }

    public ContactsList filterByLastName(String lastName) {
        this.query.put("last_name", lastName);
        return this;
    }

    public ContactsList filterByGroupId(String groupId) {
        this.query.put("group_id", groupId);
        return this;
    }

    public ContactsList filterByGroupIds(String[] groupIds) {
        this.query.put("group_id", StringUtils.join(groupIds, ','));
        return this;
    }

    public ContactsList filterByGender(String gender) {
        this.query.put("gender", gender);
        return this;
    }

    public ContactsList filterByBirthdayDate(String birthdayDate) {
        this.query.put("birthday_date", birthdayDate);
        return this;
    }

    public ContactsList orderBy(String orderBy) {
        this.query.put("order_by", orderBy);
        return this;
    }

    public ContactsList limit(int limit) {
        this.query.put("limit", Integer.toString(limit));
        return this;
    }

    public ContactsList offset(int offset) {
        this.query.put("offset", Integer.toString(offset));
        return this;
    }

    @Override
    protected Contacts createResponse(String data) {
        return new Contacts.ContactsFromJsonFactory().createFrom(new JSONObject(data));
    }
}

