/*
 * Decompiled with CFR 0.152.
 */
package pl.smsapi.api.action.vms;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.json.JSONObject;
import pl.smsapi.api.action.AbstractSendAction;
import pl.smsapi.api.response.StatusResponse;

public class VMSSend
extends AbstractSendAction<VMSSend, StatusResponse> {
    public VMSSend() {
        this.setJson(true);
    }

    public VMSSend(String to, String tts) {
        this.setJson(true);
        this.setTo(to);
        this.params.put("tts", tts);
    }

    public VMSSend(String[] to, String tts) {
        this.setJson(true);
        this.setTo(to);
        this.params.put("tts", tts);
    }

    public VMSSend(String to, File file) throws IOException {
        this.setJson(true);
        this.setTo(to);
        this.files.put("file", Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public VMSSend(String[] to, File file) throws IOException {
        this.setJson(true);
        this.setTo(to);
        this.files.put("file", Files.newInputStream(file.toPath(), new OpenOption[0]));
    }

    public VMSSend(String[] to, InputStream file) {
        this.setJson(true);
        this.setTo(to);
        this.files.put("file", file);
    }

    public VMSSend setFile(File file) throws FileNotFoundException {
        this.files.put("file", new FileInputStream(file));
        return this;
    }

    public VMSSend setFile(String pathFile) throws FileNotFoundException {
        this.files.put("file", new FileInputStream(pathFile));
        return this;
    }

    public VMSSend setFile(InputStream inputStream) {
        this.files.put("file", inputStream);
        return this;
    }

    public VMSSend setTts(String tts) {
        this.params.put("tts", tts);
        return this;
    }

    public VMSSend setSkipGsm(boolean skipGsm) {
        if (skipGsm) {
            this.params.put("skip_gsm", "1");
        } else {
            this.params.remove("skip_gsm");
        }
        return this;
    }

    public VMSSend setTtsLector(Lector lector) {
        this.params.put("tts_lector", lector.toString());
        return this;
    }

    public VMSSend setInterval(Integer interval) {
        if (interval == null) {
            this.params.remove("interval");
        } else {
            this.params.put("interval", interval.toString());
        }
        return this;
    }

    public VMSSend setFrom(String from) {
        this.params.put("from", from);
        return this;
    }

    @Override
    protected StatusResponse createResponse(String data) {
        JSONObject jsonObject = new JSONObject(data);
        return new StatusResponse(jsonObject.getInt("count"), jsonObject.optJSONArray("list"));
    }

    @Override
    protected String endPoint() {
        return "vms.do";
    }

    public static enum Lector {
        EWA,
        JACEK,
        JAN,
        MAJA;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

