/*
 * Decompiled with CFR 0.152.
 */
package pl.smsapi.proxy;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import pl.smsapi.api.authenticationStrategy.AuthenticationStrategy;
import pl.smsapi.exception.ProxyException;
import pl.smsapi.proxy.Proxy;

public class ProxyNative
implements Proxy {
    private String baseUrl;
    private String userAgent;

    public ProxyNative(String url) {
        this.baseUrl = url;
    }

    @Override
    public String execute(String endpoint, Map<String, String> data, Map<String, InputStream> files, String httpMethod, AuthenticationStrategy authenticationStrategy) throws Exception {
        String response;
        byte[] dataBytes;
        URL url = this.createUrl(httpMethod, endpoint, data);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("User-Agent", this.generateUserAgent());
        connection.setRequestProperty("Accept", "*");
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setRequestMethod(httpMethod);
        String authenticationHeader = authenticationStrategy.getAuthenticationHeader();
        if (authenticationHeader != null) {
            connection.setRequestProperty("Authorization", authenticationHeader);
        }
        if (httpMethod.equals("GET")) {
            data.clear();
        }
        if (files == null || files.isEmpty()) {
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            dataBytes = this.createDataStream(data);
        } else {
            String boundary = this.generateBoundary();
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            dataBytes = this.createMultipartDataStream(boundary, data, files);
        }
        connection.setRequestProperty("Content-Length", Integer.toString(dataBytes.length));
        if (dataBytes.length != 0) {
            connection.getOutputStream().write(dataBytes);
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
        }
        try {
            response = this.readResponsePayload(connection.getInputStream());
        }
        catch (FileNotFoundException notFound) {
            response = this.readResponsePayload(connection.getErrorStream());
        }
        catch (IOException clientErrorOrServerError) {
            response = this.readResponsePayload(connection.getErrorStream());
        }
        return response;
    }

    private String generateUserAgent() throws IOException {
        if (this.userAgent == null) {
            String version = "undefined";
            try (InputStream propertiesResource = this.getClass().getClassLoader().getResourceAsStream("smsapi-java-client.properties");){
                if (propertiesResource != null) {
                    Properties properties = new Properties();
                    properties.load(propertiesResource);
                    version = properties.getProperty("version", "undefined");
                }
            }
            this.userAgent = "smsapi/java-client:" + version + ";java:" + System.getProperty("java.vm.version", "undefined");
        }
        return this.userAgent;
    }

    private String readResponsePayload(InputStream inputStream) throws ProxyException {
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder response = new StringBuilder();
        try {
            String line;
            while ((line = inputReader.readLine()) != null) {
                response.append(line);
            }
            inputReader.close();
        }
        catch (IOException readerException) {
            throw new ProxyException("Cannot read response input stream", readerException);
        }
        return response.toString();
    }

    private String generateBoundary() {
        Random generator = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH:mm:ss");
        return "SMSAPI-" + format.format(new Date()) + generator.nextInt() + "-boundary";
    }

    protected URL createUrl(String httpMethod, String endpoint, Map<String, ?> data) throws UnsupportedEncodingException, MalformedURLException {
        String urlString = this.baseUrl + endpoint;
        if (httpMethod.equals("GET") && !data.isEmpty()) {
            String queryString = this.createQueryString(data);
            urlString = urlString.contains("?") ? urlString + '&' + queryString : urlString + '?' + queryString;
        }
        return new URL(urlString);
    }

    protected String createQueryString(Map<String, ?> data) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, ?>> entryIterator = data.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<String, ?> entry = entryIterator.next();
            String record = this.encodeUrlParam(entry.getKey()) + "=" + this.encodeUrlParam(entry.getValue().toString());
            stringBuilder.append(record);
            if (!entryIterator.hasNext()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    protected byte[] createDataStream(Map<String, ?> data) throws IOException {
        String queryString = this.createQueryString(data);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        stream.write(queryString.getBytes());
        return stream.toByteArray();
    }

    protected byte[] createMultipartDataStream(String boundary, Map<String, ?> data, Map<String, InputStream> files) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (Map.Entry<String, ?> entry : data.entrySet()) {
            String paramHeader = "\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + entry.getKey() + "\";\r\n\r\n";
            stream.write(paramHeader.getBytes());
            stream.write(entry.getValue().toString().getBytes());
        }
        for (Map.Entry<String, Object> entry : files.entrySet()) {
            int n;
            String fileHeader = "\r\n--" + boundary + "\r\nContent-Disposition: form-data; name=\"" + entry.getKey() + "\"; filename=\"" + entry.getKey() + "\"\r\nContent-Type: application/octet-stream\r\n\r\n";
            stream.write(fileHeader.getBytes());
            InputStream inputStream = (InputStream)entry.getValue();
            byte[] buffer = new byte[4096];
            while ((n = inputStream.read(buffer)) > 0) {
                stream.write(buffer, 0, n);
            }
            inputStream.close();
        }
        byte[] footBytes = ("\r\n--" + boundary + "--").getBytes();
        stream.write(footBytes, 0, footBytes.length);
        return stream.toByteArray();
    }

    protected String encodeUrlParam(String s) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, "UTF-8");
    }
}

