/*
 * Decompiled with CFR 0.152.
 */
package pl.solr.ag.mongodb.sink;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.util.JSON;
import com.sematext.ag.PlayerConfig;
import com.sematext.ag.event.ComplexEvent;
import com.sematext.ag.exception.InitializationFailedException;
import com.sematext.ag.sink.Sink;
import pl.solr.dm.producers.JsonDataModelProducer;

public class ComplexDataSink
extends Sink<ComplexEvent> {
    public static final String BASE_HOST_KEY = "complexDataMongoDBSink.host";
    public static final String BASE_PORT_KEY = "complexDataMongoDBSink.port";
    public static final String DB_NAME_KEY = "complexDataMongoDBSink.db";
    public static final String COLLECTION_NAME_KEY = "complexDataMongoDBSink.collection";
    private String host;
    private Integer port;
    private String dbName;
    private String collectionName;
    private DBCollection collection;
    private DB db;

    public void init(PlayerConfig config) throws InitializationFailedException {
        super.init(config);
        this.host = config.get(BASE_HOST_KEY);
        this.port = Integer.valueOf(config.get(BASE_PORT_KEY));
        this.dbName = config.get(DB_NAME_KEY);
        this.collectionName = config.get(COLLECTION_NAME_KEY);
        if (this.host == null || "".equals(this.host.trim())) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " expects configuration property " + BASE_HOST_KEY);
        }
        if (this.port == null) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " expects configuration property " + BASE_PORT_KEY);
        }
        if (this.dbName == null || "".equals(this.dbName.trim())) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " expects configuration property " + DB_NAME_KEY);
        }
        if (this.collectionName == null || "".equals(this.collectionName.trim())) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getName() + " expects configuration property " + COLLECTION_NAME_KEY);
        }
        Mongo mongo = null;
        try {
            mongo = new Mongo(this.host, this.port.intValue());
        }
        catch (Exception e) {
            throw new InitializationFailedException(e.getMessage());
        }
        this.db = mongo.getDB(this.dbName);
        this.collection = this.db.getCollection(this.collectionName);
    }

    public boolean write(ComplexEvent event) {
        String result = new JsonDataModelProducer().convert(event.getObject());
        DBObject obj = (DBObject)JSON.parse((String)result);
        this.collection.insert(new DBObject[]{obj});
        return true;
    }
}

