/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.google.common.collect.Streams;
import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@StatelessCheck
public class MethodParameterAlignmentCheck
extends AbstractCheck {
    public static final String MSG_PARAM_ALIGNMENT = "method.params.alignment";

    private static DetailAST getFirstChild(DetailAST ast, int type) {
        DetailAST c;
        for (c = ast.getFirstChild(); c != null && c.getType() != type; c = c.getNextSibling()) {
        }
        return Objects.requireNonNull(c);
    }

    public static Stream<DetailAST> walkDfs(final DetailAST start) {
        return Streams.stream((Iterator)new Iterator<DetailAST>(){
            private LinkedList<DetailAST> q = new LinkedList();
            {
                this.q.push(start);
            }

            @Override
            public boolean hasNext() {
                return !this.q.isEmpty();
            }

            @Override
            public DetailAST next() {
                DetailAST r = this.q.pop();
                if (r == null) {
                    return null;
                }
                if (r.getNextSibling() != null) {
                    this.q.push(r.getNextSibling());
                }
                if (r.hasChildren()) {
                    this.q.push(r.getFirstChild());
                }
                return r;
            }
        });
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        DetailAST parameters = MethodParameterAlignmentCheck.getFirstChild(ast, 20);
        HashSet<Integer> uniqueFirstColNumbersInLines = new HashSet<Integer>(MethodParameterAlignmentCheck.walkDfs(parameters.getFirstChild()).filter(Objects::nonNull).collect(Collectors.toMap(it -> it.getLineNo(), it -> it.getColumnNo(), (c1, c2) -> Math.min(c1, c2))).values());
        if (uniqueFirstColNumbersInLines.size() > 1) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAM_ALIGNMENT, new Object[0]);
        }
    }
}

