/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.google.common.collect.Streams;
import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@StatelessCheck
public class MethodParameterLinesCheck
extends AbstractCheck {
    public static final String MSG_PARAMS_LINES = "method.params.lines";
    public static final String MSG_PARAMS_SEPARATE_LINES = "method.params.separate-lines";
    private boolean allowSingleLine = true;

    private static DetailAST getFirstChild(DetailAST ast, int type) {
        return MethodParameterLinesCheck.stream(ast.getFirstChild()).filter(it -> it.getType() == type).findFirst().get();
    }

    public static Stream<DetailAST> stream(DetailAST start) {
        return Streams.stream(MethodParameterLinesCheck.iterate(start));
    }

    private static Stream<DetailAST> streamAll(DetailAST start, int type) {
        return MethodParameterLinesCheck.stream(start).filter(c -> c.getType() == type);
    }

    private static Iterator<DetailAST> iterate(final DetailAST start) {
        return new Iterator<DetailAST>(){
            private DetailAST c;
            {
                this.c = start;
            }

            @Override
            public boolean hasNext() {
                return this.c != null;
            }

            @Override
            public DetailAST next() {
                DetailAST r = this.c;
                this.c = r.getNextSibling();
                return r;
            }
        };
    }

    private static boolean allDifferent(List<Integer> lines) {
        return new HashSet<Integer>(lines).size() == lines.size();
    }

    private static boolean allSame(List<Integer> lines) {
        return new HashSet<Integer>(lines).size() == 1;
    }

    public void setAllowSingleLine(boolean allowSingleLine) {
        this.allowSingleLine = allowSingleLine;
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        DetailAST parameters = MethodParameterLinesCheck.getFirstChild(ast, 20);
        List<Integer> lines = MethodParameterLinesCheck.streamAll(parameters.getFirstChild(), 21).map(it -> it.getLineNo()).collect(Collectors.toList());
        if (lines.size() < 2) {
            return;
        }
        if (MethodParameterLinesCheck.allDifferent(lines)) {
            return;
        }
        if (this.allowSingleLine && MethodParameterLinesCheck.allSame(lines)) {
            return;
        }
        if (this.allowSingleLine) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAMS_LINES, new Object[0]);
        } else {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAMS_SEPARATE_LINES, new Object[0]);
        }
    }
}

