/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.google.common.collect.Streams;
import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@StatelessCheck
public class MethodParameterAlignmentCheck
extends AbstractCheck {
    public static final String MSG_PARAM_ALIGNMENT = "method.params.alignment";

    public int[] getDefaultTokens() {
        return new int[]{9, 8, 199};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        Set uniqueFirstColNumbersInLines = this.getParameters(ast).filter(Objects::nonNull).collect(Collectors.toMap(it -> it.getLineNo(), it -> it.getColumnNo(), (c1, c2) -> Math.min(c1, c2))).values().stream().collect(Collectors.toSet());
        if (uniqueFirstColNumbersInLines.size() > 1) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAM_ALIGNMENT, new Object[0]);
        }
    }

    private Stream<DetailAST> getParameters(DetailAST ast) {
        if (ast.getType() == 199) {
            DetailAST parameters = MethodParameterAlignmentCheck.getFirstChild(ast, 201);
            return MethodParameterAlignmentCheck.walkDfs(parameters.getFirstChild()).flatMap(it -> MethodParameterAlignmentCheck.walkDfs(it));
        }
        DetailAST parameters = MethodParameterAlignmentCheck.getFirstChild(ast, 20);
        return MethodParameterAlignmentCheck.walkDfs(parameters.getFirstChild());
    }

    private static Stream<DetailAST> walkDfs(DetailAST start) {
        return Streams.stream((Iterator)new DetailASTIterator(start));
    }

    private static DetailAST getFirstChild(DetailAST ast, int type) {
        DetailAST c;
        for (c = ast.getFirstChild(); c != null && c.getType() != type; c = c.getNextSibling()) {
        }
        return Objects.requireNonNull(c);
    }

    private static class DetailASTIterator
    implements Iterator<DetailAST> {
        private LinkedList<DetailAST> q = new LinkedList();

        public DetailASTIterator(DetailAST start) {
            this.q.push(start);
        }

        @Override
        public boolean hasNext() {
            return !this.q.isEmpty();
        }

        @Override
        public DetailAST next() {
            DetailAST r = this.q.pop();
            if (r == null) {
                return null;
            }
            if (r.getNextSibling() != null) {
                this.q.push(r.getNextSibling());
            }
            if (r.hasChildren()) {
                this.q.push(r.getFirstChild());
            }
            return r;
        }
    }
}

