/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import pl.tfij.checktfijstyle.checks.DetailASTUtil;

public class MethodCallParameterAlignmentCheck
extends AbstractCheck {
    public static final String MSG_PARAMS_LINES = "methodCall.params.lines-alignment";

    public int[] getDefaultTokens() {
        return new int[]{27, 43, 42, 136};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        Optional<DetailAST> params = DetailASTUtil.tryGetFirstChild(ast, 34);
        params.ifPresent(p -> {
            Map<Integer, Integer> lineToFirstArg = DetailASTUtil.streamAll(p.getFirstChild(), 28).flatMap(it -> this.findAstWithMinColumnNo((DetailAST)it).stream()).collect(Collectors.toMap(DetailAST::getLineNo, DetailAST::getColumnNo, Integer::min));
            HashSet<Integer> uniqueColumnNumbers = new HashSet<Integer>(lineToFirstArg.values());
            if (uniqueColumnNumbers.size() > 1) {
                this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAMS_LINES, new Object[0]);
            }
        });
    }

    private Optional<DetailAST> findAstWithMinColumnNo(DetailAST ast) {
        return DetailASTUtil.streamRecursively(ast).min(Comparator.comparing(DetailAST::getColumnNo));
    }
}

