/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import pl.tfij.checktfijstyle.checks.DetailASTUtil;

public class MethodCallParameterLinesCheck
extends AbstractCheck {
    public static final String MSG_PARAMS_LINES = "methodCall.params.lines";
    private final Set<MethodId> ignoreMethods = new HashSet<MethodId>();

    public void setIgnoreMethods(String ... ignoreMethod) {
        this.ignoreMethods.clear();
        this.ignoreMethods.addAll(Arrays.stream(ignoreMethod).map(MethodId::fromString).collect(Collectors.toSet()));
    }

    public int[] getDefaultTokens() {
        return new int[]{27, 43, 42, 136};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        Optional<MethodId> methodId = this.getAstMethodId(ast);
        if (methodId.isPresent() && this.ignoreMethods.contains(methodId.get())) {
            return;
        }
        Optional<DetailAST> params = DetailASTUtil.tryGetFirstChild(ast, 34);
        params.ifPresent(p -> {
            Map<Integer, Integer> paramsInLines = DetailASTUtil.streamAll(p.getFirstChild(), 28).map(DetailAST::getLineNo).collect(Collectors.toMap(it -> it, it -> 1, Integer::sum));
            if (paramsInLines.size() < 2) {
                return;
            }
            Optional<Integer> invalidLine = paramsInLines.values().stream().filter(it -> it > 1).findFirst();
            invalidLine.ifPresent(line -> this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAMS_LINES, new Object[0]));
        });
    }

    private Optional<MethodId> getAstMethodId(DetailAST ast) {
        Optional<DetailAST> ident = DetailASTUtil.tryGetFirstChild(ast, 58);
        List staticMethodWithClass = DetailASTUtil.tryGetFirstChild(ast, 59).map(DetailAST::getFirstChild).stream().flatMap(it -> DetailASTUtil.streamAll(it, 58)).collect(Collectors.toList());
        return ident.map(it -> new MethodId(null, it.getText())).or(() -> {
            if (staticMethodWithClass.size() == 2) {
                return Optional.of(new MethodId(((DetailAST)staticMethodWithClass.get(0)).getText(), ((DetailAST)staticMethodWithClass.get(1)).getText()));
            }
            return Optional.empty();
        });
    }

    private static class MethodId {
        private final String className;
        private final String methodName;

        static MethodId fromString(String string) {
            String[] split = string.split("\\.");
            if (split.length == 1) {
                return new MethodId(null, split[0]);
            }
            return new MethodId(split[0], split[1]);
        }

        @Generated
        public MethodId(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodId)) {
                return false;
            }
            MethodId other = (MethodId)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$className = this.className;
            String other$className = other.className;
            if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                return false;
            }
            String this$methodName = this.methodName;
            String other$methodName = other.methodName;
            return !(this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MethodId;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $className = this.className;
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            String $methodName = this.methodName;
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            return result;
        }
    }
}

