/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.tfij.checktfijstyle.checks.DetailASTUtil;

@StatelessCheck
public class MethodParameterAlignmentCheck
extends AbstractCheck {
    public static final String MSG_PARAM_ALIGNMENT = "method.params.lines-alignment";

    public int[] getDefaultTokens() {
        return new int[]{9, 8, 199};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        Set uniqueFirstColNumbersInLines = this.getParameters(ast).filter(Objects::nonNull).collect(Collectors.toMap(it -> it.getLineNo(), it -> it.getColumnNo(), (c1, c2) -> Math.min(c1, c2))).values().stream().collect(Collectors.toSet());
        if (uniqueFirstColNumbersInLines.size() > 1) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAM_ALIGNMENT, new Object[0]);
        }
    }

    private Stream<DetailAST> getParameters(DetailAST ast) {
        if (ast.getType() == 199) {
            DetailAST parameters = DetailASTUtil.getFirstChild(ast, 201);
            return DetailASTUtil.streamRecursively(parameters);
        }
        DetailAST parameters = DetailASTUtil.getFirstChild(ast, 20);
        return DetailASTUtil.streamRecursively(parameters);
    }
}

