/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import pl.tfij.checktfijstyle.checks.DetailASTUtil;

@StatelessCheck
public class MethodParameterLinesCheck
extends AbstractCheck {
    public static final String MSG_PARAMS_LINES = "method.params.lines";
    public static final String MSG_PARAMS_SEPARATE_LINES = "method.params.separate-lines";
    private boolean allowSingleLine = true;

    public void setAllowSingleLine(boolean allowSingleLine) {
        this.allowSingleLine = allowSingleLine;
    }

    public int[] getDefaultTokens() {
        return new int[]{9, 8, 199};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        List<Integer> lines = this.argumentLines(ast);
        if (lines.size() < 2) {
            return;
        }
        if (MethodParameterLinesCheck.allDifferent(lines)) {
            return;
        }
        if (this.allowSingleLine && MethodParameterLinesCheck.allSame(lines)) {
            return;
        }
        this.logViolationFor(ast);
    }

    private void logViolationFor(DetailAST ast) {
        if (this.allowSingleLine) {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAMS_LINES, new Object[0]);
        } else {
            this.log(ast.getLineNo(), ast.getColumnNo(), MSG_PARAMS_SEPARATE_LINES, new Object[0]);
        }
    }

    private List<Integer> argumentLines(DetailAST ast) {
        if (ast.getType() == 199) {
            DetailAST parameters = DetailASTUtil.getFirstChild(ast, 201);
            return DetailASTUtil.streamAll(parameters.getFirstChild(), 202).map(it -> it.getLineNo()).collect(Collectors.toList());
        }
        DetailAST parameters = DetailASTUtil.getFirstChild(ast, 20);
        return DetailASTUtil.streamAll(parameters.getFirstChild(), 21).map(it -> it.getLineNo()).collect(Collectors.toList());
    }

    private static boolean allDifferent(List<Integer> lines) {
        return new HashSet<Integer>(lines).size() == lines.size();
    }

    private static boolean allSame(List<Integer> lines) {
        return new HashSet<Integer>(lines).size() == 1;
    }
}

