/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.checktfijstyle.checks;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.tfij.checktfijstyle.checks.DetailASTUtil;

public class NameLengthCheck
extends AbstractCheck {
    private static final Map<Integer, String> TOKEN_TYPE_TO_MSG = Map.of(14, "nameLength.classNameToLong", 9, "nameLength.methodNameToLong", 199, "nameLength.recordNameToLong", 21, "nameLength.parameterNameToLong", 10, "nameLength.variableNameToLong", 15, "nameLength.interfaceNameToLong", 16, "nameLength.packageNameToLong", 154, "nameLength.enumClassNameToLong", 155, "nameLength.enumConstantNameToLong");
    private static final Map<Integer, Integer> TOKEN_TYPE_TO_DEFAULT_MAX_LENGTH = Map.of(14, 50, 9, 50, 199, 50, 21, 30, 10, 30, 15, 50, 16, 20, 154, 50, 155, 50);
    private final Map<Integer, Integer> customMaxLength = new HashMap<Integer, Integer>();

    public void setMaxClassNameLength(int maxLength) {
        this.customMaxLength.put(14, maxLength);
    }

    public void setMaxMethodNameLength(int maxLength) {
        this.customMaxLength.put(9, maxLength);
    }

    public void setMaxRecordNameLength(int maxLength) {
        this.customMaxLength.put(199, maxLength);
    }

    public void setMaxParameterNameLength(int maxLength) {
        this.customMaxLength.put(21, maxLength);
    }

    public void setMaxVariableNameLength(int maxLength) {
        this.customMaxLength.put(10, maxLength);
    }

    public void setMaxInterfaceNameLength(int maxLength) {
        this.customMaxLength.put(15, maxLength);
    }

    public void setMaxPackageNameLength(int maxLength) {
        this.customMaxLength.put(16, maxLength);
    }

    public void setMaxEnumClassNameLength(int maxLength) {
        this.customMaxLength.put(154, maxLength);
    }

    public void setMaxEnumConstNameLength(int maxLength) {
        this.customMaxLength.put(155, maxLength);
    }

    public int[] getDefaultTokens() {
        return new int[]{14, 9, 199, 21, 10, 15, 16, 154, 155};
    }

    public int[] getAcceptableTokens() {
        return this.getDefaultTokens();
    }

    public int[] getRequiredTokens() {
        return this.getDefaultTokens();
    }

    public void visitToken(DetailAST ast) {
        if (ast.getType() == 9) {
            this.methodNameVerification(ast);
        } else if (ast.getType() == 16) {
            this.packageNameVerification(ast);
        } else {
            this.regularIdentifierVerification(ast);
        }
    }

    private void methodNameVerification(DetailAST ast) {
        if (this.isMethodAnnotatedByOverride(ast)) {
            return;
        }
        this.regularIdentifierVerification(ast);
    }

    private void packageNameVerification(DetailAST ast) {
        Optional<String> toLongPackageSegmentName = DetailASTUtil.streamRecursively(ast).filter(it -> it.getType() == 58).map(it -> it.getText()).filter(it -> it.length() > this.maxLengthFor(ast)).findFirst();
        toLongPackageSegmentName.ifPresent(it -> this.log(ast.getLineNo(), ast.getColumnNo(), TOKEN_TYPE_TO_MSG.get(ast.getType()), new Object[]{it, it.length(), this.maxLengthFor(ast)}));
    }

    private void regularIdentifierVerification(DetailAST ast) {
        DetailAST firstChild = DetailASTUtil.getFirstChild(ast, 58);
        String intentName = firstChild.getText();
        if (intentName.length() > this.maxLengthFor(ast)) {
            this.log(ast.getLineNo(), ast.getColumnNo(), TOKEN_TYPE_TO_MSG.get(ast.getType()), new Object[]{intentName, intentName.length(), this.maxLengthFor(ast)});
        }
    }

    private Integer maxLengthFor(DetailAST ast) {
        return this.customMaxLength.getOrDefault(ast.getType(), TOKEN_TYPE_TO_DEFAULT_MAX_LENGTH.get(ast.getType()));
    }

    private boolean isMethodAnnotatedByOverride(DetailAST ast) {
        Stream<DetailAST> methodModifiers = DetailASTUtil.tryGetFirstChild(ast, 5).map(it -> DetailASTUtil.stream(it.getFirstChild())).orElse(Stream.empty());
        Stream<DetailAST> methodAnnotations = methodModifiers.filter(it -> it.getType() == 159);
        return methodAnnotations.anyMatch(this::isOverrideAnnotation);
    }

    private boolean isOverrideAnnotation(DetailAST annotationAst) {
        List annotationAstElements = DetailASTUtil.stream(annotationAst.getFirstChild()).collect(Collectors.toList());
        if (annotationAstElements.size() >= 2) {
            return "@".equals(((DetailAST)annotationAstElements.get(0)).getText()) && "Override".equals(((DetailAST)annotationAstElements.get(1)).getText());
        }
        return false;
    }
}

