/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.test.modulesize;

import java.util.List;
import pl.tfij.test.modulesize.FileInModule;

record ModulePartialSummary(FileInModule.Module module, int numberOfFiles, int moduleLinesOfCode, int projectLinesOfCode) {
    static ModulePartialSummary aggregate(List<FileInModule> fileInModules, int projectLinesOfCode) {
        FileInModule.Module module = fileInModules.get(0).module().orElse(FileInModule.Module.UNDEFINED_MODULE);
        int numberOfFiles = fileInModules.size();
        int totalLinesOfCode = fileInModules.stream().mapToInt(it -> it.lineOfCode()).sum();
        return new ModulePartialSummary(module, numberOfFiles, totalLinesOfCode, projectLinesOfCode);
    }

    double relativeModuleSize() {
        return 1.0 * (double)this.moduleLinesOfCode / (double)this.projectLinesOfCode;
    }
}

