/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.test.modulesize;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.tfij.test.modulesize.FileInModule;
import pl.tfij.test.modulesize.ModulePartialSummary;
import pl.tfij.test.modulesize.ModuleSizeCalculatorException;
import pl.tfij.test.modulesize.ProjectSummary;

public class ModuleSizeCalculator {
    private final List<FileInModule.Module> modules;
    private final String rootDir;
    private final Set<String> includeOnlyFilesWithExtension;

    ModuleSizeCalculator(List<FileInModule.Module> modules, String rootDir, Set<String> includeOnlyFilesWithExtension) {
        this.includeOnlyFilesWithExtension = includeOnlyFilesWithExtension;
        this.modules = modules;
        this.rootDir = rootDir;
    }

    public static ModuleSizeCalculatorBuilder project(String rootDir) {
        return new ModuleSizeCalculatorBuilder(rootDir);
    }

    private Map<FileInModule.Module, ModulePartialSummary> calculate() {
        List<FileInModule> pathStream = ModuleSizeCalculator.getAllFilesInDirectory(Paths.get(this.rootDir, new String[0])).stream().filter(this::includeFile).map(it -> new FileInModule(it.toString(), this.matchModule((Path)it, this.modules), ModuleSizeCalculator.countLines(it))).toList();
        int projectLinesOfCode = pathStream.stream().mapToInt(it -> it.lineOfCode()).sum();
        return pathStream.stream().collect(Collectors.groupingBy(it -> it.module())).values().stream().map(it -> ModulePartialSummary.aggregate(it, projectLinesOfCode)).collect(Collectors.toMap(it -> it.module(), it -> it));
    }

    private boolean includeFile(Path path) {
        if (this.includeOnlyFilesWithExtension.isEmpty()) {
            return true;
        }
        return this.includeOnlyFilesWithExtension.contains(ModuleSizeCalculator.getFileExtension(path));
    }

    private static String getFileExtension(Path path) {
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex == -1 || dotIndex == fileName.length() - 1) {
            return "";
        }
        return fileName.substring(dotIndex + 1);
    }

    private Optional<FileInModule.Module> matchModule(Path file, List<FileInModule.Module> modules) {
        return modules.stream().flatMap(it -> it.definedModule().stream()).filter(module -> ModuleSizeCalculator.isSubpath(file, module.moduleDir())).map(it -> it).findFirst();
    }

    private static boolean isSubpath(Path path1, Path path2) {
        if (path1.getNameCount() < path2.getNameCount()) {
            return false;
        }
        Path subpath = path1.subpath(0, path2.getNameCount());
        return subpath.equals(path2);
    }

    private static List<Path> getAllFilesInDirectory(Path directory) {
        List<Path> list;
        block8: {
            Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);
            try {
                list = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new ModuleSizeCalculatorException("Error occur on scanning project in `%s` directory.".formatted(directory.toAbsolutePath()), ex);
                }
            }
            paths.close();
        }
        return list;
    }

    private static int countLines(Path filePath) {
        try {
            int lineCount = 0;
            try (BufferedReader reader = Files.newBufferedReader(filePath);){
                while (reader.readLine() != null) {
                    ++lineCount;
                }
            }
            return lineCount;
        }
        catch (IOException ex) {
            throw new ModuleSizeCalculatorException("Error occur on counting lines of `%s` file.".formatted(filePath), ex);
        }
    }

    public static class ModuleSizeCalculatorBuilder {
        private final String rootDir;
        private final List<FileInModule.Module> modules = new ArrayList<FileInModule.Module>();
        private final Set<String> includeOnlyFilesWithExtension = new HashSet<String>();

        ModuleSizeCalculatorBuilder(String rootDir) {
            this.rootDir = rootDir;
        }

        public ModuleSizeCalculatorBuilder withModule(String modulePackage) {
            FileInModule.DefinedModule module = new FileInModule.DefinedModule(modulePackage, Paths.get(this.rootDir + "/" + modulePackage.replaceAll("\\.", "/"), new String[0]));
            this.modules.add(module);
            return this;
        }

        public ModuleSizeCalculatorBuilder withDirModule(String path) {
            this.modules.add(new FileInModule.DefinedModule(path, Paths.get(this.rootDir + "/" + path, new String[0])));
            return this;
        }

        public ModuleSizeCalculatorBuilder include(String ... fileExtension) {
            this.includeOnlyFilesWithExtension.addAll(Arrays.asList(fileExtension));
            return this;
        }

        public ProjectSummary analyze() {
            ModuleSizeCalculator moduleSizeCalculator = new ModuleSizeCalculator(this.modules, this.rootDir, this.includeOnlyFilesWithExtension);
            Map<FileInModule.Module, ModulePartialSummary> analyzedModules = moduleSizeCalculator.calculate();
            return new ProjectSummary(this.modules, analyzedModules);
        }
    }
}

