/*
 * Decompiled with CFR 0.152.
 */
package pl.tfij.test.modulesize;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import pl.tfij.test.modulesize.FileInModule;
import pl.tfij.test.modulesize.ModulePartialSummary;
import pl.tfij.test.modulesize.ModuleSizeCalculatorException;

public class ProjectSummary {
    private final List<FileInModule.Module> definedModules;
    private final Map<FileInModule.Module, ModulePartialSummary> analyzedModules;
    private final DecimalFormat decimalFormat;

    ProjectSummary(List<FileInModule.Module> modules, Map<FileInModule.Module, ModulePartialSummary> analyzedModules) {
        this.definedModules = modules;
        this.analyzedModules = analyzedModules;
        this.decimalFormat = this.numberFormatter();
    }

    private DecimalFormat numberFormatter() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        return new DecimalFormat("#.####", symbols);
    }

    public ProjectSummary verifyNoEmptyModules() {
        Optional<FileInModule.Module> emptyModule = this.definedModules.stream().filter(it -> !this.analyzedModules.containsKey(it)).findFirst();
        emptyModule.ifPresent(module -> {
            throw new AssertionError((Object)"Module `%s` is empty.".formatted(module.name()));
        });
        return this;
    }

    public ProjectSummary verifyEachModuleRelativeSizeIsSmallerThan(double threshold) {
        this.verifyRelativeSizeThreshold(threshold);
        Comparator<ModulePartialSummary> comparing = Comparator.comparing(ModulePartialSummary::relativeModuleSize);
        Optional<ModulePartialSummary> biggestModule = this.analyzedModules.values().stream().max(comparing);
        biggestModule.ifPresent(summary -> {
            if (summary.relativeModuleSize() > threshold) {
                throw new AssertionError((Object)"Module `%s` relative size is %s. Max allowed size is %s.".formatted(summary.module().name(), this.decimalFormat.format(summary.relativeModuleSize()), this.decimalFormat.format(threshold)));
            }
        });
        return this;
    }

    public ProjectSummary verifyModuleRelativeSizeIsSmallerThan(String module, double threshold) {
        Optional<FileInModule.Module> definedModule = this.definedModules.stream().filter(it -> Objects.equals(it.name(), module)).findFirst();
        if (definedModule.isEmpty()) {
            throw new IllegalArgumentException("Module `%s` was not defined.".formatted(module));
        }
        this.verifyRelativeSizeThreshold(threshold);
        Optional.ofNullable(this.analyzedModules.get(definedModule.get())).ifPresent(moduleSummary -> {
            if (moduleSummary.relativeModuleSize() > threshold) {
                throw new AssertionError((Object)"Module `%s` relative size is %s. Max allowed size is %s.".formatted(moduleSummary.module().name(), this.decimalFormat.format(moduleSummary.relativeModuleSize()), this.decimalFormat.format(threshold)));
            }
        });
        return this;
    }

    private void verifyRelativeSizeThreshold(double threshold) {
        if (threshold <= 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException("Threshold must be positive number in range (0, 1]. Given value is %s.".formatted(this.decimalFormat.format(threshold)));
        }
    }

    public ProjectSummary verifyUndefinedModuleNumberOfFilesIsSmallerThan(int allowedFileCount) {
        if (allowedFileCount < 0) {
            throw new IllegalArgumentException("allowedFileCount must be positive number or zero. Give value is %s.".formatted(allowedFileCount));
        }
        Optional.ofNullable(this.analyzedModules.get(FileInModule.Module.UNDEFINED_MODULE)).ifPresent(it -> {
            if (it.numberOfFiles() > allowedFileCount) {
                throw new AssertionError((Object)"Number of files in undefined moduleName is %s. Max allowed count is %s.".formatted(it.numberOfFiles(), allowedFileCount));
            }
        });
        return this;
    }

    public String createMermaidPieChart() {
        String pieChartHeader = "pie showData title Modules size (Total LOC: %d)\n".formatted(this.linesOfCode());
        String pieChartData = this.analyzedModules.values().stream().sorted(Comparator.comparing(it -> it.module().name())).map(it -> "    \"%s\" : %s".formatted(it.module().name(), it.moduleLinesOfCode())).collect(Collectors.joining("\n"));
        return pieChartHeader + pieChartData;
    }

    public ProjectSummary saveMermaidPieChart(Path target) {
        ProjectSummary projectSummary;
        if (target == null) {
            throw new IllegalArgumentException("The target argument must be not null.");
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter(target.toFile()));
        try {
            String mermaidPieChart = this.createMermaidPieChart();
            writer.write(mermaidPieChart);
            projectSummary = this;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ModuleSizeCalculatorException("IO error occur on saving mermaid chart to %s.".formatted(target.toAbsolutePath()), ex);
            }
        }
        writer.close();
        return projectSummary;
    }

    public List<ModuleSummary> modulesSummary() {
        return this.analyzedModules.values().stream().map(it -> new ModuleSummary(it.module().name(), it.numberOfFiles(), it.moduleLinesOfCode(), it.relativeModuleSize())).toList();
    }

    public int numberOfFiles() {
        return this.analyzedModules.values().stream().mapToInt(it -> it.numberOfFiles()).sum();
    }

    public int linesOfCode() {
        return this.analyzedModules.values().stream().mapToInt(it -> it.moduleLinesOfCode()).sum();
    }

    public record ModuleSummary(String moduleName, int numberOfFiles, int linesOfCode, double relativeSize) {
    }
}

