/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.cxf.interceptors;

import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import pl.touk.cxf.interceptors.CorrelationContext;
import pl.touk.cxf.interceptors.NonWsdlAbstractPhaseInterceptor;
import pl.touk.cxf.interceptors.correlation.Correlation;

public class CorrelationIdInInterceptor
extends NonWsdlAbstractPhaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(CorrelationIdInInterceptor.class);
    private final CorrelationContext context;

    public CorrelationIdInInterceptor(CorrelationContext context) {
        super("receive");
        this.context = context;
    }

    @Override
    public void processMessage(Message message) throws Fault {
        String correlationIdFromHeaders = this.getCorrelationIdFromHeaders(message);
        if (this.context.getCorrelationIdProvider() != null) {
            this.context.getCorrelationIdProvider().start(correlationIdFromHeaders);
            return;
        }
        String correlationIdFromMdc = MDC.get((String)this.context.getMdcCorrelationIdName());
        if (correlationIdFromHeaders == null && correlationIdFromMdc == null) {
            this.addNewCorrelationId();
        } else if (correlationIdFromHeaders != null && correlationIdFromMdc != null) {
            this.chooseCorrelationIdWhenBothArePresent(correlationIdFromMdc, correlationIdFromHeaders);
        } else if (correlationIdFromMdc != null) {
            log.warn("using {} from MDC: {}", (Object)this.context.getMdcCorrelationIdName(), (Object)correlationIdFromMdc);
        } else {
            this.addCorrelationIdFromHeaders(correlationIdFromHeaders);
        }
    }

    private String getCorrelationIdFromHeaders(Message message) {
        List correlationIds;
        Map headers = CastUtils.cast((Map)((Map)message.get((Object)Message.PROTOCOL_HEADERS)));
        if (headers != null && (correlationIds = (List)headers.get(this.context.getHttpHeaderCorrelationIdName())) != null && correlationIds.size() == 1) {
            return (String)correlationIds.get(0);
        }
        log.debug("{} not found in headers", (Object)this.context.getHttpHeaderCorrelationIdName());
        return null;
    }

    private void addNewCorrelationId() {
        String correlationId = Correlation.generateNew();
        log.debug("{} not found in MDC nor headers, generated new one: {}", (Object)this.context.getMdcCorrelationIdName(), (Object)correlationId);
        MDC.put((String)this.context.getMdcCorrelationIdName(), (String)correlationId);
    }

    private void chooseCorrelationIdWhenBothArePresent(String correlationIdFromMdc, String correlationIdFromHeaders) {
        if (!correlationIdFromHeaders.equals(correlationIdFromMdc)) {
            log.warn("{} from headers and MDC mismatch, from header={}, from MDC={}, choosing from headers", new Object[]{this.context.getMdcCorrelationIdName(), correlationIdFromHeaders, correlationIdFromMdc});
            MDC.put((String)this.context.getMdcCorrelationIdName(), (String)correlationIdFromHeaders);
        }
    }

    private void addCorrelationIdFromHeaders(String correlationIdFromHeaders) {
        MDC.put((String)this.context.getMdcCorrelationIdName(), (String)correlationIdFromHeaders);
    }
}

