/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.cxf.interceptors;

import java.util.Arrays;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NonWsdlAbstractPhaseInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger log = LoggerFactory.getLogger(NonWsdlAbstractPhaseInterceptor.class);

    public NonWsdlAbstractPhaseInterceptor(String phase) {
        super(phase);
    }

    public abstract void processMessage(Message var1);

    public void handleMessage(Message message) throws Fault {
        if (NonWsdlAbstractPhaseInterceptor.isWsdl(message)) {
            log.trace("wsdl message received so skipping interceptor");
            return;
        }
        this.processMessage(message);
    }

    private static boolean isWsdl(Message message) {
        String queryString = (String)message.get((Object)Message.QUERY_STRING);
        return queryString != null && Arrays.stream(queryString.split("&")).anyMatch("wsdl"::equals);
    }
}

