/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.cxf.interceptors.logging;

import java.util.Optional;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.annotations.Logging;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import pl.touk.cxf.interceptors.logging.LoggingInInterceptor;
import pl.touk.cxf.interceptors.logging.LoggingOutInterceptor;

@NoJSR250Annotations
@Provider(value=Provider.Type.Feature)
public class LoggingFeature
extends AbstractFeature {
    private static final int DEFAULT_LIMIT = 49152;
    private final LoggingInInterceptor IN;
    private final LoggingOutInterceptor OUT;
    private String inLocation;
    private String outLocation;
    private boolean prettyLogging;
    private boolean showBinary;
    private final Logger logger;
    private int limit = 49152;

    public LoggingFeature() {
        this((String)null);
    }

    public LoggingFeature(String loggerName) {
        this(loggerName, -1);
    }

    public LoggingFeature(String loggerName, int lim) {
        this.logger = Optional.ofNullable(loggerName).map(Logger::getLogger).orElse(null);
        this.limit = lim;
        this.IN = new LoggingInInterceptor(lim, this.logger);
        this.OUT = new LoggingOutInterceptor(lim, this.logger);
    }

    public LoggingFeature(Logging annotation) {
        this.inLocation = annotation.inLocation();
        this.outLocation = annotation.outLocation();
        this.limit = annotation.limit();
        this.prettyLogging = annotation.pretty();
        this.showBinary = annotation.showBinary();
        this.logger = null;
        this.IN = new LoggingInInterceptor(-1);
        this.OUT = new LoggingOutInterceptor(-1, null);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        if (this.limit == 49152 && this.inLocation == null && this.outLocation == null && !this.prettyLogging) {
            provider.getInInterceptors().add(this.IN);
            provider.getInFaultInterceptors().add(this.IN);
            provider.getOutInterceptors().add(this.OUT);
            provider.getOutFaultInterceptors().add(this.OUT);
        } else {
            LoggingInInterceptor in = new LoggingInInterceptor(this.limit, this.logger);
            in.setOutputLocation(this.inLocation);
            in.setPrettyLogging(this.prettyLogging);
            in.setShowBinaryContent(this.showBinary);
            LoggingOutInterceptor out = new LoggingOutInterceptor(this.limit, this.logger);
            out.setOutputLocation(this.outLocation);
            out.setPrettyLogging(this.prettyLogging);
            out.setShowBinaryContent(this.showBinary);
            provider.getInInterceptors().add(in);
            provider.getInFaultInterceptors().add(in);
            provider.getOutInterceptors().add(out);
            provider.getOutFaultInterceptors().add(out);
        }
    }

    public void setLimit(int lim) {
        this.limit = lim;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isPrettyLogging() {
        return this.prettyLogging;
    }

    public void setPrettyLogging(boolean prettyLogging) {
        this.prettyLogging = prettyLogging;
    }
}

