/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.cxf.interceptors.threadname;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.cxf.interceptors.NonWsdlAbstractPhaseInterceptor;
import pl.touk.cxf.interceptors.threadname.ThreadNameContext;

public class ThreadNameInInterceptor
extends NonWsdlAbstractPhaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ThreadNameInInterceptor.class);
    private final ThreadNameContext context;

    public ThreadNameInInterceptor(ThreadNameContext context) {
        super("receive");
        this.context = context;
    }

    @Override
    public void processMessage(Message message) throws Fault {
        String oldThreadName = Thread.currentThread().getName();
        String newThreadName = this.context.getThreadNamePolicy().apply(oldThreadName);
        log.debug("Setting new thread name {} for thread {}", (Object)newThreadName, (Object)oldThreadName);
        Thread.currentThread().setName(newThreadName);
        message.getExchange().put((Object)this.context.getOldNameContextProperty(), (Object)oldThreadName);
    }
}

