/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.cxf.interceptors.threadname;

import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.cxf.interceptors.NonWsdlAbstractPhaseInterceptor;
import pl.touk.cxf.interceptors.threadname.ThreadNameContext;

public class ThreadNameOutInterceptor
extends NonWsdlAbstractPhaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ThreadNameOutInterceptor.class);
    private final ThreadNameContext context;

    public ThreadNameOutInterceptor(ThreadNameContext context) {
        super("setup-ending");
        this.context = context;
    }

    @Override
    public void processMessage(Message message) throws Fault {
        String oldThreadName = (String)message.getExchange().get((Object)this.context.getOldNameContextProperty());
        log.debug("Setting old thread name {} for thread {}", (Object)oldThreadName, (Object)Thread.currentThread().getName());
        Thread.currentThread().setName(oldThreadName);
    }
}

