/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.dockds;

import java.util.Arrays;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;
import pl.touk.dockds.DockerizedDataSource;
import pl.touk.dockds.DockerizedDatabase;

@Configuration
public class DockerizedDataSourceAutoConfiguration
implements BeanClassLoaderAware {
    private ClassLoader classLoader;

    @Bean
    @ConditionalOnProperty(prefix="spring.datasource", name={"url"}, havingValue="false", matchIfMissing=true)
    public DataSource dataSource() throws Exception {
        DockerizedDatabase databaseConnection = Arrays.stream(DockerizedDatabase.values()).filter(ddc -> ClassUtils.isPresent((String)ddc.getDriverClass(), (ClassLoader)this.classLoader)).findFirst().orElseThrow(ClassNotFoundException::new);
        return new DockerizedDataSource(databaseConnection);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }
}

