/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.dockds;

import com.spotify.docker.client.DefaultDockerClient;
import com.spotify.docker.client.DockerClient;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.HostConfig;
import com.spotify.docker.client.messages.NetworkSettings;
import java.io.IOException;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.util.CollectionUtils;
import pl.touk.dockds.DockerizedDatabase;

public class DockerizedDataSource
extends DelegatingDataSource {
    private static final Logger log = LoggerFactory.getLogger(DockerizedDataSource.class);
    public static final String CONTAINER_NAME_PREFIX = "dockds-";
    protected final DockerizedDatabase type;
    protected final DockerClient docker;
    protected ContainerInfo containerInfo;

    public DockerizedDataSource(DockerizedDatabase type) throws Exception {
        this.type = type;
        this.docker = DefaultDockerClient.fromEnv().build();
    }

    @PostConstruct
    public void startDatabseInContainer() throws Exception {
        this.checkStaleContainers();
        this.createContainer();
        this.waitForDatabaseStart(this.getDatabaseUrl(), this.type.getUsername(), this.type.getPassword());
        this.setTargetDataSource(DataSourceBuilder.create().username(this.type.getUsername()).password(this.type.getPassword()).url(this.getDatabaseUrl()).build());
    }

    @PreDestroy
    public void destroyContainer() throws Exception {
        this.docker.stopContainer(this.containerInfo.id(), 30);
        this.docker.removeContainer(this.containerInfo.id(), new DockerClient.RemoveContainerParam[]{DockerClient.RemoveContainerParam.removeVolumes()});
    }

    protected void checkStaleContainers() throws DockerException, InterruptedException {
        Long staleContainersCount = this.docker.listContainers(new DockerClient.ListContainersParam[]{DockerClient.ListContainersParam.allContainers()}).stream().flatMap(c -> c.names().stream()).filter(name -> name.startsWith("/dockds-")).peek(arg_0 -> ((Logger)log).debug(arg_0)).collect(Collectors.counting());
        log.warn("Found {} probably stale containers. Consider removing them.", (Object)staleContainersCount);
    }

    protected void createContainer() throws DockerException, InterruptedException, IOException {
        log.info("Creating database container");
        HostConfig hostConfig = HostConfig.builder().publishAllPorts(Boolean.valueOf(true)).build();
        ContainerConfig containerConfig = ContainerConfig.builder().env(this.type.getEnv()).image(this.type.getImage()).hostConfig(hostConfig).build();
        ContainerCreation containerCreation = this.docker.createContainer(containerConfig, CONTAINER_NAME_PREFIX + UUID.randomUUID());
        if (!CollectionUtils.isEmpty((Collection)containerCreation.getWarnings())) {
            containerCreation.getWarnings().forEach(arg_0 -> ((Logger)log).warn(arg_0));
        }
        this.docker.startContainer(containerCreation.id());
        this.containerInfo = this.docker.inspectContainer(containerCreation.id());
    }

    protected void waitForDatabaseStart(String url, String username, String password) throws InterruptedException, SQLException {
        for (int i = 0; i < 10; ++i) {
            try {
                if (DriverManager.getConnection(url, username, password).isValid(10)) {
                    log.info("Database container seems to have started");
                    return;
                }
            }
            catch (SQLException e) {
                Thread.sleep(3000L);
            }
            log.info("Waiting for the container to start up...");
        }
        log.error("Database container has probably not started");
    }

    public String getDatabaseUrl() {
        return Optional.ofNullable(this.containerInfo).map(ContainerInfo::networkSettings).map(NetworkSettings::ports).flatMap(ports -> ports.entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).findFirst()).map(a -> this.type.getUrl().expand(new Object[]{a.hostIp(), a.hostPort()}).toUriString()).get();
    }
}

