/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.jshint4j;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import pl.touk.jshint4j.Error;

public class JsHint {
    private static final String JSHINT_JS = "jshint.js";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Error> lint(String source, String options) {
        if (source == null) {
            throw new NullPointerException("Source must not be null.");
        }
        Context cx = Context.enter();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            this.evaluateJSHint(cx, (Scriptable)scope);
            List<Error> list = this.lint(cx, (Scriptable)scope, source, options);
            return list;
        }
        finally {
            Context.exit();
        }
    }

    private List<Error> lint(Context cx, Scriptable scope, String source, String options) {
        ArrayList<Error> errors = new ArrayList<Error>();
        Function jsHintFunction = (Function)scope.get("JSHINT", scope);
        Object jsHintOptions = options == null ? null : cx.evaluateString(scope, "options = " + options, null, 1, null);
        jsHintFunction.call(cx, scope, scope, new Object[]{source, jsHintOptions});
        List jsErrors = (List)jsHintFunction.get("errors", (Scriptable)jsHintFunction);
        for (Map jsError : jsErrors) {
            if (jsError == null) continue;
            errors.add(this.toError(jsError));
        }
        return errors;
    }

    private Error toError(Map<String, ?> jsError) {
        return new Error(Context.toString(jsError.get("id")), Context.toString(jsError.get("raw")), Context.toString(jsError.get("code")), Context.toString(jsError.get("evidence")), (int)Context.toNumber(jsError.get("line")), (int)Context.toNumber(jsError.get("character")), Context.toString(jsError.get("scope")), Context.toString(jsError.get("reason")));
    }

    private void evaluateJSHint(Context cx, Scriptable scope) {
        String jsHintName = JSHINT_JS;
        InputStreamReader reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(jsHintName));
        try {
            cx.evaluateReader(scope, (Reader)reader, jsHintName, 1, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

