/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.krush.model;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.touk.krush.model.EntityDefinition;
import pl.touk.krush.model.IdDefinition;
import pl.touk.krush.model.PropertyDefinition;
import pl.touk.krush.model.Type;
import pl.touk.krush.model.ValidationErrorMessage;
import pl.touk.krush.model.ValidationResult;
import pl.touk.krush.model.Validator;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpl/touk/krush/model/EntityIdTypeValidator;", "Lpl/touk/krush/model/Validator;", "Lpl/touk/krush/model/EntityDefinition;", "()V", "supportedIdTypes", "", "Lpl/touk/krush/model/Type;", "validate", "Lpl/touk/krush/model/ValidationResult;", "el", "annotation-processor"})
public final class EntityIdTypeValidator
implements Validator<EntityDefinition> {
    private final List<Type> supportedIdTypes = CollectionsKt.listOf((Object[])new Type[]{new Type("kotlin", "String", null, 4, null), new Type("kotlin", "Long", null, 4, null), new Type("kotlin", "Int", null, 4, null), new Type("kotlin", "Short", null, 4, null), new Type("java.util", "UUID", null, 4, null)});

    @Override
    @NotNull
    public ValidationResult validate(@NotNull EntityDefinition el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        IdDefinition idDefinition = el.getId();
        Intrinsics.checkNotNull((Object)idDefinition);
        Iterable $this$forEach$iv = idDefinition.getProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyDefinition prop = (PropertyDefinition)element$iv;
            boolean bl = false;
            if (prop.getConverter() != null || prop.isEnumerated() || this.supportedIdTypes.contains(prop.getType())) continue;
            return new ValidationResult.Error(new ValidationErrorMessage("Entity " + el.getQualifiedName() + " id type " + prop.getType() + " is unsupported. Use property converter instead."));
        }
        return ValidationResult.Success.INSTANCE;
    }
}

