/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.krush.source;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.ClassNames;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import com.squareup.kotlinpoet.metadata.KotlinPoetMetadata;
import com.squareup.kotlinpoet.metadata.KotlinPoetMetadataPreview;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.persistence.JoinColumn;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Table;
import pl.touk.krush.env.TypeEnvironment;
import pl.touk.krush.meta.ExtKt;
import pl.touk.krush.model.AssociationDefinition;
import pl.touk.krush.model.AssociationType;
import pl.touk.krush.model.ConverterDefinition;
import pl.touk.krush.model.EmbeddableDefinition;
import pl.touk.krush.model.EntityDefinition;
import pl.touk.krush.model.EntityDefinitionKt;
import pl.touk.krush.model.EnumeratedDefinition;
import pl.touk.krush.model.IdDefinition;
import pl.touk.krush.model.PropertyDefinition;
import pl.touk.krush.source.SourceGenerator;
import pl.touk.krush.source.TablesGenerator$WhenMappings;
import pl.touk.krush.source.TablesGeneratorKt;
import pl.touk.krush.validation.AssociationTargetEntityNotFoundException;
import pl.touk.krush.validation.IdTypeNotSupportedException;
import pl.touk.krush.validation.MissingIdException;
import pl.touk.krush.validation.PropertyTypeNotSupportedException;
import pl.touk.krush.validation.TypeConverterNotSupportedException;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J0\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u001b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J(\u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010'\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\rH\u0002J\u0016\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\rH\u0002JX\u0010-\u001a\u00020.2\u0016\u0010/\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f00j\u0002`12&\u00102\u001a\"\u0012\u0004\u0012\u00020 \u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f00j\u0002`100j\u0002`32\u0006\u00104\u001a\u00020 2\u0006\u00105\u001a\u00020\u0013H\u0016J \u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\r2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020 H\u0002J \u0010;\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00107\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010<\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020 H\u0002J\u0010\u0010>\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010?\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010@\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\rH\u0002\u00a8\u0006A"}, d2={"Lpl/touk/krush/source/TablesGenerator;", "Lpl/touk/krush/source/SourceGenerator;", "()V", "addAssociationProperty", "", "assoc", "Lpl/touk/krush/model/AssociationDefinition;", "tableSpec", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "addEmbeddedTableProperty", "embeddable", "Lpl/touk/krush/model/EmbeddableDefinition;", "column", "Lpl/touk/krush/model/PropertyDefinition;", "entity", "Lpl/touk/krush/model/EntityDefinition;", "fileSpec", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "typeEnvironment", "Lpl/touk/krush/env/TypeEnvironment;", "addInsertFunc", "entityType", "Ljavax/lang/model/element/TypeElement;", "addManyToManyAssociationTable", "id", "Lpl/touk/krush/model/IdDefinition;", "targetEntity", "addTableProperty", "associationInitializer", "Lcom/squareup/kotlinpoet/CodeBlock;", "idProp", "idName", "", "converterFunc", "name", "type", "Lcom/squareup/kotlinpoet/TypeName;", "converter", "Lpl/touk/krush/model/ConverterDefinition;", "converterPropInitializer", "property", "entityAssocParams", "", "Lcom/squareup/kotlinpoet/ParameterSpec;", "enumPropInitializer", "generate", "Lcom/squareup/kotlinpoet/FileSpec;", "graph", "", "Lpl/touk/krush/model/EntityGraph;", "graphs", "Lpl/touk/krush/model/EntityGraphs;", "packageName", "typeEnv", "idCodeBlock", "prop", "entityName", "Ljavax/lang/model/element/Name;", "columnName", "idInitializer", "manyToManyPropertyInitializer", "differentiator", "primaryKeyInitializer", "propertyInitializer", "typePropInitializer", "annotation-processor"})
@KotlinPoetMetadataPreview
public final class TablesGenerator
implements SourceGenerator {
    @Override
    @NotNull
    public FileSpec generate(@NotNull Map<TypeElement, EntityDefinition> graph, @NotNull Map<String, Map<TypeElement, EntityDefinition>> graphs, @NotNull String packageName, @NotNull TypeEnvironment typeEnv) {
        boolean isJsonbUsed;
        FileSpec.Builder fileSpec;
        block9: {
            boolean bl;
            Intrinsics.checkNotNullParameter(graph, (String)"graph");
            Intrinsics.checkNotNullParameter(graphs, (String)"graphs");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            Intrinsics.checkNotNullParameter((Object)typeEnv, (String)"typeEnv");
            fileSpec = FileSpec.Companion.builder(packageName, "tables").addImport("org.jetbrains.exposed.sql", new String[]{"Table", "insert"}).addImport("org.jetbrains.exposed.sql.java-time", new String[]{"date", "datetime", "timestamp"}).addImport("pl.touk.krush", new String[]{"stringWrapper", "longWrapper", "instantWrapper", "zonedDateTime", "booleanWrapper"});
            Map<TypeElement, EntityDefinition> $this$any$iv = graph;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Map<TypeElement, EntityDefinition> map2 = $this$any$iv;
                boolean bl2 = false;
                Iterator<Map.Entry<TypeElement, EntityDefinition>> iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    boolean bl3;
                    block8: {
                        Map.Entry<TypeElement, EntityDefinition> element$iv;
                        Map.Entry<TypeElement, EntityDefinition> $dstr$_u24__u24$entity = element$iv = iterator.next();
                        boolean bl4 = false;
                        Map.Entry<TypeElement, EntityDefinition> entry = $dstr$_u24__u24$entity;
                        boolean bl5 = false;
                        EntityDefinition entity = entry.getValue();
                        Iterable $this$any$iv2 = entity.getProperties();
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                PropertyDefinition it = (PropertyDefinition)element$iv2;
                                boolean bl6 = false;
                                javax.persistence.Column column = it.getColumn();
                                if (!Intrinsics.areEqual((Object)(column != null ? column.columnDefinition() : null), (Object)"jsonb")) continue;
                                bl3 = true;
                                break block8;
                            }
                            bl3 = false;
                        }
                    }
                    if (!bl3) continue;
                    bl = true;
                    break block9;
                }
                bl = isJsonbUsed = false;
            }
        }
        if (isJsonbUsed) {
            fileSpec.addImport("pl.touk.krush", new String[]{"jsonb"});
        }
        Iterable $this$forEach$iv = EntityDefinitionKt.allAssociations(graph);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeElement entity = (TypeElement)element$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)EntityDefinitionKt.getPackageName(entity), (Object)packageName) ^ true)) continue;
            fileSpec.addImport(EntityDefinitionKt.getPackageName(entity), new String[]{entity.getSimpleName() + "Table"});
        }
        EntityDefinitionKt.traverse(graph, (Function2<? super TypeElement, ? super EntityDefinition, Unit>)((Function2)new Function2<TypeElement, EntityDefinition, Unit>(this, fileSpec, typeEnv, graphs){
            final /* synthetic */ TablesGenerator this$0;
            final /* synthetic */ FileSpec.Builder $fileSpec;
            final /* synthetic */ TypeEnvironment $typeEnv;
            final /* synthetic */ Map $graphs;

            public final void invoke(@NotNull TypeElement entityType, @NotNull EntityDefinition entity) {
                AssociationDefinition it;
                T element$iv$iv;
                Iterable $this$filterTo$iv$iv;
                TypeSpec.Builder tableSpec;
                block14: {
                    block13: {
                        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
                        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                        tableSpec = TypeSpec.Companion.objectBuilder(entity.getName() + "Table").superclass(Reflection.getOrCreateKotlinClass(Table.class)).addSuperclassConstructorParameter(CodeBlock.Companion.of("%S", new Object[]{entity.getTable()}));
                        IdDefinition idDefinition = entity.getId();
                        if (idDefinition == null) break block13;
                        IdDefinition idDefinition2 = idDefinition;
                        boolean bl = false;
                        boolean bl2 = false;
                        IdDefinition id = idDefinition2;
                        boolean bl3 = false;
                        Iterable $this$forEach$iv = id.getProperties();
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            PropertyDefinition prop = (PropertyDefinition)element$iv;
                            boolean bl4 = false;
                            ClassName typeName = new ClassName(prop.getType().getPackageName(), new String[]{prop.getType().getSimpleName()});
                            ParameterizedTypeName type = ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Column.class)), new TypeName[]{(TypeName)typeName});
                            PropertySpec.Builder idSpec = PropertySpec.Companion.builder(id.propName(prop), (TypeName)type, new KModifier[0]);
                            CodeBlock.Builder builder = CodeBlock.Companion.builder();
                            CodeBlock initializer = TablesGenerator.access$idInitializer(this.this$0, id, prop, entity);
                            builder.add(initializer);
                            idSpec.initializer(builder.build());
                            tableSpec.addProperty(idSpec.build());
                            if (prop.getConverter() == null) continue;
                            String converterName = TablesGeneratorKt.access$converterFuncName(entity.getName(), id.getName());
                            TablesGenerator.access$converterFunc(this.this$0, converterName, (TypeName)typeName, prop.getConverter(), this.$fileSpec);
                        }
                        ClassName pkType = TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Table.PrimaryKey.class));
                        PropertySpec.Builder pkSpec = PropertySpec.Companion.builder("primaryKey", (TypeName)pkType, new KModifier[]{KModifier.OVERRIDE});
                        CodeBlock pkInitializer = TablesGenerator.access$primaryKeyInitializer(this.this$0, id);
                        pkSpec.initializer(pkInitializer);
                        idDefinition = tableSpec.addProperty(pkSpec.build());
                        if (idDefinition != null) break block14;
                    }
                    throw (Throwable)new MissingIdException(entity);
                }
                Iterable $this$forEach$iv = entity.getProperties();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    PropertyDefinition property = (PropertyDefinition)element$iv;
                    boolean bl = false;
                    TablesGenerator.access$addTableProperty(this.this$0, property, entity, tableSpec, this.$fileSpec);
                }
                $this$forEach$iv = entity.getEmbeddables();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    EmbeddableDefinition embeddable = (EmbeddableDefinition)element$iv;
                    boolean bl = false;
                    Iterable $this$forEach$iv2 = embeddable.getProperties();
                    boolean $i$f$forEach2 = false;
                    for (E element$iv2 : $this$forEach$iv2) {
                        PropertyDefinition prop = (PropertyDefinition)element$iv2;
                        boolean bl5 = false;
                        TablesGenerator.access$addEmbeddedTableProperty(this.this$0, embeddable, prop, entity, tableSpec, this.$fileSpec, this.$typeEnv);
                    }
                }
                Iterable $this$filter$iv = entity.getAssociations(AssociationType.MANY_TO_ONE);
                boolean $i$f$filter = false;
                Iterator<T> iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                Iterator<T> bl = $this$filterTo$iv$iv.iterator();
                while (bl.hasNext()) {
                    element$iv$iv = bl.next();
                    it = (AssociationDefinition)element$iv$iv;
                    boolean bl6 = false;
                    if (!(it.getSharedId() == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AssociationDefinition assoc = (AssociationDefinition)element$iv;
                    boolean bl7 = false;
                    TablesGenerator.access$addAssociationProperty(this.this$0, assoc, tableSpec);
                }
                $this$filter$iv = entity.getAssociations(AssociationType.ONE_TO_ONE);
                $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                Iterator<T> bl7 = $this$filterTo$iv$iv.iterator();
                while (bl7.hasNext()) {
                    element$iv$iv = bl7.next();
                    it = (AssociationDefinition)element$iv$iv;
                    boolean bl8 = false;
                    if (!(it.getMapped() && it.getSharedId() == null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    AssociationDefinition assoc = (AssociationDefinition)element$iv;
                    boolean bl9 = false;
                    TablesGenerator.access$addAssociationProperty(this.this$0, assoc, tableSpec);
                }
                this.$fileSpec.addType(tableSpec.build());
                $this$forEach$iv = entity.getAssociations(AssociationType.MANY_TO_MANY);
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    EntityDefinition targetEntity;
                    AssociationDefinition assoc = (AssociationDefinition)element$iv;
                    boolean bl10 = false;
                    if (EntityDefinitionKt.entity(this.$graphs, EntityDefinitionKt.getPackageName(assoc.getTarget()), assoc.getTarget()) == null) {
                        throw (Throwable)new AssociationTargetEntityNotFoundException(assoc.getTarget());
                    }
                    TablesGenerator.access$addManyToManyAssociationTable(this.this$0, assoc, entity, entity.getId(), targetEntity, this.$fileSpec);
                }
                TablesGenerator.access$addInsertFunc(this.this$0, entityType, entity, this.$fileSpec);
            }
            {
                this.this$0 = tablesGenerator;
                this.$fileSpec = builder;
                this.$typeEnv = typeEnvironment;
                this.$graphs = map2;
                super(2);
            }
        }));
        return fileSpec.build();
    }

    private final void addAssociationProperty(AssociationDefinition assoc, TypeSpec.Builder tableSpec) {
        Iterable $this$forEach$iv = assoc.getTargetId().getProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyDefinition targetIdProp = (PropertyDefinition)element$iv;
            boolean bl = false;
            String name = assoc.targetIdPropName(targetIdProp);
            ClassName columnType = TablesGeneratorKt.asUnderlyingClassName(targetIdProp.getType());
            CodeBlock.Companion.builder();
            CodeBlock initializer = this.associationInitializer(assoc, targetIdProp, name);
            tableSpec.addProperty(PropertySpec.Companion.builder(name, (TypeName)ParameterizedTypeName.Companion.get(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Column.class)), new TypeName[]{TypeName.copy$default((TypeName)((TypeName)columnType), (boolean)true, null, (int)2, null)}), new KModifier[0]).initializer(initializer).build());
        }
    }

    private final void addManyToManyAssociationTable(AssociationDefinition assoc, EntityDefinition entity, IdDefinition id, EntityDefinition targetEntity, FileSpec.Builder fileSpec) {
        String propName;
        String prefix;
        String rootVal;
        ClassName sourceType;
        String differentiator;
        String manyToManyTableName = entity.getName() + EntityDefinitionKt.asObject(assoc.getName()) + "Table";
        TypeSpec.Builder manyToManyTableSpec = TypeSpec.Companion.objectBuilder(manyToManyTableName).superclass(Reflection.getOrCreateKotlinClass(Table.class)).addSuperclassConstructorParameter(CodeBlock.Companion.of("%S", new Object[]{assoc.getJoinTable()}));
        Iterable $this$forEach$iv = id.getProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyDefinition sourceIdProp = (PropertyDefinition)element$iv;
            boolean bl = false;
            Pair pair = assoc.isSelfReferential() ? TuplesKt.to((Object)"Source", (Object)"_source") : TuplesKt.to((Object)"", (Object)"");
            String string = (String)pair.component1();
            differentiator = (String)pair.component2();
            sourceType = TablesGeneratorKt.asUnderlyingClassName(sourceIdProp.getType());
            rootVal = EntityDefinitionKt.asVariable(entity.getName());
            propName = rootVal + prefix + StringsKt.capitalize((String)sourceIdProp.getValName());
            manyToManyTableSpec.addProperty(PropertySpec.Companion.builder(propName, (TypeName)ParameterizedTypeName.Companion.get(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Column.class)), new TypeName[]{(TypeName)sourceType}), new KModifier[0]).initializer(this.manyToManyPropertyInitializer(id, sourceIdProp, entity, differentiator)).build());
        }
        $this$forEach$iv = assoc.getTargetId().getProperties();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyDefinition targetIdProp = (PropertyDefinition)element$iv;
            boolean bl = false;
            sourceType = assoc.isSelfReferential() ? TuplesKt.to((Object)"Target", (Object)"_target") : TuplesKt.to((Object)"", (Object)"");
            prefix = (String)sourceType.component1();
            differentiator = (String)sourceType.component2();
            ClassName targetIdType = TablesGeneratorKt.asUnderlyingClassName(targetIdProp.getType());
            rootVal = EntityDefinitionKt.asVariable(targetEntity.getName());
            propName = rootVal + prefix + StringsKt.capitalize((String)targetIdProp.getValName());
            manyToManyTableSpec.addProperty(PropertySpec.Companion.builder(propName, (TypeName)ParameterizedTypeName.Companion.get(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Column.class)), new TypeName[]{(TypeName)targetIdType}), new KModifier[0]).initializer(this.manyToManyPropertyInitializer(assoc.getTargetId(), targetIdProp, targetEntity, differentiator)).build());
        }
        fileSpec.addType(manyToManyTableSpec.build());
    }

    private final void addEmbeddedTableProperty(EmbeddableDefinition embeddable, PropertyDefinition column, EntityDefinition entity, TypeSpec.Builder tableSpec, FileSpec.Builder fileSpec, TypeEnvironment typeEnvironment) {
        Name name;
        Name name2 = name = typeEnvironment.getElementUtils().getName(EntityDefinitionKt.asVariable(embeddable.getPropertyName()) + StringsKt.capitalize((String)EntityDefinitionKt.asVariable(column.getName())));
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"name");
        PropertyDefinition embeddedProperty = PropertyDefinition.copy$default(column, name2, null, null, null, null, embeddable.getNullable() || column.getNullable(), null, null, 222, null);
        this.addTableProperty(embeddedProperty, entity, tableSpec, fileSpec);
    }

    private final void addTableProperty(PropertyDefinition column, EntityDefinition entity, TypeSpec.Builder tableSpec, FileSpec.Builder fileSpec) {
        block0: {
            Name name = column.getName();
            TypeName type = TypeName.copy$default((TypeName)TablesGeneratorKt.asTypeName(column), (boolean)column.getNullable(), null, (int)2, null);
            ParameterizedTypeName columnType = ParameterizedTypeName.Companion.get(TypeNames.get((KClass)Reflection.getOrCreateKotlinClass(Column.class)), new TypeName[]{type});
            PropertySpec.Builder propSpec = PropertySpec.Companion.builder(EntityDefinitionKt.asVariable(name), (TypeName)columnType, new KModifier[0]);
            CodeBlock initializer = this.propertyInitializer(column, entity);
            propSpec.initializer(initializer);
            tableSpec.addProperty(propSpec.build());
            ConverterDefinition converterDefinition = column.getConverter();
            if (converterDefinition == null) break block0;
            ConverterDefinition converterDefinition2 = converterDefinition;
            boolean bl = false;
            boolean bl2 = false;
            ConverterDefinition it = converterDefinition2;
            boolean bl3 = false;
            String converterName = TablesGeneratorKt.access$converterFuncName(entity.getName(), column.getName());
            this.converterFunc(converterName, type, it, fileSpec);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addInsertFunc(TypeElement entityType, EntityDefinition entity, FileSpec.Builder fileSpec) {
        String fromFunc;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        String entityName = EntityDefinitionKt.asVariable(entity.getName());
        IdDefinition idDefinition = entity.getId();
        boolean isGenerated = idDefinition != null ? idDefinition.getGeneratedValue() : false;
        String persistedName = isGenerated ? "persisted" + StringsKt.capitalize((String)entityName) : entityName;
        ClassName entityClass = ExtKt.toClassName(KotlinPoetMetadata.toImmutableKmClass((TypeElement)entityType));
        FunSpec.Builder func = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder("insert"), (TypeName)((TypeName)TablesGeneratorKt.asUnderlyingClassName(new pl.touk.krush.model.Type(EntityDefinitionKt.getPackageName(entityType), entity.getTableName(), null, 4, null))), null, (int)2, null).addParameter(EntityDefinitionKt.asVariable(entity.getName()), (TypeName)entityClass, new KModifier[0]), (TypeName)((TypeName)entityClass), null, (int)2, null);
        List<ParameterSpec> assocParams = this.entityAssocParams(entity);
        Iterable $this$forEach$iv = assocParams;
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            ParameterSpec it = (ParameterSpec)element$iv2;
            boolean bl = false;
            func.addParameter(it);
        }
        Iterable $i$f$forEach22 = assocParams;
        Collection collection2 = CollectionsKt.listOf((Object)entityName);
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            String string = ((ParameterSpec)receiver).getName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        String fromFuncParams = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)collection2, (Iterable)collection), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        String string = fromFunc = entity.hasAssignableProperties() ? "it.from(" + fromFuncParams + ')' : "";
        if (isGenerated) {
            IdDefinition idDefinition2 = entity.getId();
            func.addStatement("val id = " + entity.getTableName() + ".insert { " + fromFunc + " }[" + entity.getTableName() + '.' + (idDefinition2 != null ? idDefinition2.getName() : null) + ']', new Object[0]);
            IdDefinition idDefinition3 = entity.getId();
            func.addStatement("val " + persistedName + " = " + entityName + ".copy(" + (idDefinition3 != null ? idDefinition3.getName() : null) + " = id)", new Object[0]);
        } else {
            func.addStatement(entity.getTableName() + ".insert { " + fromFunc + " }", new Object[0]);
        }
        Iterable $this$forEach$iv2 = entity.getAssociations(AssociationType.MANY_TO_MANY);
        boolean $i$f$forEach = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            AssociationDefinition assoc = (AssociationDefinition)element$iv3;
            boolean bl = false;
            String tableName = entity.getName() + EntityDefinitionKt.asObject(assoc.getName()) + "Table";
            func.addStatement(persistedName + '.' + assoc.getName() + ".forEach { " + assoc.getName() + " ->", new Object[0]);
            func.addStatement("\t\t" + tableName + ".insert { it.from(" + persistedName + ", " + assoc.getName() + ") }", new Object[0]);
            func.addStatement("}\n", new Object[0]);
        }
        func.addStatement("return " + persistedName, new Object[0]);
        fileSpec.addFunction(func.build());
    }

    /*
     * WARNING - void declaration
     */
    private final List<ParameterSpec> entityAssocParams(EntityDefinition entity) {
        void $this$mapTo$iv$iv;
        AssociationDefinition it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = entity.getAssociations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AssociationDefinition)element$iv$iv;
            boolean bl = false;
            if (!(!it.getMapped())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void assoc;
            it = (AssociationDefinition)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name = assoc.getTarget().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"assoc.target.simpleName");
            ParameterSpec parameterSpec = ParameterSpec.Companion.builder(EntityDefinitionKt.asVariable(name), TypeName.copy$default((TypeName)((TypeName)ExtKt.toClassName(KotlinPoetMetadata.toImmutableKmClass((TypeElement)assoc.getTarget()))), (boolean)true, null, (int)2, null), new KModifier[0]).defaultValue("null", new Object[0]).build();
            collection.add(parameterSpec);
        }
        return (List)destination$iv$iv;
    }

    private final void converterFunc(String name, TypeName type, ConverterDefinition converter, FileSpec.Builder fileSpec) {
        String string;
        ClassName className = TablesGeneratorKt.asUnderlyingClassName(converter.getTargetType());
        if (Intrinsics.areEqual((Object)className, (Object)TypeNames.STRING)) {
            string = "stringWrapper";
        } else if (Intrinsics.areEqual((Object)className, (Object)TypeNames.LONG)) {
            string = "longWrapper";
        } else if (Intrinsics.areEqual((Object)className, (Object)TablesGeneratorKt.INSTANT)) {
            string = "instantWrapper";
        } else if (Intrinsics.areEqual((Object)className, (Object)TypeNames.BOOLEAN)) {
            string = "booleanWrapper";
        } else {
            throw (Throwable)new TypeConverterNotSupportedException(converter.getTargetType());
        }
        String wrapperName = string;
        String init = !converter.isObject() ? "()" : "";
        FunSpec converterSpec = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Builder.receiver$default((FunSpec.Builder)FunSpec.Companion.builder(name).addParameter("columnName", Reflection.getOrCreateKotlinClass(String.class), new KModifier[0]), (Type)((Type)((Object)Table.class)), null, (int)2, null), (TypeName)((TypeName)ParameterizedTypeName.Companion.get(ClassNames.get((KClass)Reflection.getOrCreateKotlinClass(Column.class)), new TypeName[]{type})), null, (int)2, null).addStatement("return %L<%T>(columnName, { %L" + init + ".convertToEntityAttribute(it) }, { %L" + init + ".convertToDatabaseColumn(it) })", new Object[]{wrapperName, type, converter.getName(), converter.getName()}).build();
        fileSpec.addFunction(converterSpec);
    }

    private final CodeBlock idInitializer(IdDefinition id, PropertyDefinition prop, EntityDefinition entity) {
        CodeBlock.Builder codeBlockBuilder;
        block18: {
            PropertyDefinition targetIdProp;
            Object v3;
            boolean bl;
            Object object;
            block17: {
                CodeBlock codeBlock;
                codeBlockBuilder = CodeBlock.Companion.builder();
                if (prop.getConverter() != null) {
                    codeBlock = TablesGeneratorKt.access$converterPropInitializer(entity.getName(), prop.getName(), EntityDefinitionKt.asVariable(prop.getColumnName()));
                } else {
                    TypeName typeName = TablesGeneratorKt.asUnderlyingTypeName(prop);
                    if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.STRING)) {
                        Object[] objectArray = new Object[2];
                        objectArray[0] = prop.getColumnName();
                        javax.persistence.Column column = prop.getColumn();
                        objectArray[1] = column != null ? column.length() : 255;
                        codeBlock = CodeBlock.Companion.of("varchar(%S, %L)", objectArray);
                    } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.LONG)) {
                        codeBlock = CodeBlock.Companion.of("long(%S)", new Object[]{prop.getColumnName()});
                    } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.INT)) {
                        codeBlock = CodeBlock.Companion.of("integer(%S)", new Object[]{prop.getColumnName()});
                    } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.UUID)) {
                        codeBlock = CodeBlock.Companion.of("uuid(%S)", new Object[]{prop.getColumnName()});
                    } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.SHORT)) {
                        codeBlock = CodeBlock.Companion.of("short(%S)", new Object[]{prop.getColumnName()});
                    } else if (prop.isEnumerated()) {
                        codeBlock = this.enumPropInitializer(prop);
                    } else {
                        throw (Throwable)new IdTypeNotSupportedException(prop.getType());
                    }
                }
                CodeBlock codeBlock2 = codeBlock;
                codeBlockBuilder.add(codeBlock2);
                if (id.getGeneratedValue()) {
                    codeBlockBuilder.add(CodeBlock.Companion.of(".autoIncrement()", new Object[0]));
                }
                if (id.getSharedAssoc() == null || prop.getSharedColumn() == null) break block18;
                object = id.getSharedAssoc().getTargetId().getProperties();
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    PropertyDefinition it = (PropertyDefinition)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getColumnName().toString(), (Object)prop.getSharedColumn().name())) continue;
                    v3 = t;
                    break block17;
                }
                v3 = null;
            }
            PropertyDefinition propertyDefinition = targetIdProp = (PropertyDefinition)v3;
            if (propertyDefinition != null) {
                object = propertyDefinition;
                bl = false;
                boolean bl4 = false;
                Object it = object;
                boolean bl5 = false;
                codeBlockBuilder.add(".references(%L)", new Object[]{id.getSharedAssoc().getTargetTable() + '.' + id.getSharedAssoc().getTargetId().propName(targetIdProp)}).build();
            }
        }
        return codeBlockBuilder.build();
    }

    private final CodeBlock primaryKeyInitializer(IdDefinition id) {
        CodeBlock.Builder codeBlockBuilder = CodeBlock.Companion.builder();
        codeBlockBuilder.add("PrimaryKey(" + CollectionsKt.joinToString$default((Iterable)id.getProperties(), (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<PropertyDefinition, CharSequence>(id){
            final /* synthetic */ IdDefinition $id;

            @NotNull
            public final CharSequence invoke(@NotNull PropertyDefinition it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$id.propName(it);
            }
            {
                this.$id = idDefinition;
                super(1);
            }
        }), (int)30, null) + ")", new Object[0]);
        return codeBlockBuilder.build();
    }

    private final CodeBlock propertyInitializer(PropertyDefinition property, EntityDefinition entity) {
        CodeBlock.Builder codeBlockBuilder = CodeBlock.Companion.builder();
        CodeBlock codeBlock = property.hasConverter() ? this.converterPropInitializer(entity, property) : (property.isEnumerated() ? this.enumPropInitializer(property) : this.typePropInitializer(property));
        codeBlockBuilder.add(codeBlock);
        if (property.getNullable()) {
            codeBlockBuilder.add(".nullable()", new Object[0]);
        }
        return codeBlockBuilder.build();
    }

    private final CodeBlock converterPropInitializer(EntityDefinition entity, PropertyDefinition property) {
        return TablesGeneratorKt.access$converterPropInitializer(entity.getName(), property.getName(), EntityDefinitionKt.asVariable(property.getColumnName()));
    }

    private final CodeBlock enumPropInitializer(PropertyDefinition property) {
        CodeBlock codeBlock;
        Name columnName = property.getColumnName();
        ClassName enumType = TablesGeneratorKt.asUnderlyingClassName(property.getType());
        EnumeratedDefinition enumeratedDefinition = property.getEnumerated();
        Intrinsics.checkNotNull((Object)enumeratedDefinition);
        switch (TablesGenerator$WhenMappings.$EnumSwitchMapping$0[enumeratedDefinition.getEnumType().ordinal()]) {
            case 1: {
                javax.persistence.Column column = property.getColumn();
                int size = column != null ? column.length() : 255;
                codeBlock = CodeBlock.Companion.of("enumerationByName(%S, %L, %L)", new Object[]{columnName, size, enumType + "::class"});
                break;
            }
            case 2: {
                codeBlock = CodeBlock.Companion.of("enumeration(%S, %L)", new Object[]{columnName, enumType + "::class"});
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return codeBlock;
    }

    private final CodeBlock typePropInitializer(PropertyDefinition property) {
        CodeBlock codeBlock;
        TypeName typeName = TablesGeneratorKt.asUnderlyingTypeName(property);
        if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.STRING)) {
            if (property.isJsonb()) {
                codeBlock = CodeBlock.Companion.of("jsonb(%S)", new Object[]{property.getColumnName()});
            } else {
                Object[] objectArray = new Object[2];
                objectArray[0] = property.getColumnName();
                javax.persistence.Column column = property.getColumn();
                objectArray[1] = column != null ? column.length() : 255;
                codeBlock = CodeBlock.Companion.of("varchar(%S, %L)", objectArray);
            }
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.LONG)) {
            codeBlock = CodeBlock.Companion.of("long(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.BOOLEAN)) {
            codeBlock = CodeBlock.Companion.of("bool(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.UUID)) {
            codeBlock = CodeBlock.Companion.of("uuid(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.INT)) {
            codeBlock = CodeBlock.Companion.of("integer(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.SHORT)) {
            codeBlock = CodeBlock.Companion.of("short(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.FLOAT)) {
            codeBlock = CodeBlock.Companion.of("float(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.DOUBLE)) {
            codeBlock = CodeBlock.Companion.of("double(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.BIG_DECIMAL)) {
            javax.persistence.Column column = property.getColumn();
            int precision = column != null ? column.precision() : 0;
            javax.persistence.Column column2 = property.getColumn();
            int scale = column2 != null ? column2.scale() : 0;
            codeBlock = CodeBlock.Companion.of("decimal(%S, %L, %L)", new Object[]{property.getColumnName(), precision, scale});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.LOCAL_DATE)) {
            codeBlock = CodeBlock.Companion.of("date(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.LOCAL_DATE_TIME)) {
            codeBlock = CodeBlock.Companion.of("datetime(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.ZONED_DATE_TIME)) {
            codeBlock = CodeBlock.Companion.of("zonedDateTime(%S)", new Object[]{property.getColumnName()});
        } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.INSTANT)) {
            codeBlock = CodeBlock.Companion.of("timestamp(%S)", new Object[]{property.getColumnName()});
        } else {
            throw (Throwable)new PropertyTypeNotSupportedException(property.getType());
        }
        return codeBlock;
    }

    private final CodeBlock associationInitializer(AssociationDefinition assoc, PropertyDefinition idProp, String idName) {
        Object object;
        Object v0;
        block2: {
            Iterable iterable = assoc.getJoinColumns();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                JoinColumn it = (JoinColumn)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.name(), (Object)idProp.getColumnName().toString())) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (JoinColumn)v0) == null || (object = object.name()) == null) {
            object = idName + '_' + EntityDefinitionKt.asVariable(assoc.getTargetId().getName());
        }
        Object columnName = object;
        Name name = assoc.getTarget().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"assoc.target.simpleName");
        CodeBlock idCodeBlock = this.idCodeBlock(idProp, name, (String)columnName);
        return CodeBlock.Companion.builder().add(idCodeBlock).add(".references(%L).nullable()", new Object[]{assoc.getTargetTable() + '.' + assoc.getTargetId().propName(idProp)}).build();
    }

    private final CodeBlock manyToManyPropertyInitializer(IdDefinition id, PropertyDefinition idProp, EntityDefinition entity, String differentiator) {
        String targetTable = entity.getTableName();
        String columnName = EntityDefinitionKt.asVariable(entity.getName()) + differentiator + "_" + idProp.getColumnName().toString();
        CodeBlock idCodeBlock = this.idCodeBlock(idProp, entity.getName(), columnName);
        return CodeBlock.Companion.builder().add(idCodeBlock).add(".references(%L)", new Object[]{targetTable + '.' + id.propName(idProp)}).build();
    }

    private final CodeBlock idCodeBlock(PropertyDefinition prop, Name entityName, String columnName) {
        CodeBlock codeBlock;
        if (prop.getConverter() != null) {
            codeBlock = TablesGeneratorKt.access$converterPropInitializer(entityName, prop.getName(), columnName);
        } else {
            TypeName typeName = TablesGeneratorKt.asUnderlyingTypeName(prop);
            if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.STRING)) {
                Object[] objectArray = new Object[2];
                objectArray[0] = columnName;
                javax.persistence.Column column = prop.getColumn();
                objectArray[1] = column != null ? column.length() : 255;
                codeBlock = CodeBlock.Companion.of("varchar(%S, %L)", objectArray);
            } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.LONG)) {
                codeBlock = CodeBlock.Companion.of("long(%S)", new Object[]{columnName});
            } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.INT)) {
                codeBlock = CodeBlock.Companion.of("integer(%S)", new Object[]{columnName});
            } else if (Intrinsics.areEqual((Object)typeName, (Object)TablesGeneratorKt.UUID)) {
                codeBlock = CodeBlock.Companion.of("uuid(%S)", new Object[]{columnName});
            } else if (Intrinsics.areEqual((Object)typeName, (Object)TypeNames.SHORT)) {
                codeBlock = CodeBlock.Companion.of("short(%S)", new Object[]{columnName});
            } else {
                throw (Throwable)new IdTypeNotSupportedException(prop.getType());
            }
        }
        return codeBlock;
    }

    public static final /* synthetic */ CodeBlock access$idInitializer(TablesGenerator $this, IdDefinition id, PropertyDefinition prop, EntityDefinition entity) {
        return $this.idInitializer(id, prop, entity);
    }

    public static final /* synthetic */ void access$converterFunc(TablesGenerator $this, String name, TypeName type, ConverterDefinition converter, FileSpec.Builder fileSpec) {
        $this.converterFunc(name, type, converter, fileSpec);
    }

    public static final /* synthetic */ CodeBlock access$primaryKeyInitializer(TablesGenerator $this, IdDefinition id) {
        return $this.primaryKeyInitializer(id);
    }

    public static final /* synthetic */ void access$addTableProperty(TablesGenerator $this, PropertyDefinition column, EntityDefinition entity, TypeSpec.Builder tableSpec, FileSpec.Builder fileSpec) {
        $this.addTableProperty(column, entity, tableSpec, fileSpec);
    }

    public static final /* synthetic */ void access$addEmbeddedTableProperty(TablesGenerator $this, EmbeddableDefinition embeddable, PropertyDefinition column, EntityDefinition entity, TypeSpec.Builder tableSpec, FileSpec.Builder fileSpec, TypeEnvironment typeEnvironment) {
        $this.addEmbeddedTableProperty(embeddable, column, entity, tableSpec, fileSpec, typeEnvironment);
    }

    public static final /* synthetic */ void access$addAssociationProperty(TablesGenerator $this, AssociationDefinition assoc, TypeSpec.Builder tableSpec) {
        $this.addAssociationProperty(assoc, tableSpec);
    }

    public static final /* synthetic */ void access$addManyToManyAssociationTable(TablesGenerator $this, AssociationDefinition assoc, EntityDefinition entity, IdDefinition id, EntityDefinition targetEntity, FileSpec.Builder fileSpec) {
        $this.addManyToManyAssociationTable(assoc, entity, id, targetEntity, fileSpec);
    }

    public static final /* synthetic */ void access$addInsertFunc(TablesGenerator $this, TypeElement entityType, EntityDefinition entity, FileSpec.Builder fileSpec) {
        $this.addInsertFunc(entityType, entity, fileSpec);
    }
}

