/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.krush.model;

import com.squareup.kotlinpoet.metadata.KotlinPoetMetadataPreview;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.touk.krush.env.AnnotationEnvironment;
import pl.touk.krush.env.TypeEnvironment;
import pl.touk.krush.model.ColumnProcessor;
import pl.touk.krush.model.ElementProcessor;
import pl.touk.krush.model.EntityDefinition;
import pl.touk.krush.model.EntityDefinitionKt;
import pl.touk.krush.model.ManyToManyProcessor;
import pl.touk.krush.model.ManyToOneProcessor;
import pl.touk.krush.model.ModelValidatorKt;
import pl.touk.krush.model.OneToManyPostProcessor;
import pl.touk.krush.model.OneToManyProcessor;
import pl.touk.krush.model.OneToOneProcessor;
import pl.touk.krush.model.ValidationErrorMessage;
import pl.touk.krush.model.ValidationResult;
import pl.touk.krush.model.Validator;
import pl.touk.krush.validation.EntityGraphValidationFailedException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\n\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u0002`\u000f0\u000bj\u0002`\u0010J6\u0010\u0011\u001a\"\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u0002`\u000f0\u000bj\u0002`\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\bH\u0002J,\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00162\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00180\bH\u0002J\f\u0010\u0019\u001a\u00020\u0014*\u00020\u0005H\u0002J,\u0010\u0019\u001a\u00020\u0014*\"\u0012\u0004\u0012\u00020\f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u000bj\u0002`\u000f0\u000bj\u0002`\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lpl/touk/krush/model/EntityGraphBuilder;", "", "typeEnv", "Lpl/touk/krush/env/TypeEnvironment;", "annEnv", "Lpl/touk/krush/env/AnnotationEnvironment;", "(Lpl/touk/krush/env/TypeEnvironment;Lpl/touk/krush/env/AnnotationEnvironment;)V", "processors", "", "Lpl/touk/krush/model/ElementProcessor;", "build", "", "", "Ljavax/lang/model/element/TypeElement;", "Lpl/touk/krush/model/EntityDefinition;", "Lpl/touk/krush/model/EntityGraph;", "Lpl/touk/krush/model/EntityGraphs;", "buildEntities", "entityList", "doValidate", "Lpl/touk/krush/model/ValidationResult;", "T", "", "validators", "Lpl/touk/krush/model/Validator;", "validate", "annotation-processor"})
@KotlinPoetMetadataPreview
public final class EntityGraphBuilder {
    @NotNull
    private final AnnotationEnvironment annEnv;
    @NotNull
    private final List<ElementProcessor> processors;

    public EntityGraphBuilder(@NotNull TypeEnvironment typeEnv, @NotNull AnnotationEnvironment annEnv) {
        Intrinsics.checkNotNullParameter((Object)typeEnv, (String)"typeEnv");
        Intrinsics.checkNotNullParameter((Object)annEnv, (String)"annEnv");
        this.annEnv = annEnv;
        Object[] objectArray = new ElementProcessor[]{new ColumnProcessor(typeEnv, this.annEnv), new OneToOneProcessor(typeEnv, this.annEnv), new OneToManyProcessor(typeEnv, this.annEnv), new ManyToOneProcessor(typeEnv, this.annEnv), new ManyToManyProcessor(typeEnv, this.annEnv), new OneToManyPostProcessor(typeEnv, this.annEnv)};
        this.processors = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final Map<String, Map<TypeElement, EntityDefinition>> build() {
        ValidationResult annEnvValidation = this.validate(this.annEnv);
        if (annEnvValidation instanceof ValidationResult.Error) {
            throw new EntityGraphValidationFailedException(((ValidationResult.Error)annEnvValidation).getErrors());
        }
        Map<String, Map<TypeElement, EntityDefinition>> graphs = this.buildEntities(this.annEnv.getEntities());
        Iterable $this$forEach$iv = this.processors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ElementProcessor it = (ElementProcessor)element$iv;
            boolean bl = false;
            it.process(graphs);
        }
        ValidationResult entityGraphsValidation = this.validate(graphs);
        if (entityGraphsValidation instanceof ValidationResult.Error) {
            throw new EntityGraphValidationFailedException(((ValidationResult.Error)entityGraphsValidation).getErrors());
        }
        return graphs;
    }

    private final Map<String, Map<TypeElement, EntityDefinition>> buildEntities(List<? extends TypeElement> entityList) {
        Map<String, Map<TypeElement, EntityDefinition>> graphs = EntityDefinitionKt.EntityGraphs();
        for (TypeElement typeElement : entityList) {
            Map<TypeElement, EntityDefinition> graph = graphs.getOrDefault(EntityDefinitionKt.getPackageName(typeElement), EntityDefinitionKt.EntityGraph());
            Map<Object, Object> map = graph;
            Object object = new EntityDefinition(typeElement, EntityDefinitionKt.getTableName(typeElement), null, null, null, null, 60, null);
            boolean bl = false;
            map.put(typeElement, (EntityDefinition)object);
            map = graphs;
            object = EntityDefinitionKt.getPackageName(typeElement);
            bl = false;
            map.put((TypeElement)object, graph);
        }
        return graphs;
    }

    private final ValidationResult validate(AnnotationEnvironment $this$validate) {
        return this.doValidate((Iterable)$this$validate.getEntities(), ModelValidatorKt.getEntityTypeValidators());
    }

    private final ValidationResult validate(Map<String, Map<TypeElement, EntityDefinition>> $this$validate) {
        return this.doValidate(EntityDefinitionKt.entities($this$validate), ModelValidatorKt.getEntityDefValidators());
    }

    private final <T> ValidationResult doValidate(Iterable<? extends T> $this$doValidate, List<? extends Validator<T>> validators) {
        boolean bl = false;
        List errors = new ArrayList();
        Iterable<T> $this$forEach$iv = $this$doValidate;
        boolean $i$f$forEach = false;
        Iterator<T> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            T element$iv;
            T el = element$iv = iterator.next();
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = validators;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Validator validator = (Validator)element$iv2;
                boolean bl3 = false;
                try {
                    ValidationResult elValidationResult = validator.validate(el);
                    if (!(elValidationResult instanceof ValidationResult.Error)) continue;
                    errors.addAll((Collection)((ValidationResult.Error)elValidationResult).getErrors());
                }
                catch (Exception ex) {
                    errors.add(new ValidationErrorMessage("Validation exception: " + ex + ", element: " + el + ", validator: " + validator));
                }
            }
        }
        return errors.isEmpty() ? (ValidationResult)ValidationResult.Success.INSTANCE : (ValidationResult)new ValidationResult.Error(errors);
    }
}

