/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.krush.model;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import pl.touk.krush.model.EntityDefinition;
import pl.touk.krush.model.ValidationErrorMessage;
import pl.touk.krush.model.ValidationResult;
import pl.touk.krush.model.Validator;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0007"}, d2={"Lpl/touk/krush/model/EntityIdValidator;", "Lpl/touk/krush/model/Validator;", "Lpl/touk/krush/model/EntityDefinition;", "()V", "validate", "Lpl/touk/krush/model/ValidationResult;", "el", "annotation-processor"})
public final class EntityIdValidator
implements Validator<EntityDefinition> {
    @Override
    @NotNull
    public ValidationResult validate(@NotNull EntityDefinition el) {
        Intrinsics.checkNotNullParameter((Object)el, (String)"el");
        if (el.getId() == null) {
            ValidationErrorMessage[] validationErrorMessageArray = new ValidationErrorMessage[]{new ValidationErrorMessage(Intrinsics.stringPlus((String)"No id field specified for entity ", (Object)el.getQualifiedName()))};
            return new ValidationResult.Error(validationErrorMessageArray);
        }
        if (el.getId().getNullable() && !el.getId().getGeneratedValue()) {
            ValidationErrorMessage[] validationErrorMessageArray = new ValidationErrorMessage[]{new ValidationErrorMessage(Intrinsics.stringPlus((String)"Nullable id field without @GeneratedValue specified for entity ", (Object)el.getQualifiedName()))};
            return new ValidationResult.Error(validationErrorMessageArray);
        }
        return ValidationResult.Success.INSTANCE;
    }
}

