/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nifi.ignite.testutil;

import java.util.Collections;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.spi.discovery.DiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.TcpDiscoverySpi;
import org.apache.ignite.spi.discovery.tcp.ipfinder.TcpDiscoveryIpFinder;
import org.apache.ignite.spi.discovery.tcp.ipfinder.multicast.TcpDiscoveryMulticastIpFinder;

public class IgniteTestUtil {
    public static Ignite startServer(int port) {
        return Ignition.start((IgniteConfiguration)IgniteTestUtil.getServerConfig(port));
    }

    public static Ignite startServer(int port, int clientConnectorPort) {
        ClientConnectorConfiguration clientConnectorConfig = new ClientConnectorConfiguration().setPort(clientConnectorPort);
        clientConnectorConfig.setPortRange(0);
        IgniteConfiguration serverConfig = IgniteTestUtil.getServerConfig(port).setClientConnectorConfiguration(clientConnectorConfig);
        return Ignition.start((IgniteConfiguration)serverConfig);
    }

    public static Ignite startClient(int port) {
        IgniteConfiguration clientConfig = new IgniteConfiguration().setIgniteInstanceName("my-client").setDiscoverySpi(IgniteTestUtil.getDiscoverSpi(port)).setClientMode(true);
        return Ignition.start((IgniteConfiguration)clientConfig);
    }

    private static IgniteConfiguration getServerConfig(int port) {
        return new IgniteConfiguration().setIgniteInstanceName("my-server").setDiscoverySpi(IgniteTestUtil.getDiscoverSpi(port));
    }

    private static DiscoverySpi getDiscoverSpi(int port) {
        return new TcpDiscoverySpi().setLocalPortRange(0).setReconnectCount(1).setIpFinder((TcpDiscoveryIpFinder)new TcpDiscoveryMulticastIpFinder().setAddresses(Collections.singleton("127.0.0.1:" + port)));
    }
}

