/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.formatter;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.formatter.AvroMessageFormatter;
import pl.touk.nussknacker.engine.avro.formatter.AvroMessageReader;
import pl.touk.nussknacker.engine.avro.formatter.AvroToJsonFormatter$;
import pl.touk.nussknacker.engine.kafka.RecordFormatter;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%d\u0001B\u0001\u0003\u0001=\u00111#\u0011<s_R{'j]8o\r>\u0014X.\u0019;uKJT!a\u0001\u0003\u0002\u0013\u0019|'/\\1ui\u0016\u0014(BA\u0003\u0007\u0003\u0011\tgO]8\u000b\u0005\u001dA\u0011AB3oO&tWM\u0003\u0002\n\u0015\u0005Ya.^:tW:\f7m[3s\u0015\tYA\"\u0001\u0003u_V\\'\"A\u0007\u0002\u0005Ad7\u0001A\n\u0004\u0001A1\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g\r\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\r\u0005)1.\u00194lC&\u00111\u0004\u0007\u0002\u0010%\u0016\u001cwN\u001d3G_Jl\u0017\r\u001e;fe\"AQ\u0004\u0001B\u0001B\u0003%a$\u0001\u000btG\",W.\u0019*fO&\u001cHO]=DY&,g\u000e\u001e\t\u0003?%j\u0011\u0001\t\u0006\u0003C\t\naa\u00197jK:$(BA\u0012%\u00039\u00198\r[3nCJ,w-[:uefT!!G\u0013\u000b\u0005\u0019:\u0013!C2p]\u001adW/\u001a8u\u0015\u0005A\u0013AA5p\u0013\tQ\u0003E\u0001\u000bTG\",W.\u0019*fO&\u001cHO]=DY&,g\u000e\u001e\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005YA\u0011QFL\u0007\u0002\u0005%\u0011qF\u0001\u0002\u0015\u0003Z\u0014x.T3tg\u0006<WMR8s[\u0006$H/\u001a:\t\u0011E\u0002!\u0011!Q\u0001\nI\naA]3bI\u0016\u0014\bCA\u00174\u0013\t!$AA\tBmJ|W*Z:tC\u001e,'+Z1eKJD\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\nM>\u0014X.\u0019;LKf\u0004\"!\u0005\u001d\n\u0005e\u0012\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000burt\bQ!\u0011\u00055\u0002\u0001\"B\u000f;\u0001\u0004q\u0002\"B\u0002;\u0001\u0004a\u0003\"B\u0019;\u0001\u0004\u0011\u0004\"\u0002\u001c;\u0001\u00049\u0004\"B\"\u0001\t\u0003\"\u0015\u0001\u00044pe6\fGOU3d_J$GCA#L!\r\tb\tS\u0005\u0003\u000fJ\u0011Q!\u0011:sCf\u0004\"!E%\n\u0005)\u0013\"\u0001\u0002\"zi\u0016DQ\u0001\u0014\"A\u00025\u000baA]3d_J$\u0007\u0003\u0002(Y\u000b\u0016k\u0011a\u0014\u0006\u0003!F\u000b\u0001bY8ogVlWM\u001d\u0006\u0003%N\u000bqa\u00197jK:$8O\u0003\u0002\u001a)*\u0011QKV\u0001\u0007CB\f7\r[3\u000b\u0003]\u000b1a\u001c:h\u0013\tIvJ\u0001\bD_:\u001cX/\\3s%\u0016\u001cwN\u001d3\t\u000bm\u0003A\u0011\u0002/\u0002\u000fA\u0014\u0018N\u001c;JIR\u0019Q\f\u00192\u0011\u0005Eq\u0016BA0\u0013\u0005\u0011)f.\u001b;\t\u000b\u0005T\u0006\u0019A#\u0002\u000b\tLH/Z:\t\u000b\rT\u0006\u0019\u00013\u0002\u0017A\u0014\u0018N\u001c;TiJ,\u0017-\u001c\t\u0003K&l\u0011A\u001a\u0006\u0003Q\u001dT\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kM\nY\u0001K]5oiN#(/Z1n\u0011\u0015a\u0007\u0001\"\u0003n\u0003\u0019\u0011X-\u00193JIR\u0011a.\u001d\t\u0003#=L!\u0001\u001d\n\u0003\u0007%sG\u000fC\u0003bW\u0002\u0007Q\tC\u0003t\u0001\u0011%A/A\u0007hKR\u0014\u0015\u0010^3Ck\u001a4WM\u001d\u000b\u0003kn\u0004\"A^=\u000e\u0003]T!\u0001_4\u0002\u00079Lw.\u0003\u0002{o\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bq\u0014\b\u0019A#\u0002\u000fA\f\u0017\u0010\\8bI\")a\u0010\u0001C!\u007f\u0006Y\u0001/\u0019:tKJ+7m\u001c:e)\u0011\t\t!!\u0004\u0011\r\u0005\r\u0011\u0011B#F\u001b\t\t)AC\u0002\u0002\bE\u000b\u0001\u0002\u001d:pIV\u001cWM]\u0005\u0005\u0003\u0017\t)A\u0001\bQe>$WoY3s%\u0016\u001cwN\u001d3\t\r\u0005=Q\u00101\u0001F\u0003%1wN]7biR,G\rC\u0004\u0002\u0014\u0001!I!!\u0006\u0002\u0019I,\u0017\rZ*dQ\u0016l\u0017-\u00133\u0015\t\u0005]\u00111\u0007\t\b#\u0005e\u0011QDA\u0014\u0013\r\tYB\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005}\u00111E\u0007\u0003\u0003CQ!!\u0002+\n\t\u0005\u0015\u0012\u0011\u0005\u0002\u0007'\u000eDW-\\1\u0011\t\u0005%\u0012qF\u0007\u0003\u0003WQ1!!\fh\u0003\u0011a\u0017M\\4\n\t\u0005E\u00121\u0006\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005U\u0012\u0011\u0003a\u0001\u0003o\t1a\u001d;s!\u0011\tI$a\u0010\u000f\u0007E\tY$C\u0002\u0002>I\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0019\u0003\u0003R1!!\u0010\u0013\u000f\u001d\t)E\u0001E\u0001\u0003\u000f\n1#\u0011<s_R{'j]8o\r>\u0014X.\u0019;uKJ\u00042!LA%\r\u0019\t!\u0001#\u0001\u0002LM\u0019\u0011\u0011\n\t\t\u000fm\nI\u0005\"\u0001\u0002PQ\u0011\u0011q\t\u0005\u000b\u0003'\nIE1A\u0005\n\u0005U\u0013!C*fa\u0006\u0014\u0018\r^8s+\t\t9\u0003C\u0005\u0002Z\u0005%\u0003\u0015!\u0003\u0002(\u0005Q1+\u001a9be\u0006$xN\u001d\u0011\t\u0011\u0005u\u0013\u0011\nC\u0001\u0003?\nQ!\u00199qYf$r!PA1\u0003G\n9\u0007\u0003\u0004\u001e\u00037\u0002\rA\b\u0005\t\u0003K\nY\u00061\u0001\u00028\u0005)Ao\u001c9jG\"1a'a\u0017A\u0002]\u0002")
public class AvroToJsonFormatter
implements RecordFormatter {
    private final SchemaRegistryClient schemaRegistryClient;
    private final AvroMessageFormatter formatter;
    private final AvroMessageReader reader;
    private final boolean formatKey;

    public static AvroToJsonFormatter apply(SchemaRegistryClient schemaRegistryClient, String string, boolean bl) {
        return AvroToJsonFormatter$.MODULE$.apply(schemaRegistryClient, string, bl);
    }

    public byte[] formatRecord(ConsumerRecord<byte[], byte[]> record) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)bos, true, StandardCharsets.UTF_8.toString());
        if (this.formatKey) {
            this.printId((byte[])record.key(), printStream);
        }
        this.printId((byte[])record.value(), printStream);
        if (this.formatKey) {
            this.formatter.writeTo((byte[])record.key(), true, printStream);
            printStream.print(AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator());
        }
        this.formatter.writeTo((byte[])record.value(), false, printStream);
        return bos.toByteArray();
    }

    private void printId(byte[] bytes, PrintStream printStream) {
        int id = this.readId(bytes);
        printStream.print(id);
        printStream.print(AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator());
    }

    private int readId(byte[] bytes) {
        ByteBuffer buffer = this.getByteBuffer(bytes);
        return buffer.getInt();
    }

    private ByteBuffer getByteBuffer(byte[] payload) {
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return buffer;
    }

    public ProducerRecord<byte[], byte[]> parseRecord(byte[] formatted) {
        Tuple2<Schema, String> tuple2;
        block8: {
            Tuple3 tuple3;
            block7: {
                Tuple2 tuple22;
                Tuple3 tuple32;
                String str;
                block4: {
                    Tuple2<Schema, String> tuple23;
                    block5: {
                        Tuple2<Schema, String> tuple24;
                        block6: {
                            Tuple2 tuple25;
                            Tuple2 tuple26;
                            str = new String(formatted, StandardCharsets.UTF_8);
                            if (!this.formatKey) break block4;
                            tuple23 = this.readSchemaId(str);
                            if (tuple23 == null) break block5;
                            Schema ks = (Schema)tuple23._1();
                            String valueSchemaIdAndRest = (String)tuple23._2();
                            Tuple2 tuple27 = tuple26 = new Tuple2((Object)ks, (Object)valueSchemaIdAndRest);
                            Schema ks2 = (Schema)tuple27._1();
                            String valueSchemaIdAndRest2 = (String)tuple27._2();
                            tuple24 = this.readSchemaId(valueSchemaIdAndRest2);
                            if (tuple24 == null) break block6;
                            Schema vs = (Schema)tuple24._1();
                            String rs = (String)tuple24._2();
                            Tuple2 tuple28 = tuple25 = new Tuple2((Object)vs, (Object)rs);
                            Schema vs2 = (Schema)tuple28._1();
                            String rs2 = (String)tuple28._2();
                            tuple32 = new Tuple3((Object)ks2, (Object)vs2, (Object)rs2);
                            break block7;
                        }
                        throw new MatchError(tuple24);
                    }
                    throw new MatchError(tuple23);
                }
                tuple2 = this.readSchemaId(str);
                if (tuple2 == null) break block8;
                Schema vs = (Schema)tuple2._1();
                String rs = (String)tuple2._2();
                Tuple2 tuple29 = tuple22 = new Tuple2((Object)vs, (Object)rs);
                Schema vs3 = (Schema)tuple29._1();
                String rs3 = (String)tuple29._2();
                tuple32 = tuple3 = new Tuple3(null, (Object)vs3, (Object)rs3);
            }
            if (tuple3 != null) {
                Tuple3 tuple33;
                Schema keySchema = (Schema)tuple3._1();
                Schema valueSchema = (Schema)tuple3._2();
                String remainingString = (String)tuple3._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)keySchema, (Object)valueSchema, (Object)remainingString);
                Schema keySchema2 = (Schema)tuple34._1();
                Schema valueSchema2 = (Schema)tuple34._2();
                String remainingString2 = (String)tuple34._3();
                return this.reader.readMessage(remainingString2, keySchema2, valueSchema2);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError(tuple2);
    }

    private Tuple2<Schema, String> readSchemaId(String str) {
        int separatorIndx = str.indexOf(AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator());
        if (separatorIndx < 1) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find schema id separtor: ", " in text: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator(), str})));
        }
        int id = Integer.parseInt(str.substring(0, separatorIndx));
        String remaining = separatorIndx + 1 > str.length() ? "" : str.substring(separatorIndx + 1);
        return new Tuple2((Object)this.schemaRegistryClient.getById(id), (Object)remaining);
    }

    public AvroToJsonFormatter(SchemaRegistryClient schemaRegistryClient, AvroMessageFormatter formatter, AvroMessageReader reader, boolean formatKey) {
        this.schemaRegistryClient = schemaRegistryClient;
        this.formatter = formatter;
        this.reader = reader;
        this.formatKey = formatKey;
    }
}

