/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.formatter;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerDe;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a!B\u0001\u0003\u0001\tq!!E!we>lUm]:bO\u0016\u0014V-\u00193fe*\u00111\u0001B\u0001\nM>\u0014X.\u0019;uKJT!!\u0002\u0004\u0002\t\u00054(o\u001c\u0006\u0003\u000f!\ta!\u001a8hS:,'BA\u0005\u000b\u0003-qWo]:l]\u0006\u001c7.\u001a:\u000b\u0005-a\u0011\u0001\u0002;pk.T\u0011!D\u0001\u0003a2\u001c\"\u0001A\b\u0011\u0005AIR\"A\t\u000b\u0005I\u0019\u0012aC:fe&\fG.\u001b>feNT!\u0001F\u000b\u0002\u000b-\fgm[1\u000b\u0005Y9\u0012!C2p]\u001adW/\u001a8u\u0015\u0005A\u0012AA5p\u0013\tQ\u0012CA\u000eBEN$(/Y2u\u0017\u000647.Y!we>\u001cVM]5bY&TXM\u001d\u0005\t9\u0001\u0011\t\u0011)A\u0005=\u0005!2o\u00195f[\u0006\u0014VmZ5tiJL8\t\\5f]R\u001c\u0001\u0001\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u000511\r\\5f]RT!aI\n\u0002\u001dM\u001c\u0007.Z7be\u0016<\u0017n\u001d;ss&\u0011Q\u0005\t\u0002\u0015'\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u00072LWM\u001c;\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\nQ\u0001^8qS\u000e\u0004\"!K\u0018\u000f\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0014G\u0001\u0004TiJLgn\u001a\u0006\u0003]-B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\ta\u0006\u00148/Z&fsB\u0011!&N\u0005\u0003m-\u0012qAQ8pY\u0016\fg\u000e\u0003\u00059\u0001\t\u0005\t\u0015!\u0003)\u00031YW-_*fa\u0006\u0014\u0018\r^8s\u0011\u0015Q\u0004\u0001\"\u0001<\u0003\u0019a\u0014N\\5u}Q)AHP A\u0003B\u0011Q\bA\u0007\u0002\u0005!)A$\u000fa\u0001=!)q%\u000fa\u0001Q!)1'\u000fa\u0001i!)\u0001(\u000fa\u0001Q!91\t\u0001b\u0001\n\u0013!\u0015AC6fsN+(M[3diV\tQ\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006!A.\u00198h\u0015\u0005Q\u0015\u0001\u00026bm\u0006L!\u0001M$\t\r5\u0003\u0001\u0015!\u0003F\u0003-YW-_*vE*,7\r\u001e\u0011\t\u000f=\u0003!\u0019!C\u0005\t\u0006aa/\u00197vKN+(M[3di\"1\u0011\u000b\u0001Q\u0001\n\u0015\u000bQB^1mk\u0016\u001cVO\u00196fGR\u0004\u0003bB*\u0001\u0005\u0004%I\u0001V\u0001\u000fI\u0016\u001cw\u000eZ3s\r\u0006\u001cGo\u001c:z+\u0005)\u0006C\u0001,^\u001b\u00059&B\u0001\rY\u0015\t)\u0011L\u0003\u0002[7\u00061\u0011\r]1dQ\u0016T\u0011\u0001X\u0001\u0004_J<\u0017B\u00010X\u00059!UmY8eKJ4\u0015m\u0019;pefDa\u0001\u0019\u0001!\u0002\u0013)\u0016a\u00043fG>$WM\u001d$bGR|'/\u001f\u0011\t\u000b\t\u0004A\u0011A2\u0002\u0017I,\u0017\rZ'fgN\fw-\u001a\u000b\u0005IN,8\u0010\u0005\u0003fW6lW\"\u00014\u000b\u0005\u001dD\u0017\u0001\u00039s_\u0012,8-\u001a:\u000b\u0005%T\u0017aB2mS\u0016tGo\u001d\u0006\u0003)eK!\u0001\u001c4\u0003\u001dA\u0013x\u000eZ;dKJ\u0014VmY8sIB\u0019!F\u001c9\n\u0005=\\#!B!se\u0006L\bC\u0001\u0016r\u0013\t\u00118F\u0001\u0003CsR,\u0007\"\u0002;b\u0001\u0004A\u0013aA:ue\")a/\u0019a\u0001o\u0006I1.Z=TG\",W.\u0019\t\u0003qfl\u0011\u0001W\u0005\u0003ub\u0013aaU2iK6\f\u0007\"\u0002?b\u0001\u00049\u0018a\u0003<bYV,7k\u00195f[\u0006DQA \u0001\u0005\n}\f!B[:p]R{\u0017I\u001e:p)\u0019\t\t!a\u0002\u0002\fA\u0019!&a\u0001\n\u0007\u0005\u00151F\u0001\u0004B]f\u0014VM\u001a\u0005\u0007\u0003\u0013i\b\u0019\u0001\u0015\u0002\u0015)\u001cxN\\*ue&tw\r\u0003\u0004\u0002\u000eu\u0004\ra^\u0001\u0007g\u000eDW-\\1")
public class AvroMessageReader
extends AbstractKafkaAvroSerializer {
    private final String topic;
    private final boolean parseKey;
    private final String keySeparator;
    private final String keySubject;
    private final String valueSubject;
    private final DecoderFactory decoderFactory;

    private String keySubject() {
        return this.keySubject;
    }

    private String valueSubject() {
        return this.valueSubject;
    }

    private DecoderFactory decoderFactory() {
        return this.decoderFactory;
    }

    public ProducerRecord<byte[], byte[]> readMessage(String str, Schema keySchema, Schema valueSchema) {
        try {
            ProducerRecord producerRecord;
            if (this.parseKey) {
                int keyIndex = str.indexOf(this.keySeparator);
                if (keyIndex < 0) {
                    throw new SerializationException(new StringBuilder().append((Object)"No key found in line ").append((Object)str).toString());
                }
                String keyString = str.substring(0, keyIndex);
                String valueString = keyIndex + 1 > str.length() ? "" : str.substring(keyIndex + 1);
                Object key = this.jsonToAvro(keyString, keySchema);
                byte[] serializedKey = this.serializeImpl(this.keySubject(), key);
                Object value = this.jsonToAvro(valueString, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedKey, (Object)serializedValue);
            } else {
                Object value = this.jsonToAvro(str, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedValue);
            }
            return producerRecord;
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading from input", (Throwable)iOException);
        }
    }

    private Object jsonToAvro(String jsonString, Schema schema) {
        try {
            GenericDatumReader reader = new GenericDatumReader(schema);
            Object obj = reader.read(null, (Decoder)this.decoderFactory().jsonDecoder(schema, jsonString));
            Schema.Type type = schema.getType();
            Schema.Type type2 = Schema.Type.STRING;
            return !(type != null ? !type.equals(type2) : type2 != null) ? ((Utf8)obj).toString() : obj;
        }
        catch (AvroRuntimeException avroRuntimeException) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)avroRuntimeException);
        }
        catch (IOException iOException) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)iOException);
        }
    }

    public AvroMessageReader(SchemaRegistryClient schemaRegistryClient, String topic, boolean parseKey, String keySeparator) {
        this.topic = topic;
        this.parseKey = parseKey;
        this.keySeparator = keySeparator;
        ((AbstractKafkaAvroSerDe)this).schemaRegistry = schemaRegistryClient;
        this.keySubject = new StringBuilder().append((Object)topic).append((Object)"-key").toString();
        this.valueSubject = new StringBuilder().append((Object)topic).append((Object)"-value").toString();
        this.decoderFactory = DecoderFactory.get();
    }
}

