/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.avro.Schema;
import org.apache.avro.SchemaCompatibility;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.avro.typeutils.AvroFactory;
import org.apache.flink.formats.avro.typeutils.LogicalTypesAvroSerializer;
import org.apache.flink.formats.avro.typeutils.NkSerializableAvroSchema;
import org.apache.flink.util.Preconditions;

public class LogicalTypesAvroSerializerSnapshot<T>
implements TypeSerializerSnapshot<T> {
    private Class<T> runtimeType;
    private Schema schema;
    private Schema runtimeSchema;

    public LogicalTypesAvroSerializerSnapshot() {
    }

    LogicalTypesAvroSerializerSnapshot(Schema schema, Class<T> clazz) {
        this.schema = schema;
        this.runtimeType = clazz;
    }

    public int getCurrentVersion() {
        return 2;
    }

    public void writeSnapshot(DataOutputView dataOutputView) throws IOException {
        Preconditions.checkNotNull(this.runtimeType);
        Preconditions.checkNotNull((Object)this.schema);
        dataOutputView.writeUTF(this.runtimeType.getName());
        dataOutputView.writeUTF(this.schema.toString(false));
    }

    public void readSnapshot(int n, DataInputView dataInputView, ClassLoader classLoader) throws IOException {
        switch (n) {
            case 1: {
                this.readV1(dataInputView, classLoader);
                return;
            }
            case 2: {
                this.readV2(dataInputView, classLoader);
                return;
            }
        }
        throw new IllegalArgumentException("unknown snapshot version for AvroSerializerSnapshot " + n);
    }

    private void readV1(DataInputView dataInputView, ClassLoader classLoader) throws IOException {
        String string = dataInputView.readUTF();
        this.schema = LogicalTypesAvroSerializerSnapshot.parseAvroSchema(string);
        this.runtimeType = LogicalTypesAvroSerializerSnapshot.findClassOrFallbackToGeneric(classLoader, this.schema.getFullName());
        this.runtimeSchema = LogicalTypesAvroSerializerSnapshot.tryExtractAvroSchema(classLoader, this.runtimeType);
    }

    private void readV2(DataInputView dataInputView, ClassLoader classLoader) throws IOException {
        String string = dataInputView.readUTF();
        String string2 = dataInputView.readUTF();
        this.runtimeType = LogicalTypesAvroSerializerSnapshot.findClassOrThrow(classLoader, string);
        this.schema = LogicalTypesAvroSerializerSnapshot.parseAvroSchema(string2);
        this.runtimeSchema = LogicalTypesAvroSerializerSnapshot.tryExtractAvroSchema(classLoader, this.runtimeType);
    }

    public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> typeSerializer) {
        if (!(typeSerializer instanceof LogicalTypesAvroSerializer)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        LogicalTypesAvroSerializer logicalTypesAvroSerializer = (LogicalTypesAvroSerializer)typeSerializer;
        return LogicalTypesAvroSerializerSnapshot.resolveSchemaCompatibility(this.schema, logicalTypesAvroSerializer.getAvroSchema());
    }

    public TypeSerializer<T> restoreSerializer() {
        Preconditions.checkNotNull(this.runtimeType);
        Preconditions.checkNotNull((Object)this.schema);
        if (this.runtimeSchema != null) {
            return new LogicalTypesAvroSerializer<T>(this.runtimeType, new NkSerializableAvroSchema(this.runtimeSchema), new NkSerializableAvroSchema(this.schema));
        }
        return new LogicalTypesAvroSerializer<T>(this.runtimeType, new NkSerializableAvroSchema(this.schema), new NkSerializableAvroSchema(this.schema));
    }

    @VisibleForTesting
    static <T> TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(Schema schema, Schema schema2) {
        if (Objects.equals(schema, schema2)) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        SchemaCompatibility.SchemaPairCompatibility schemaPairCompatibility = SchemaCompatibility.checkReaderWriterCompatibility((Schema)schema2, (Schema)schema);
        return LogicalTypesAvroSerializerSnapshot.avroCompatibilityToFlinkCompatibility(schemaPairCompatibility);
    }

    private static <T> TypeSerializerSchemaCompatibility<T> avroCompatibilityToFlinkCompatibility(SchemaCompatibility.SchemaPairCompatibility schemaPairCompatibility) {
        switch (schemaPairCompatibility.getType()) {
            case COMPATIBLE: {
                return TypeSerializerSchemaCompatibility.compatibleAfterMigration();
            }
            case INCOMPATIBLE: {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    private static Schema parseAvroSchema(String string) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(string);
    }

    private static Schema tryExtractAvroSchema(ClassLoader classLoader, Class<?> clazz) {
        if (LogicalTypesAvroSerializer.isGenericRecord(clazz)) {
            return null;
        }
        if (LogicalTypesAvroSerializerSnapshot.isSpecificRecord(clazz)) {
            SpecificData specificData2 = new SpecificData(classLoader);
            return AvroFactory.extractAvroSpecificSchema(clazz, (SpecificData)specificData2);
        }
        ReflectData reflectData2 = new ReflectData(classLoader);
        return reflectData2.getSchema(clazz);
    }

    @Nonnull
    private static <T> Class<T> findClassOrThrow(ClassLoader classLoader, String string) {
        try {
            Class<?> clazz = Class.forName(string, false, classLoader);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to find the class '" + string + "' which is used to deserialize the elements of this serializer. Were the class was moved or renamed?", classNotFoundException);
        }
    }

    @Nonnull
    private static <T> Class<T> findClassOrFallbackToGeneric(ClassLoader classLoader, String string) {
        try {
            Class<?> clazz = Class.forName(string, false, classLoader);
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return GenericRecord.class;
        }
    }

    private static boolean isSpecificRecord(Class<?> clazz) {
        return SpecificRecord.class.isAssignableFrom(clazz);
    }
}

