/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.formatter;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.ConfluentUtils$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a!B\u0001\u0003\u0001\u0011\u0011\"AG\"p]\u001adW/\u001a8u\u0003Z\u0014x.T3tg\u0006<WMU3bI\u0016\u0014(BA\u0002\u0005\u0003%1wN]7biR,'O\u0003\u0002\u0006\r\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003\u000f!\tab]2iK6\f'/Z4jgR\u0014\u0018P\u0003\u0002\n\u0015\u0005!\u0011M\u001e:p\u0015\tYA\"\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u001b9\t1B\\;tg.t\u0017mY6fe*\u0011q\u0002E\u0001\u0005i>,8NC\u0001\u0012\u0003\t\u0001Hn\u0005\u0002\u0001'A\u0011A\u0003H\u0007\u0002+)\u0011acF\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148O\u0003\u0002\u00193\u0005)1.\u00194lC*\u0011QA\u0007\u0006\u00027\u0005\u0011\u0011n\\\u0005\u0003;U\u00111$\u00112tiJ\f7\r^&bM.\f\u0017I\u001e:p'\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002)M\u001c\u0007.Z7b%\u0016<\u0017n\u001d;ss\u000ec\u0017.\u001a8u\u0007\u0001\u0001\"A\t\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\r\rd\u0017.\u001a8u\u0015\t9q#\u0003\u0002(G\t!2k\u00195f[\u0006\u0014VmZ5tiJL8\t\\5f]RD\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0006i>\u0004\u0018n\u0019\t\u0003WEr!\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017B\u0001\u001a4\u0005\u0019\u0019FO]5oO*\u0011\u0001'\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005A\u0001/\u0019:tK.+\u0017\u0010\u0005\u0002-o%\u0011\u0001(\f\u0002\b\u0005>|G.Z1o\u0011!Q\u0004A!A!\u0002\u0013Q\u0013\u0001D6fsN+\u0007/\u0019:bi>\u0014\b\"\u0002\u001f\u0001\t\u0003i\u0014A\u0002\u001fj]&$h\bF\u0003?\u0001\u0006\u00135\t\u0005\u0002@\u00015\t!\u0001C\u0003 w\u0001\u0007\u0011\u0005C\u0003*w\u0001\u0007!\u0006C\u00036w\u0001\u0007a\u0007C\u0003;w\u0001\u0007!\u0006C\u0004F\u0001\t\u0007I\u0011\u0002$\u0002\u0015-,\u0017pU;cU\u0016\u001cG/F\u0001+\u0011\u0019A\u0005\u0001)A\u0005U\u0005Y1.Z=Tk\nTWm\u0019;!\u0011\u001dQ\u0005A1A\u0005\n\u0019\u000bAB^1mk\u0016\u001cVO\u00196fGRDa\u0001\u0014\u0001!\u0002\u0013Q\u0013!\u0004<bYV,7+\u001e2kK\u000e$\b\u0005C\u0004O\u0001\t\u0007I\u0011B(\u0002\u001d\u0011,7m\u001c3fe\u001a\u000b7\r^8ssV\t\u0001\u000b\u0005\u0002R16\t!K\u0003\u0002\u001c'*\u0011\u0011\u0002\u0016\u0006\u0003+Z\u000ba!\u00199bG\",'\"A,\u0002\u0007=\u0014x-\u0003\u0002Z%\nqA)Z2pI\u0016\u0014h)Y2u_JL\bBB.\u0001A\u0003%\u0001+A\beK\u000e|G-\u001a:GC\u000e$xN]=!\u0011\u0015i\u0006\u0001\"\u0001_\u0003-\u0011X-\u00193NKN\u001c\u0018mZ3\u0015\t}s\u0007O\u001e\t\u0005A\u001aD\u0007.D\u0001b\u0015\t\u00117-\u0001\u0005qe>$WoY3s\u0015\t!W-A\u0004dY&,g\u000e^:\u000b\u0005a!\u0016BA4b\u00059\u0001&o\u001c3vG\u0016\u0014(+Z2pe\u0012\u00042\u0001L5l\u0013\tQWFA\u0003BeJ\f\u0017\u0010\u0005\u0002-Y&\u0011Q.\f\u0002\u0005\u0005f$X\rC\u0003p9\u0002\u0007!&A\u0002tiJDQ!\u001d/A\u0002I\f\u0011b[3z'\u000eDW-\\1\u0011\u0005M$X\"A*\n\u0005U\u001c&AB*dQ\u0016l\u0017\rC\u0003x9\u0002\u0007!/A\u0006wC2,XmU2iK6\f\u0007\"B=\u0001\t\u0013Q\u0018A\u00036t_:$v.\u0011<s_R!1P`A\u0001!\taC0\u0003\u0002~[\t1\u0011I\\=SK\u001aDQa =A\u0002)\n!B[:p]N#(/\u001b8h\u0011\u0019\t\u0019\u0001\u001fa\u0001e\u000611o\u00195f[\u0006\u0004")
public class ConfluentAvroMessageReader
extends AbstractKafkaAvroSerializer {
    private final String topic;
    private final boolean parseKey;
    private final String keySeparator;
    private final String keySubject;
    private final String valueSubject;
    private final DecoderFactory decoderFactory;

    private String keySubject() {
        return this.keySubject;
    }

    private String valueSubject() {
        return this.valueSubject;
    }

    private DecoderFactory decoderFactory() {
        return this.decoderFactory;
    }

    public ProducerRecord<byte[], byte[]> readMessage(String str, Schema keySchema, Schema valueSchema) {
        try {
            ProducerRecord producerRecord;
            if (this.parseKey) {
                int keyIndex = str.indexOf(this.keySeparator);
                if (keyIndex < 0) {
                    throw new SerializationException(new StringBuilder().append((Object)"No key found in line ").append((Object)str).toString());
                }
                String keyString = str.substring(0, keyIndex);
                String valueString = keyIndex + 1 > str.length() ? "" : str.substring(keyIndex + 1);
                Object key = this.jsonToAvro(keyString, keySchema);
                byte[] serializedKey = this.serializeImpl(this.keySubject(), key);
                Object value = this.jsonToAvro(valueString, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedKey, (Object)serializedValue);
            } else {
                Object value = this.jsonToAvro(str, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedValue);
            }
            return producerRecord;
        }
        catch (IOException iOException) {
            throw new SerializationException("Error reading from input", (Throwable)iOException);
        }
    }

    private Object jsonToAvro(String jsonString, Schema schema) {
        try {
            GenericDatumReader reader = new GenericDatumReader(schema);
            Object obj = reader.read(null, (Decoder)this.decoderFactory().jsonDecoder(schema, jsonString));
            Schema.Type type = schema.getType();
            Schema.Type type2 = Schema.Type.STRING;
            return !(type != null ? !type.equals(type2) : type2 != null) ? ((Utf8)obj).toString() : obj;
        }
        catch (AvroRuntimeException avroRuntimeException) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)avroRuntimeException);
        }
        catch (IOException iOException) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)iOException);
        }
    }

    public ConfluentAvroMessageReader(SchemaRegistryClient schemaRegistryClient, String topic, boolean parseKey, String keySeparator) {
        this.topic = topic;
        this.parseKey = parseKey;
        this.keySeparator = keySeparator;
        ((AbstractKafkaSchemaSerDe)this).schemaRegistry = schemaRegistryClient;
        this.keySubject = ConfluentUtils$.MODULE$.keySubject(topic);
        this.valueSubject = ConfluentUtils$.MODULE$.valueSubject(topic);
        this.decoderFactory = DecoderFactory.get();
    }
}

