/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.serialization;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.schema.DatumReaderWriterMixin;
import pl.touk.nussknacker.engine.avro.schema.DatumReaderWriterMixin$class;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.ConfluentUtils$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001A4Q!\u0001\u0002\u0002\u0002M\u0011a%\u00112tiJ\f7\r^\"p]\u001adW/\u001a8u\u0017\u000647.Y!we>$Um]3sS\u0006d\u0017N_3s\u0015\t\u0019A!A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u000b\u0019\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u001dA\u0011AD:dQ\u0016l\u0017M]3hSN$(/\u001f\u0006\u0003\u0013)\tA!\u0019<s_*\u00111\u0002D\u0001\u0007K:<\u0017N\\3\u000b\u00055q\u0011a\u00038vgN\\g.Y2lKJT!a\u0004\t\u0002\tQ|Wo\u001b\u0006\u0002#\u0005\u0011\u0001\u000f\\\u0002\u0001'\r\u0001Ac\b\t\u0003+ui\u0011A\u0006\u0006\u0003/a\t1b]3sS\u0006d\u0017N_3sg*\u0011\u0011DG\u0001\u0006W\u000647.\u0019\u0006\u0003\u000bmQ\u0011\u0001H\u0001\u0003S>L!A\b\f\u0003;\u0005\u00137\u000f\u001e:bGR\\\u0015MZ6b\u0003Z\u0014x\u000eR3tKJL\u0017\r\\5{KJ\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0005\u0002\rM\u001c\u0007.Z7b\u0013\t!\u0013E\u0001\fECR,XNU3bI\u0016\u0014xK]5uKJl\u0015\u000e_5o\u0011\u00151\u0003\u0001\"\u0001(\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0006\u0005\u0002*\u00015\t!\u0001\u0003\u0005,\u0001!\u0015\r\u0011\"\u0005-\u00039!WmY8eKJ4\u0015m\u0019;pef,\u0012!\f\t\u0003]Uj\u0011a\f\u0006\u00039AR!!C\u0019\u000b\u0005I\u001a\u0014AB1qC\u000eDWMC\u00015\u0003\ry'oZ\u0005\u0003m=\u0012a\u0002R3d_\u0012,'OR1di>\u0014\u0018\u0010\u0003\u00059\u0001!\u0005\t\u0015)\u0003.\u0003=!WmY8eKJ4\u0015m\u0019;pef\u0004\u0003\"\u0002\u001e\u0001\t#Z\u0014a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$R\u0001\u0010\"L+v\u0003\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0007\"B\":\u0001\u0004!\u0015!\u0002;pa&\u001c\u0007CA#I\u001d\tid)\u0003\u0002H}\u00051\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9e\bC\u0003Ms\u0001\u0007Q*A\u0003jg.+\u0017\u0010\u0005\u0002O'6\tqJ\u0003\u0002Q#\u0006!A.\u00198h\u0015\u0005\u0011\u0016\u0001\u00026bm\u0006L!\u0001V(\u0003\u000f\t{w\u000e\\3b]\")a+\u000fa\u0001/\u00069\u0001/Y=m_\u0006$\u0007cA\u001fY5&\u0011\u0011L\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003{mK!\u0001\u0018 \u0003\t\tKH/\u001a\u0005\u0006=f\u0002\raX\u0001\re\u0016\fG-\u001a:TG\",W.\u0019\t\u0003A\u0006l\u0011\u0001M\u0005\u0003EB\u0012aaU2iK6\f\u0007\"\u00023\u0001\t#)\u0017\u0001\u0002:fC\u0012$2\u0001\u00104o\u0011\u001597\r1\u0001i\u0003\u0019\u0011WO\u001a4feB\u0011\u0011\u000e\\\u0007\u0002U*\u00111.U\u0001\u0004]&|\u0017BA7k\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006_\u000e\u0004\raX\u0001\u000fKb\u0004Xm\u0019;fIN\u001b\u0007.Z7b\u0001")
public abstract class AbstractConfluentKafkaAvroDeserializer
extends AbstractKafkaAvroDeserializer
implements DatumReaderWriterMixin {
    private DecoderFactory decoderFactory;
    private final Map<String, Schema> primitives;
    private volatile boolean bitmap$0;

    private DecoderFactory decoderFactory$lzycompute() {
        AbstractConfluentKafkaAvroDeserializer abstractConfluentKafkaAvroDeserializer = this;
        synchronized (abstractConfluentKafkaAvroDeserializer) {
            if (!this.bitmap$0) {
                this.decoderFactory = DecoderFactory.get();
                this.bitmap$0 = true;
            }
            return this.decoderFactory;
        }
    }

    @Override
    public Map<String, Schema> primitives() {
        return this.primitives;
    }

    @Override
    public void pl$touk$nussknacker$engine$avro$schema$DatumReaderWriterMixin$_setter_$primitives_$eq(Map x$1) {
        this.primitives = x$1;
    }

    @Override
    public GenericDatumWriter<Object> createDatumWriter(Object record, Schema schema, boolean useSchemaReflection) {
        return DatumReaderWriterMixin$class.createDatumWriter(this, record, schema, useSchemaReflection);
    }

    @Override
    public DatumReader<Object> createDatumReader(Schema writerSchema, Schema readerSchema, boolean useSchemaReflection, boolean useSpecificAvroReader) {
        return DatumReaderWriterMixin$class.createDatumReader(this, writerSchema, readerSchema, useSchemaReflection, useSpecificAvroReader);
    }

    public DecoderFactory decoderFactory() {
        return this.bitmap$0 ? this.decoderFactory : this.decoderFactory$lzycompute();
    }

    public Object deserialize(String topic, Boolean isKey, byte[] payload, Schema readerSchema) {
        ByteBuffer buffer = (ByteBuffer)ConfluentUtils$.MODULE$.parsePayloadToByteBuffer(payload).valueOr((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(IllegalArgumentException ex) {
                throw ex;
            }
        });
        return this.read(buffer, readerSchema);
    }

    public Object read(ByteBuffer buffer, Schema expectedSchema) {
        int schemaId = -1;
        try {
            Object object;
            schemaId = buffer.getInt();
            ParsedSchema parsedSchema = this.schemaRegistry.getSchemaById(schemaId);
            Schema writerSchema = ConfluentUtils$.MODULE$.extractSchema(parsedSchema);
            Schema readerSchema = expectedSchema == null ? writerSchema : expectedSchema;
            DatumReader<Object> reader = this.createDatumReader(writerSchema, readerSchema, this.useSchemaReflection, this.useSpecificAvroReader);
            int length = buffer.limit() - 1 - 4;
            Schema.Type type = writerSchema.getType();
            Schema.Type type2 = Schema.Type.BYTES;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                object = bytes;
            } else {
                int start = buffer.position() + buffer.arrayOffset();
                BinaryDecoder binaryDecoder = this.decoderFactory().binaryDecoder(buffer.array(), start, length, null);
                Object result = reader.read(null, (Decoder)binaryDecoder);
                Schema.Type type3 = writerSchema.getType();
                Schema.Type type4 = Schema.Type.STRING;
                object = !(type3 != null ? !type3.equals(type4) : type4 != null) ? (Object)result.toString() : (Object)result;
            }
            return object;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RestClientException) {
                RestClientException restClientException = (RestClientException)throwable2;
                throw new SerializationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error retrieving Avro schema for id : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schemaId)})), (Throwable)restClientException);
            }
            boolean bl = throwable2 instanceof RuntimeException ? true : throwable2 instanceof IOException;
            if (bl) {
                throw new SerializationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deserializing Avro message for id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schemaId)})), throwable2);
            }
            throw throwable;
        }
    }

    public AbstractConfluentKafkaAvroDeserializer() {
        DatumReaderWriterMixin$class.$init$(this);
    }
}

