/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.formatter;

import io.confluent.kafka.schemaregistry.avro.AvroSchemaUtils;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.kafka.common.errors.SerializationException;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]3Q!\u0001\u0002\u0001\tI\u0011QdQ8oM2,XM\u001c;BmJ|W*Z:tC\u001e,gi\u001c:nCR$XM\u001d\u0006\u0003\u0007\u0011\t\u0011BZ8s[\u0006$H/\u001a:\u000b\u0005\u00151\u0011!C2p]\u001adW/\u001a8u\u0015\t9\u0001\"\u0001\btG\",W.\u0019:fO&\u001cHO]=\u000b\u0005%Q\u0011\u0001B1we>T!a\u0003\u0007\u0002\r\u0015tw-\u001b8f\u0015\tia\"A\u0006okN\u001c8N\\1dW\u0016\u0014(BA\b\u0011\u0003\u0011!x.^6\u000b\u0003E\t!\u0001\u001d7\u0014\u0005\u0001\u0019\u0002C\u0001\u000b\u001d\u001b\u0005)\"B\u0001\f\u0018\u0003-\u0019XM]5bY&TXM]:\u000b\u0005aI\u0012!B6bM.\f'BA\u0003\u001b\u0015\u0005Y\u0012AA5p\u0013\tiRCA\u000fBEN$(/Y2u\u0017\u000647.Y!we>$Um]3sS\u0006d\u0017N_3s\u0011!y\u0002A!A!\u0002\u0013\t\u0013\u0001F:dQ\u0016l\u0017MU3hSN$(/_\"mS\u0016tGo\u0001\u0001\u0011\u0005\t2S\"A\u0012\u000b\u0005\u0011*\u0013AB2mS\u0016tGO\u0003\u0002\b/%\u0011qe\t\u0002\u0015'\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u00072LWM\u001c;\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\tYS\u0006\u0005\u0002-\u00015\t!\u0001C\u0003 Q\u0001\u0007\u0011\u0005C\u00040\u0001\t\u0007I\u0011\u0002\u0019\u0002\u001d\u0015t7m\u001c3fe\u001a\u000b7\r^8ssV\t\u0011\u0007\u0005\u00023s5\t1G\u0003\u0002\u001ci)\u0011\u0011\"\u000e\u0006\u0003m]\na!\u00199bG\",'\"\u0001\u001d\u0002\u0007=\u0014x-\u0003\u0002;g\tqQI\\2pI\u0016\u0014h)Y2u_JL\bB\u0002\u001f\u0001A\u0003%\u0011'A\bf]\u000e|G-\u001a:GC\u000e$xN]=!\u0011\u0015q\u0004\u0001\"\u0001@\u0003\u001d9(/\u001b;f)>$2\u0001\u0011$O!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0011)f.\u001b;\t\u000b\u001dk\u0004\u0019\u0001%\u0002\t\u0011\fG/\u0019\t\u0004\u0003&[\u0015B\u0001&C\u0005\u0015\t%O]1z!\t\tE*\u0003\u0002N\u0005\n!!)\u001f;f\u0011\u0015yU\b1\u0001Q\u0003\u0019yW\u000f\u001e9viB\u0011\u0011+V\u0007\u0002%*\u00111d\u0015\u0006\u0002)\u0006!!.\u0019<b\u0013\t1&KA\u0006Qe&tGo\u0015;sK\u0006l\u0007")
public class ConfluentAvroMessageFormatter
extends AbstractKafkaAvroDeserializer {
    private final EncoderFactory encoderFactory = EncoderFactory.get();

    private EncoderFactory encoderFactory() {
        return this.encoderFactory;
    }

    public void writeTo(byte[] data, PrintStream output) {
        Object obj = this.deserialize(data);
        Schema schema = AvroSchemaUtils.getSchema((Object)obj);
        try {
            JsonEncoder encoder = this.encoderFactory().jsonEncoder(schema, (OutputStream)output);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            Object object = obj;
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                writer.write((Object)ByteBuffer.wrap(byArray), (Encoder)encoder);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                writer.write(obj, (Encoder)encoder);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            encoder.flush();
            return;
        }
        catch (AvroRuntimeException avroRuntimeException) {
            throw new SerializationException(String.format("Error serializing Avro data of schema %s to json", schema), (Throwable)avroRuntimeException);
        }
    }

    public ConfluentAvroMessageFormatter(SchemaRegistryClient schemaRegistryClient) {
        ((AbstractKafkaSchemaSerDe)this).schemaRegistry = schemaRegistryClient;
    }
}

