/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.util.Utf8;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.GenericTypeInfo;
import org.apache.flink.api.java.typeutils.PojoField;
import org.apache.flink.api.java.typeutils.PojoTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.formats.avro.typeutils.LogicalTypesAvroSerializer;

public class LogicalTypesAvroTypeInfo<T extends SpecificRecordBase>
extends PojoTypeInfo<T> {
    private static final long serialVersionUID = -8635380660085215330L;

    public LogicalTypesAvroTypeInfo(Class<T> clazz) {
        super(clazz, LogicalTypesAvroTypeInfo.generateFieldsFromAvroSchema(clazz));
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return new LogicalTypesAvroSerializer(this.getTypeClass());
    }

    @Internal
    private static <T extends SpecificRecordBase> List<PojoField> generateFieldsFromAvroSchema(Class<T> clazz) {
        PojoTypeExtractor pojoTypeExtractor = new PojoTypeExtractor();
        ArrayList<Type> arrayList = new ArrayList<Type>();
        arrayList.add(clazz);
        TypeInformation<T> typeInformation = pojoTypeExtractor.analyzePojo(clazz, arrayList, null, null, null);
        if (!(typeInformation instanceof PojoTypeInfo)) {
            throw new IllegalStateException("Expecting type to be a PojoTypeInfo");
        }
        PojoTypeInfo pojoTypeInfo = (PojoTypeInfo)typeInformation;
        ArrayList<PojoField> arrayList2 = new ArrayList<PojoField>(pojoTypeInfo.getTotalFields());
        for (int i = 0; i < pojoTypeInfo.getArity(); ++i) {
            PojoField pojoField = pojoTypeInfo.getPojoFieldAt(i);
            TypeInformation typeInformation2 = pojoField.getTypeInformation();
            if (typeInformation2 instanceof GenericTypeInfo && typeInformation2.getTypeClass().equals(CharSequence.class)) {
                typeInformation2 = new GenericTypeInfo(Utf8.class);
            }
            PojoField pojoField2 = new PojoField(pojoField.getField(), typeInformation2);
            arrayList2.add(pojoField2);
        }
        return arrayList2;
    }

    private static class PojoTypeExtractor
    extends TypeExtractor {
        private PojoTypeExtractor() {
        }

        public <OUT, IN1, IN2> TypeInformation<OUT> analyzePojo(Class<OUT> clazz, ArrayList<Type> arrayList, ParameterizedType parameterizedType, TypeInformation<IN1> typeInformation, TypeInformation<IN2> typeInformation2) {
            return super.analyzePojo(clazz, arrayList, parameterizedType, typeInformation, typeInformation2);
        }
    }
}

