/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilderBase;
import org.apache.avro.generic.GenericData;
import pl.touk.nussknacker.engine.avro.AvroUtils;

public class LogicalTypesGenericRecordBuilder
extends RecordBuilderBase<GenericData.Record> {
    private final GenericData.Record record;

    public LogicalTypesGenericRecordBuilder(Schema schema) {
        super(schema, AvroUtils.genericData());
        this.record = new GenericData.Record(schema);
    }

    public LogicalTypesGenericRecordBuilder(LogicalTypesGenericRecordBuilder logicalTypesGenericRecordBuilder) {
        super((RecordBuilderBase)logicalTypesGenericRecordBuilder, AvroUtils.genericData());
        this.record = new GenericData.Record(logicalTypesGenericRecordBuilder.record, true);
    }

    public LogicalTypesGenericRecordBuilder(GenericData.Record record) {
        super(record.getSchema(), AvroUtils.genericData());
        this.record = new GenericData.Record(record, true);
        for (Schema.Field field : this.schema().getFields()) {
            Object object;
            if (!LogicalTypesGenericRecordBuilder.isValidValue((Schema.Field)field, (Object)(object = record.get(field.pos())))) continue;
            this.set(field, this.data().deepCopy(field.schema(), object));
        }
    }

    public Object get(String string) {
        return this.get(this.schema().getField(string));
    }

    public Object get(Schema.Field field) {
        return this.get(field.pos());
    }

    protected Object get(int n) {
        return this.record.get(n);
    }

    public LogicalTypesGenericRecordBuilder set(String string, Object object) {
        return this.set(this.schema().getField(string), object);
    }

    public LogicalTypesGenericRecordBuilder set(Schema.Field field, Object object) {
        return this.set(field, field.pos(), object);
    }

    protected LogicalTypesGenericRecordBuilder set(int n, Object object) {
        return this.set(this.fields()[n], n, object);
    }

    private LogicalTypesGenericRecordBuilder set(Schema.Field field, int n, Object object) {
        this.validate(field, object);
        this.record.put(n, object);
        this.fieldSetFlags()[n] = true;
        return this;
    }

    public boolean has(String string) {
        return this.has(this.schema().getField(string));
    }

    public boolean has(Schema.Field field) {
        return this.has(field.pos());
    }

    protected boolean has(int n) {
        return this.fieldSetFlags()[n];
    }

    public LogicalTypesGenericRecordBuilder clear(String string) {
        return this.clear(this.schema().getField(string));
    }

    public LogicalTypesGenericRecordBuilder clear(Schema.Field field) {
        return this.clear(field.pos());
    }

    protected LogicalTypesGenericRecordBuilder clear(int n) {
        this.record.put(n, null);
        this.fieldSetFlags()[n] = false;
        return this;
    }

    public GenericData.Record build() {
        GenericData.Record record;
        try {
            record = new GenericData.Record(this.schema());
        }
        catch (Exception exception) {
            throw new AvroRuntimeException((Throwable)exception);
        }
        for (Schema.Field field : this.fields()) {
            Object object;
            try {
                object = this.getWithDefault(field);
            }
            catch (IOException iOException) {
                throw new AvroRuntimeException((Throwable)iOException);
            }
            if (object == null) continue;
            record.put(field.pos(), object);
        }
        return record;
    }

    private Object getWithDefault(Schema.Field field) throws IOException {
        return this.fieldSetFlags()[field.pos()] ? this.record.get(field.pos()) : this.defaultValue(field);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.record == null ? 0 : this.record.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        LogicalTypesGenericRecordBuilder logicalTypesGenericRecordBuilder = (LogicalTypesGenericRecordBuilder)((Object)object);
        if (this.record == null) {
            return logicalTypesGenericRecordBuilder.record == null;
        }
        return this.record.equals((Object)logicalTypesGenericRecordBuilder.record);
    }
}

