/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.formatter;

import io.circe.Json;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import io.confluent.kafka.serializers.AbstractKafkaSchemaSerDe;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.kafka.common.errors.SerializationException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001!4Q!\u0001\u0002\u0001\tI\u0011!dQ8oM2,XM\u001c;BmJ|W*Z:tC\u001e,'+Z1eKJT!a\u0001\u0003\u0002\u0013\u0019|'/\\1ui\u0016\u0014(BA\u0003\u0007\u0003%\u0019wN\u001c4mk\u0016tGO\u0003\u0002\b\u0011\u0005q1o\u00195f[\u0006\u0014XmZ5tiJL(BA\u0005\u000b\u0003\u0011\tgO]8\u000b\u0005-a\u0011AB3oO&tWM\u0003\u0002\u000e\u001d\u0005Ya.^:tW:\f7m[3s\u0015\ty\u0001#\u0001\u0003u_V\\'\"A\t\u0002\u0005Ad7C\u0001\u0001\u0014!\t!B$D\u0001\u0016\u0015\t1r#A\u0006tKJL\u0017\r\\5{KJ\u001c(B\u0001\r\u001a\u0003\u0015Y\u0017MZ6b\u0015\t)!DC\u0001\u001c\u0003\tIw.\u0003\u0002\u001e+\tY\u0012IY:ue\u0006\u001cGoS1gW\u0006\feO]8TKJL\u0017\r\\5{KJD\u0001b\b\u0001\u0003\u0002\u0003\u0006I!I\u0001\u0015g\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u00072LWM\u001c;\u0004\u0001A\u0011!EJ\u0007\u0002G)\u0011A%J\u0001\u0007G2LWM\u001c;\u000b\u0005\u001d9\u0012BA\u0014$\u0005Q\u00196\r[3nCJ+w-[:uef\u001cE.[3oi\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\"aK\u0017\u0011\u00051\u0002Q\"\u0001\u0002\t\u000b}A\u0003\u0019A\u0011\t\u000f=\u0002!\u0019!C\u0005a\u0005qA-Z2pI\u0016\u0014h)Y2u_JLX#A\u0019\u0011\u0005IJT\"A\u001a\u000b\u0005m!$BA\u00056\u0015\t1t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002q\u0005\u0019qN]4\n\u0005i\u001a$A\u0004#fG>$WM\u001d$bGR|'/\u001f\u0005\u0007y\u0001\u0001\u000b\u0011B\u0019\u0002\u001f\u0011,7m\u001c3fe\u001a\u000b7\r^8ss\u0002BQA\u0010\u0001\u0005\u0002}\n\u0001B]3bI*\u001bxN\u001c\u000b\u0005\u0001&\u000bv\u000bE\u0002B\t\u001ak\u0011A\u0011\u0006\u0002\u0007\u0006)1oY1mC&\u0011QI\u0011\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0003\u001eK!\u0001\u0013\"\u0003\t\tKH/\u001a\u0005\u0006\u0015v\u0002\raS\u0001\bUN|gn\u00142k!\tau*D\u0001N\u0015\tq%$A\u0003dSJ\u001cW-\u0003\u0002Q\u001b\n!!j]8o\u0011\u0015\u0011V\b1\u0001T\u0003\u0019\u00198\r[3nCB\u0011A+V\u0007\u0002i%\u0011a\u000b\u000e\u0002\u0007'\u000eDW-\\1\t\u000bak\u0004\u0019A-\u0002\u000fM,(M[3diB\u0011!,\u0018\b\u0003\u0003nK!\u0001\u0018\"\u0002\rA\u0013X\rZ3g\u0013\tqvL\u0001\u0004TiJLgn\u001a\u0006\u00039\nCQ!\u0019\u0001\u0005\n\t\f!B[:p]R{\u0017I\u001e:p)\r\u0019gm\u001a\t\u0003\u0003\u0012L!!\u001a\"\u0003\r\u0005s\u0017PU3g\u0011\u0015Q\u0005\r1\u0001L\u0011\u0015\u0011\u0006\r1\u0001T\u0001")
public class ConfluentAvroMessageReader
extends AbstractKafkaAvroSerializer {
    private final DecoderFactory decoderFactory;

    private DecoderFactory decoderFactory() {
        return this.decoderFactory;
    }

    public byte[] readJson(Json jsonObj, Schema schema, String subject) {
        try {
            Object avroObj = this.jsonToAvro(jsonObj, schema);
            return this.serializeImpl(subject, avroObj, new AvroSchema(schema));
        }
        catch (Exception exception) {
            throw new SerializationException("Error reading from input", (Throwable)exception);
        }
    }

    private Object jsonToAvro(Json jsonObj, Schema schema) {
        String jsonString = jsonObj.noSpaces();
        try {
            DatumReader reader = GenericData.get().createDatumReader(schema);
            Object obj = reader.read(null, (Decoder)this.decoderFactory().jsonDecoder(schema, jsonString));
            Schema.Type type = schema.getType();
            Schema.Type type2 = Schema.Type.STRING;
            return !(type != null ? !type.equals(type2) : type2 != null) ? ((Utf8)obj).toString() : obj;
        }
        catch (Exception exception) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)exception);
        }
    }

    public ConfluentAvroMessageReader(SchemaRegistryClient schemaRegistryClient) {
        ((AbstractKafkaSchemaSerDe)this).schemaRegistry = schemaRegistryClient;
        this.decoderFactory = DecoderFactory.get();
    }
}

