/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.formats.avro.typeutils;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.reflect.Nullable;

public final class NkSerializableAvroSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Nullable
    private transient Schema schema;

    public NkSerializableAvroSchema() {
    }

    public NkSerializableAvroSchema(Schema schema) {
        this.schema = schema;
    }

    public Schema getAvroSchema() {
        return this.schema;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.schema == null) {
            objectOutputStream.writeBoolean(false);
        } else {
            objectOutputStream.writeBoolean(true);
            objectOutputStream.writeUTF(this.schema.toString(false));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        if (objectInputStream.readBoolean()) {
            String string = objectInputStream.readUTF();
            this.schema = new Schema.Parser().parse(string);
        } else {
            this.schema = null;
        }
    }
}

