/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.serialization;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.RuntimeSchemaData;
import pl.touk.nussknacker.engine.avro.RuntimeSchemaData$;
import pl.touk.nussknacker.engine.avro.schema.DatumReaderWriterMixin;
import pl.touk.nussknacker.engine.avro.schema.DatumReaderWriterMixin$class;
import pl.touk.nussknacker.engine.avro.schema.RecordDeserializer;
import pl.touk.nussknacker.engine.avro.schema.RecordDeserializer$class;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.ConfluentUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001Y4Q!\u0001\u0002\u0002\u0002M\u0011a%\u00112tiJ\f7\r^\"p]\u001adW/\u001a8u\u0017\u000647.Y!we>$Um]3sS\u0006d\u0017N_3s\u0015\t\u0019A!A\u0007tKJL\u0017\r\\5{CRLwN\u001c\u0006\u0003\u000b\u0019\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u001dA\u0011AD:dQ\u0016l\u0017M]3hSN$(/\u001f\u0006\u0003\u0013)\tA!\u0019<s_*\u00111\u0002D\u0001\u0007K:<\u0017N\\3\u000b\u00055q\u0011a\u00038vgN\\g.Y2lKJT!a\u0004\t\u0002\tQ|Wo\u001b\u0006\u0002#\u0005\u0011\u0001\u000f\\\u0002\u0001'\u0011\u0001AcH\u0013\u0011\u0005UiR\"\u0001\f\u000b\u0005]A\u0012aC:fe&\fG.\u001b>feNT!!\u0007\u000e\u0002\u000b-\fgm[1\u000b\u0005\u0015Y\"\"\u0001\u000f\u0002\u0005%|\u0017B\u0001\u0010\u0017\u0005u\t%m\u001d;sC\u000e$8*\u00194lC\u00063(o\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\bC\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\t\u0003\u0019\u00198\r[3nC&\u0011A%\t\u0002\u0017\t\u0006$X/\u001c*fC\u0012,'o\u0016:ji\u0016\u0014X*\u001b=j]B\u0011\u0001EJ\u0005\u0003O\u0005\u0012!CU3d_J$G)Z:fe&\fG.\u001b>fe\")\u0011\u0006\u0001C\u0001U\u00051A(\u001b8jiz\"\u0012a\u000b\t\u0003Y\u0001i\u0011A\u0001\u0005\t]\u0001A)\u0019!C)_\u0005qA-Z2pI\u0016\u0014h)Y2u_JLX#\u0001\u0019\u0011\u0005EBT\"\u0001\u001a\u000b\u0005q\u0019$BA\u00055\u0015\t)d'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002o\u0005\u0019qN]4\n\u0005e\u0012$A\u0004#fG>$WM\u001d$bGR|'/\u001f\u0005\tw\u0001A\t\u0011)Q\u0005a\u0005yA-Z2pI\u0016\u0014h)Y2u_JL\b\u0005C\u0003>\u0001\u0011Ea(A\u0006eKN,'/[1mSj,G#B F\u001db\u0003\u0007C\u0001!D\u001b\u0005\t%\"\u0001\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\u000b%AB!osJ+g\rC\u0003Gy\u0001\u0007q)A\u0003u_BL7\r\u0005\u0002I\u0017:\u0011\u0001)S\u0005\u0003\u0015\u0006\u000ba\u0001\u0015:fI\u00164\u0017B\u0001'N\u0005\u0019\u0019FO]5oO*\u0011!*\u0011\u0005\u0006\u001fr\u0002\r\u0001U\u0001\u0006SN\\U-\u001f\t\u0003#Zk\u0011A\u0015\u0006\u0003'R\u000bA\u0001\\1oO*\tQ+\u0001\u0003kCZ\f\u0017BA,S\u0005\u001d\u0011un\u001c7fC:DQ!\u0017\u001fA\u0002i\u000bq\u0001]1zY>\fG\rE\u0002A7vK!\u0001X!\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0001s\u0016BA0B\u0005\u0011\u0011\u0015\u0010^3\t\u000b\u0005d\u0004\u0019\u00012\u0002\u0019I,\u0017\rZ3s'\u000eDW-\\1\u0011\u0007\u0001\u001bW-\u0003\u0002e\u0003\n1q\n\u001d;j_:\u0004\"AZ4\u000e\u0003!I!\u0001\u001b\u0005\u0003#I+h\u000e^5nKN\u001b\u0007.Z7b\t\u0006$\u0018\rC\u0003k\u0001\u0011E1.\u0001\u0003sK\u0006$GcA mi\")Q.\u001ba\u0001]\u00061!-\u001e4gKJ\u0004\"a\u001c:\u000e\u0003AT!!\u001d+\u0002\u00079Lw.\u0003\u0002ta\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bUL\u0007\u0019\u00012\u0002%\u0015D\b/Z2uK\u0012\u001c6\r[3nC\u0012\u000bG/\u0019")
public abstract class AbstractConfluentKafkaAvroDeserializer
extends AbstractKafkaAvroDeserializer
implements DatumReaderWriterMixin,
RecordDeserializer {
    private DecoderFactory decoderFactory;
    private final Map<String, Schema> primitives;
    private volatile boolean bitmap$0;

    private DecoderFactory decoderFactory$lzycompute() {
        AbstractConfluentKafkaAvroDeserializer abstractConfluentKafkaAvroDeserializer = this;
        synchronized (abstractConfluentKafkaAvroDeserializer) {
            if (!this.bitmap$0) {
                this.decoderFactory = DecoderFactory.get();
                this.bitmap$0 = true;
            }
            return this.decoderFactory;
        }
    }

    @Override
    public Object deserializeRecord(RuntimeSchemaData readerSchemaData, DatumReader<Object> reader, ByteBuffer buffer, int bufferDataStart) {
        return RecordDeserializer$class.deserializeRecord(this, readerSchemaData, reader, buffer, bufferDataStart);
    }

    @Override
    public Map<String, Schema> primitives() {
        return this.primitives;
    }

    @Override
    public void pl$touk$nussknacker$engine$avro$schema$DatumReaderWriterMixin$_setter_$primitives_$eq(Map x$1) {
        this.primitives = x$1;
    }

    @Override
    public GenericDatumWriter<Object> createDatumWriter(Object record, Schema schema, boolean useSchemaReflection) {
        return DatumReaderWriterMixin$class.createDatumWriter(this, record, schema, useSchemaReflection);
    }

    @Override
    public DatumReader<Object> createDatumReader(Schema writerSchema, Schema readerSchema, boolean useSchemaReflection, boolean useSpecificAvroReader) {
        return DatumReaderWriterMixin$class.createDatumReader(this, writerSchema, readerSchema, useSchemaReflection, useSpecificAvroReader);
    }

    @Override
    public DecoderFactory decoderFactory() {
        return this.bitmap$0 ? this.decoderFactory : this.decoderFactory$lzycompute();
    }

    public Object deserialize(String topic, Boolean isKey, byte[] payload, Option<RuntimeSchemaData> readerSchema) {
        ByteBuffer buffer = (ByteBuffer)ConfluentUtils$.MODULE$.parsePayloadToByteBuffer(payload).valueOr((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(IllegalArgumentException ex) {
                throw ex;
            }
        });
        return this.read(buffer, readerSchema);
    }

    public Object read(ByteBuffer buffer, Option<RuntimeSchemaData> expectedSchemaData) {
        int schemaId = -1;
        try {
            schemaId = buffer.getInt();
            ParsedSchema parsedSchema = this.schemaRegistry.getSchemaById(schemaId);
            RuntimeSchemaData writerSchemaData = RuntimeSchemaData$.MODULE$.apply(ConfluentUtils$.MODULE$.extractSchema(parsedSchema), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)schemaId)));
            RuntimeSchemaData readerSchemaData = (RuntimeSchemaData)expectedSchemaData.getOrElse((Function0)new Serializable(this, writerSchemaData){
                public static final long serialVersionUID = 0L;
                private final RuntimeSchemaData writerSchemaData$1;

                public final RuntimeSchemaData apply() {
                    return this.writerSchemaData$1;
                }
                {
                    this.writerSchemaData$1 = writerSchemaData$1;
                }
            });
            DatumReader<Object> reader = this.createDatumReader(writerSchemaData.schema(), readerSchemaData.schema(), this.useSchemaReflection, this.useSpecificAvroReader);
            int bufferDataStart = 5;
            return this.deserializeRecord(readerSchemaData, reader, buffer, bufferDataStart);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RestClientException) {
                RestClientException restClientException = (RestClientException)throwable2;
                throw new SerializationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error retrieving Avro schema for id : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schemaId)})), (Throwable)restClientException);
            }
            boolean bl = throwable2 instanceof RuntimeException ? true : throwable2 instanceof IOException;
            if (bl) {
                throw new SerializationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error deserializing Avro message for id: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)schemaId)})), throwable2);
            }
            throw throwable;
        }
    }

    public AbstractConfluentKafkaAvroDeserializer() {
        DatumReaderWriterMixin$class.$init$(this);
        RecordDeserializer$class.$init$(this);
    }
}

