/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.encode;

import cats.Applicative;
import cats.data.NonEmptyList;
import cats.data.NonEmptyList$;
import cats.data.Validated;
import cats.data.Validated$;
import cats.implicits$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.util.Utf8;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.Iterable$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class BestEffortAvroEncoder$ {
    public static BestEffortAvroEncoder$ MODULE$;

    static {
        new BestEffortAvroEncoder$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Validated<NonEmptyList<String>, Object> encode(Object value, Schema schema) {
        Object object;
        Schema.Type type;
        Object object2;
        Tuple2 tuple2;
        while ((tuple2 = new Tuple2((Object)schema.getType(), value)) != null && (object2 = tuple2._2()) instanceof Some) {
            Object nested;
            Some some = (Some)object2;
            value = nested = some.value();
        }
        if (tuple2 != null) {
            Schema.Type type2 = (Schema.Type)tuple2._1();
            Object map = tuple2._2();
            if (Schema.Type.RECORD.equals(type2) && map instanceof Map) {
                Map map2 = (Map)map;
                return this.encodeRecord(map2, schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type3 = (Schema.Type)tuple2._1();
            Object map = tuple2._2();
            if (Schema.Type.RECORD.equals(type3) && map instanceof java.util.Map) {
                java.util.Map map3 = (java.util.Map)map;
                return this.encodeRecord(map3, schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type4 = (Schema.Type)tuple2._1();
            Object str = tuple2._2();
            if (Schema.Type.ENUM.equals(type4) && str instanceof String) {
                String string = (String)str;
                return !schema.hasEnumSymbol(string) ? this.error(new StringBuilder(34).append("Not expected symbol: ").append(value).append(" for schema: ").append(schema).toString()) : new Validated<NonEmptyList<String>, java.util.Map<CharSequence, Object>>((Object)new GenericData.EnumSymbol(schema, string));
            }
        }
        if (tuple2 != null) {
            Schema.Type type5 = (Schema.Type)tuple2._1();
            Object collection = tuple2._2();
            if (Schema.Type.ARRAY.equals(type5) && collection instanceof Traversable) {
                Traversable traversable = (Traversable)collection;
                return this.encodeCollection(traversable, schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type6 = (Schema.Type)tuple2._1();
            Object collection = tuple2._2();
            if (Schema.Type.ARRAY.equals(type6) && collection instanceof Collection) {
                Collection collection2 = (Collection)collection;
                return this.encodeCollection((Traversable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(collection2).asScala(), schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type7 = (Schema.Type)tuple2._1();
            Object map = tuple2._2();
            if (Schema.Type.MAP.equals(type7) && map instanceof Map) {
                Map map4 = (Map)map;
                return this.encodeMap(map4, schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type8 = (Schema.Type)tuple2._1();
            Object map = tuple2._2();
            if (Schema.Type.MAP.equals(type8) && map instanceof java.util.Map) {
                java.util.Map map5 = (java.util.Map)map;
                return this.encodeMap((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(map5).asScala(), schema);
            }
        }
        if (tuple2 != null && Schema.Type.UNION.equals(type = (Schema.Type)tuple2._1())) {
            return (Validated.Invalid<NonEmptyList<String>>)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getTypes()).asScala()).toStream().flatMap((Function1 & Serializable & scala.Serializable)subTypeSchema -> Option$.MODULE$.option2Iterable(MODULE$.encode(value, (Schema)subTypeSchema).toOption()), Stream$.MODULE$.canBuildFrom())).headOption().map((Function1 & Serializable & scala.Serializable)x$1 -> new Validated.Valid(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.error(new StringBuilder(59).append("Cant't find matching union subtype for value: ").append(value).append(" for schema: ").append(schema).toString()));
        }
        if (tuple2 != null) {
            Schema.Type type9 = (Schema.Type)tuple2._1();
            Object str = tuple2._2();
            if (Schema.Type.FIXED.equals(type9) && str instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)str;
                byte[] bytes = ((Object)charSequence).toString().getBytes(StandardCharsets.UTF_8);
                return this.encodeFixed(bytes, schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type10 = (Schema.Type)tuple2._1();
            Object buffer = tuple2._2();
            if (Schema.Type.FIXED.equals(type10) && buffer instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                return this.encodeFixed(byteBuffer.array(), schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type11 = (Schema.Type)tuple2._1();
            Object bytes = tuple2._2();
            if (Schema.Type.FIXED.equals(type11) && bytes instanceof byte[]) {
                byte[] byArray = (byte[])bytes;
                return this.encodeFixed(byArray, schema);
            }
        }
        if (tuple2 != null) {
            Schema.Type type12 = (Schema.Type)tuple2._1();
            Object str = tuple2._2();
            if (Schema.Type.STRING.equals(type12) && str instanceof String) {
                String string = (String)str;
                return new Validated.Invalid<NonEmptyList<String>>((Object)this.encodeString(string));
            }
        }
        if (tuple2 != null) {
            Schema.Type type13 = (Schema.Type)tuple2._1();
            Object str = tuple2._2();
            if (Schema.Type.STRING.equals(type13) && str instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)str;
                return new Validated.Valid((Object)charSequence);
            }
        }
        if (tuple2 != null) {
            Schema.Type type14 = (Schema.Type)tuple2._1();
            Object str = tuple2._2();
            if (Schema.Type.BYTES.equals(type14) && str instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)str;
                return new Validated.Valid((Object)ByteBuffer.wrap(((Object)charSequence).toString().getBytes(StandardCharsets.UTF_8)));
            }
        }
        if (tuple2 != null) {
            Schema.Type type15 = (Schema.Type)tuple2._1();
            Object bytes = tuple2._2();
            if (Schema.Type.BYTES.equals(type15) && bytes instanceof byte[]) {
                byte[] byArray = (byte[])bytes;
                return new Validated.Valid((Object)ByteBuffer.wrap(byArray));
            }
        }
        if (tuple2 != null) {
            Schema.Type type16 = (Schema.Type)tuple2._1();
            Object buffer = tuple2._2();
            if (Schema.Type.BYTES.equals(type16) && buffer instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)buffer;
                return new Validated.Valid((Object)byteBuffer);
            }
        }
        if (tuple2 != null) {
            Schema.Type type17 = (Schema.Type)tuple2._1();
            Object number = tuple2._2();
            if (Schema.Type.INT.equals(type17) && number instanceof Number) {
                Number number2 = (Number)number;
                return new Validated.Valid((Object)BoxesRunTime.boxToInteger((int)number2.intValue()));
            }
        }
        if (tuple2 != null) {
            Schema.Type type18 = (Schema.Type)tuple2._1();
            Object number = tuple2._2();
            if (Schema.Type.LONG.equals(type18) && number instanceof Number) {
                Number number3 = (Number)number;
                return new Validated.Valid((Object)BoxesRunTime.boxToLong((long)number3.longValue()));
            }
        }
        if (tuple2 != null) {
            Schema.Type type19 = (Schema.Type)tuple2._1();
            Object number = tuple2._2();
            if (Schema.Type.FLOAT.equals(type19) && number instanceof Number) {
                Number number4 = (Number)number;
                return new Validated.Valid((Object)BoxesRunTime.boxToFloat((float)number4.floatValue()));
            }
        }
        if (tuple2 != null) {
            Schema.Type type20 = (Schema.Type)tuple2._1();
            Object number = tuple2._2();
            if (Schema.Type.DOUBLE.equals(type20) && number instanceof Number) {
                Number number5 = (Number)number;
                return new Validated.Valid((Object)BoxesRunTime.boxToDouble((double)number5.doubleValue()));
            }
        }
        if (tuple2 != null) {
            Schema.Type type21 = (Schema.Type)tuple2._1();
            Object object3 = tuple2._2();
            if (Schema.Type.BOOLEAN.equals(type21) && object3 instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object3);
                return new Validated.Valid((Object)BoxesRunTime.boxToBoolean((boolean)bl));
            }
        }
        if (tuple2 != null) {
            Schema.Type type22 = (Schema.Type)tuple2._1();
            Object object4 = tuple2._2();
            if (Schema.Type.NULL.equals(type22) && object4 == null) {
                return new Validated.Valid(null);
            }
        }
        if (tuple2 != null) {
            Schema.Type type23 = (Schema.Type)tuple2._1();
            Object object5 = tuple2._2();
            if (Schema.Type.NULL.equals(type23) && None$.MODULE$.equals(object5)) {
                return new Validated.Valid(null);
            }
        }
        if (tuple2 != null && (object = tuple2._2()) == null) {
            return this.error(new StringBuilder(30).append("Not expected null for schema: ").append(schema).toString());
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        return this.error(new StringBuilder(32).append("Not expected type: ").append(value.getClass().getName()).append(" for schema: ").append(schema).toString());
    }

    public GenericData.Record encodeRecordOrError(Map<String, ?> fields, Schema schema) {
        return this.encodeRecordOrError((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(fields).asJava(), schema);
    }

    public GenericData.Record encodeRecordOrError(java.util.Map<String, ?> fields, Schema schema) {
        return (GenericData.Record)this.encodeRecord(fields, schema).fold((Function1 & Serializable & scala.Serializable)l -> {
            throw new AvroRuntimeException(l.toList().mkString(","));
        }, (Function1 & Serializable & scala.Serializable)x -> (GenericData.Record)Predef$.MODULE$.identity(x));
    }

    public Validated<NonEmptyList<String>, GenericData.Record> encodeRecord(Map<String, ?> fields, Schema schema) {
        return this.encodeRecord((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(fields).asJava(), schema);
    }

    public Validated<NonEmptyList<String>, GenericData.Record> encodeRecord(java.util.Map<String, ?> fields, Schema schema) {
        return ((Validated)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fields).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Validated.Invalid<NonEmptyList<String>> invalid;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String fieldName = (String)tuple2._1();
                Object value = tuple2._2();
                Schema.Field field = schema.getField(fieldName);
                if (field == null) {
                    invalid = MODULE$.error(new StringBuilder(43).append("Not expected field with name: ").append(fieldName).append(" for schema: ").append(schema).toString());
                } else {
                    Schema fieldSchema = field.schema();
                    invalid = MODULE$.encode(value, fieldSchema).map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)fieldName), x$2));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Validated.Invalid<NonEmptyList<String>> invalid2 = invalid;
            return invalid2;
        }, Iterable$.MODULE$.canBuildFrom())).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).map((Function1 & Serializable & scala.Serializable)values -> {
            ObjectRef builder = ObjectRef.create((Object)new GenericRecordBuilder(schema));
            values.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                Object v = tuple2._2();
                GenericRecordBuilder genericRecordBuilder = ((GenericRecordBuilder)builder$1.elem).set(k, v);
                return genericRecordBuilder;
            });
            return ((GenericRecordBuilder)builder.elem).build();
        });
    }

    private Validated<NonEmptyList<String>, java.util.Map<CharSequence, Object>> encodeMap(Map<?, ?> map, Schema schema) {
        return ((Validated)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)map.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                if (k instanceof String) {
                    String string = (String)k;
                    return MODULE$.encode(v, schema.getValueType()).map((Function1 & Serializable & scala.Serializable)x$3 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.encodeString(string)), x$3));
                }
            }
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                if (k instanceof CharSequence) {
                    Object object = k;
                    return MODULE$.encode(v, schema.getValueType()).map((Function1 & Serializable & scala.Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(object), x$4));
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Object k = tuple2._1();
            return MODULE$.error(new StringBuilder(48).append("Not expected type: ").append(k.getClass().getName()).append(" as a key of map for schema: ").append(schema).toString());
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).map((Function1 & Serializable & scala.Serializable)x$5 -> (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)x$5.toMap(Predef$.MODULE$.$conforms())).asJava());
    }

    private Validated<NonEmptyList<String>, Object> encodeCollection(Traversable<?> collection, Schema schema) {
        return ((Validated)implicits$.MODULE$.toTraverseOps((Object)((TraversableOnce)collection.map((Function1 & Serializable & scala.Serializable)el -> MODULE$.encode(el, schema.getElementType()), Traversable$.MODULE$.canBuildFrom())).toList(), implicits$.MODULE$.catsStdInstancesForList()).sequence(Predef$.MODULE$.$conforms(), (Applicative)Validated$.MODULE$.catsDataApplicativeErrorForValidated(NonEmptyList$.MODULE$.catsDataSemigroupForNonEmptyList()))).map((Function1 & Serializable & scala.Serializable)x$6 -> (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(x$6.toBuffer()).asJava());
    }

    private Validated<NonEmptyList<String>, GenericData.Fixed> encodeFixed(byte[] bytes, Schema schema) {
        Validated.Invalid<NonEmptyList<String>> invalid;
        if (bytes.length != schema.getFixedSize()) {
            invalid = this.error(new StringBuilder(41).append("Fixed size not matches: ").append(bytes.length).append(" != ").append(schema.getFixedSize()).append(" for schema: ").append(schema).toString());
        } else {
            GenericData.Fixed fixed = new GenericData.Fixed(schema);
            fixed.bytes(bytes);
            invalid = new Validated.Invalid<NonEmptyList<String>>((Object)fixed);
        }
        return invalid;
    }

    private Validated.Invalid<NonEmptyList<String>> error(String str) {
        return new Validated.Invalid((Object)NonEmptyList$.MODULE$.of((Object)str, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])));
    }

    private Utf8 encodeString(String str) {
        return new Utf8(str);
    }

    private BestEffortAvroEncoder$() {
        MODULE$ = this;
    }
}

