/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.formatter;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]a!\u0002\b\u0010\u0001=Y\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u0011I\u0002!\u0011!Q\u0001\nMB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005g!)a\t\u0001C\u0001\u000f\"9a\n\u0001b\u0001\n\u0013y\u0005BB,\u0001A\u0003%\u0001\u000bC\u0004Y\u0001\t\u0007I\u0011B(\t\re\u0003\u0001\u0015!\u0003Q\u0011\u001dQ\u0006A1A\u0005\nmCaA\u001a\u0001!\u0002\u0013a\u0006\"B4\u0001\t\u0003A\u0007bBA\u0003\u0001\u0011%\u0011q\u0001\u0002\u0012\u0003Z\u0014x.T3tg\u0006<WMU3bI\u0016\u0014(B\u0001\t\u0012\u0003%1wN]7biR,'O\u0003\u0002\u0013'\u0005!\u0011M\u001e:p\u0015\t!R#\u0001\u0004f]\u001eLg.\u001a\u0006\u0003-]\t1B\\;tg.t\u0017mY6fe*\u0011\u0001$G\u0001\u0005i>,8NC\u0001\u001b\u0003\t\u0001Hn\u0005\u0002\u00019A\u0011QDJ\u0007\u0002=)\u0011q\u0004I\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148O\u0003\u0002\"E\u0005)1.\u00194lC*\u00111\u0005J\u0001\nG>tg\r\\;f]RT\u0011!J\u0001\u0003S>L!a\n\u0010\u00037\u0005\u00137\u000f\u001e:bGR\\\u0015MZ6b\u0003Z\u0014xnU3sS\u0006d\u0017N_3s\u0003Q\u00198\r[3nCJ+w-[:uef\u001cE.[3oi\u000e\u0001\u0001CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0019\u0019G.[3oi*\u0011q\u0006I\u0001\u000fg\u000eDW-\\1sK\u001eL7\u000f\u001e:z\u0013\t\tDF\u0001\u000bTG\",W.\u0019*fO&\u001cHO]=DY&,g\u000e^\u0001\u0006i>\u0004\u0018n\u0019\t\u0003iur!!N\u001e\u0011\u0005YJT\"A\u001c\u000b\u0005aJ\u0013A\u0002\u001fs_>$hHC\u0001;\u0003\u0015\u00198-\u00197b\u0013\ta\u0014(\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f:\u0003!\u0001\u0018M]:f\u0017\u0016L\bC\u0001\"D\u001b\u0005I\u0014B\u0001#:\u0005\u001d\u0011un\u001c7fC:\fAb[3z'\u0016\u0004\u0018M]1u_J\fa\u0001P5oSRtD#\u0002%K\u00172k\u0005CA%\u0001\u001b\u0005y\u0001\"\u0002\u0015\u0006\u0001\u0004Q\u0003\"\u0002\u001a\u0006\u0001\u0004\u0019\u0004\"\u0002!\u0006\u0001\u0004\t\u0005\"B#\u0006\u0001\u0004\u0019\u0014AC6fsN+(M[3diV\t\u0001\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!A\u0010*\u0002\u0017-,\u0017pU;cU\u0016\u001cG\u000fI\u0001\rm\u0006dW/Z*vE*,7\r^\u0001\u000em\u0006dW/Z*vE*,7\r\u001e\u0011\u0002\u001d\u0011,7m\u001c3fe\u001a\u000b7\r^8ssV\tA\f\u0005\u0002^I6\taL\u0003\u0002&?*\u0011!\u0003\u0019\u0006\u0003C\n\fa!\u00199bG\",'\"A2\u0002\u0007=\u0014x-\u0003\u0002f=\nqA)Z2pI\u0016\u0014h)Y2u_JL\u0018a\u00043fG>$WM\u001d$bGR|'/\u001f\u0011\u0002\u0017I,\u0017\rZ'fgN\fw-\u001a\u000b\u0006SbT\u0018\u0011\u0001\t\u0005UB\u0014(/D\u0001l\u0015\taW.\u0001\u0005qe>$WoY3s\u0015\tqw.A\u0004dY&,g\u000e^:\u000b\u0005\u0005\u0002\u0017BA9l\u00059\u0001&o\u001c3vG\u0016\u0014(+Z2pe\u0012\u00042AQ:v\u0013\t!\u0018HA\u0003BeJ\f\u0017\u0010\u0005\u0002Cm&\u0011q/\u000f\u0002\u0005\u0005f$X\rC\u0003z\u0019\u0001\u00071'A\u0002tiJDQa\u001f\u0007A\u0002q\f\u0011b[3z'\u000eDW-\\1\u0011\u0005utX\"A0\n\u0005}|&AB*dQ\u0016l\u0017\r\u0003\u0004\u0002\u00041\u0001\r\u0001`\u0001\fm\u0006dW/Z*dQ\u0016l\u0017-\u0001\u0006kg>tGk\\!we>$b!!\u0003\u0002\u0010\u0005M\u0001c\u0001\"\u0002\f%\u0019\u0011QB\u001d\u0003\r\u0005s\u0017PU3g\u0011\u0019\t\t\"\u0004a\u0001g\u0005Q!n]8o'R\u0014\u0018N\\4\t\r\u0005UQ\u00021\u0001}\u0003\u0019\u00198\r[3nC\u0002")
public class AvroMessageReader
extends AbstractKafkaAvroSerializer {
    private final String topic;
    private final boolean parseKey;
    private final String keySeparator;
    private final String keySubject;
    private final String valueSubject;
    private final DecoderFactory decoderFactory;

    private String keySubject() {
        return this.keySubject;
    }

    private String valueSubject() {
        return this.valueSubject;
    }

    private DecoderFactory decoderFactory() {
        return this.decoderFactory;
    }

    public ProducerRecord<byte[], byte[]> readMessage(String str, Schema keySchema, Schema valueSchema) {
        ProducerRecord producerRecord;
        try {
            if (!this.parseKey) {
                Object value = this.jsonToAvro(str, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedValue);
            } else {
                int keyIndex = str.indexOf(this.keySeparator);
                if (keyIndex < 0) {
                    throw new SerializationException(new StringBuilder(21).append("No key found in line ").append(str).toString());
                }
                String keyString = str.substring(0, keyIndex);
                String valueString = keyIndex + 1 > str.length() ? "" : str.substring(keyIndex + 1);
                Object key = this.jsonToAvro(keyString, keySchema);
                byte[] serializedKey = this.serializeImpl(this.keySubject(), key);
                Object value = this.jsonToAvro(valueString, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedKey, (Object)serializedValue);
            }
        }
        catch (IOException ex) {
            throw new SerializationException("Error reading from input", (Throwable)ex);
        }
        return producerRecord;
    }

    private Object jsonToAvro(String jsonString, Schema schema) {
        Object object;
        try {
            GenericDatumReader reader = new GenericDatumReader(schema);
            Object obj = reader.read(null, (Decoder)this.decoderFactory().jsonDecoder(schema, jsonString));
            Schema.Type type = schema.getType();
            Schema.Type type2 = Schema.Type.STRING;
            object = !(type != null ? !type.equals(type2) : type2 != null) ? ((Utf8)obj).toString() : obj;
        }
        catch (IOException ex) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)ex);
        }
        catch (AvroRuntimeException ex) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)ex);
        }
        return object;
    }

    public AvroMessageReader(SchemaRegistryClient schemaRegistryClient, String topic, boolean parseKey, String keySeparator) {
        this.topic = topic;
        this.parseKey = parseKey;
        this.keySeparator = keySeparator;
        this.schemaRegistry = schemaRegistryClient;
        this.keySubject = new StringBuilder(4).append(topic).append("-key").toString();
        this.valueSubject = new StringBuilder(6).append(topic).append("-value").toString();
        this.decoderFactory = DecoderFactory.get();
    }
}

