/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.typed;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import pl.touk.nussknacker.engine.api.typed.typing;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;

public final class AvroSchemaTypeDefinitionExtractor$ {
    public static AvroSchemaTypeDefinitionExtractor$ MODULE$;

    static {
        new AvroSchemaTypeDefinitionExtractor$();
    }

    public typing.TypingResult typeDefinition(String schemaString) {
        return this.typeDefinition(new Schema.Parser().parse(schemaString));
    }

    public typing.TypingResult typeDefinition(Schema schema2) {
        typing.TypingResult typingResult;
        Schema.Type type = schema2.getType();
        if (Schema.Type.RECORD.equals(type)) {
            typingResult = new typing.TypedObjectTypingResult(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)field -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)MODULE$.typeDefinition(field.schema())), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()), typing.Typed$.MODULE$.typedClass(ClassTag$.MODULE$.apply(GenericRecord.class)));
        } else if (Schema.Type.ENUM.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.apply(GenericData.EnumSymbol.class));
        } else if (Schema.Type.ARRAY.equals(type)) {
            typingResult = typing.Typed$.MODULE$.genericTypeClass((List)new .colon.colon((Object)this.typeDefinition(schema2.getElementType()), (List)Nil$.MODULE$), ClassTag$.MODULE$.apply(java.util.List.class));
        } else if (Schema.Type.MAP.equals(type)) {
            typingResult = typing.Typed$.MODULE$.genericTypeClass((List)new .colon.colon((Object)typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.apply(CharSequence.class)), (List)new .colon.colon((Object)this.typeDefinition(schema2.getValueType()), (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(Map.class));
        } else if (Schema.Type.UNION.equals(type)) {
            Set childTypeDefinitons = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema2.getTypes()).asScala()).map((Function1 & Serializable & scala.Serializable)schema -> MODULE$.typeDefinition((Schema)schema), Buffer$.MODULE$.canBuildFrom())).toSet();
            typingResult = typing.Typed$.MODULE$.apply(childTypeDefinitons);
        } else if (Schema.Type.FIXED.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.apply(GenericData.Fixed.class));
        } else if (Schema.Type.STRING.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.apply(CharSequence.class));
        } else if (Schema.Type.BYTES.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.apply(ByteBuffer.class));
        } else if (Schema.Type.INT.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.apply(Integer.class));
        } else if (Schema.Type.LONG.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.Long());
        } else if (Schema.Type.FLOAT.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.Float());
        } else if (Schema.Type.DOUBLE.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.Double());
        } else if (Schema.Type.BOOLEAN.equals(type)) {
            typingResult = typing.Typed$.MODULE$.apply(ClassTag$.MODULE$.Boolean());
        } else if (Schema.Type.NULL.equals(type)) {
            typingResult = typing.Typed$.MODULE$.empty();
        } else {
            throw new MatchError((Object)type);
        }
        return typingResult;
    }

    private AvroSchemaTypeDefinitionExtractor$() {
        MODULE$ = this;
    }
}

