/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.formatter;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.avro.Schema;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.formatter.AvroMessageFormatter;
import pl.touk.nussknacker.engine.avro.formatter.AvroMessageReader;
import pl.touk.nussknacker.engine.avro.formatter.AvroToJsonFormatter$;
import pl.touk.nussknacker.engine.kafka.RecordFormatter;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001\u0002\n\u0014\u0001\u0001B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\f\u0005\t)\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015)\u0007\u0001\"\u0003g\u0011\u0015)\b\u0001\"\u0003w\u0011\u0015Y\b\u0001\"\u0003}\u0011\u001d\tY\u0001\u0001C!\u0003\u001bAq!a\b\u0001\t\u0013\t\tcB\u0004\u0002XMA\t!!\u0017\u0007\rI\u0019\u0002\u0012AA.\u0011\u00199U\u0002\"\u0001\u0002^!I\u0011qL\u0007C\u0002\u0013%\u0011\u0011\r\u0005\t\u0003Gj\u0001\u0015!\u0003\u00024!9\u0011QM\u0007\u0005\u0002\u0005\u001d$aE!we>$vNS:p]\u001a{'/\\1ui\u0016\u0014(B\u0001\u000b\u0016\u0003%1wN]7biR,'O\u0003\u0002\u0017/\u0005!\u0011M\u001e:p\u0015\tA\u0012$\u0001\u0004f]\u001eLg.\u001a\u0006\u00035m\t1B\\;tg.t\u0017mY6fe*\u0011A$H\u0001\u0005i>,8NC\u0001\u001f\u0003\t\u0001Hn\u0001\u0001\u0014\u0007\u0001\ts\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VM\u001a\t\u0003Q-j\u0011!\u000b\u0006\u0003U]\tQa[1gW\u0006L!\u0001L\u0015\u0003\u001fI+7m\u001c:e\r>\u0014X.\u0019;uKJ\fAc]2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$\bCA\u0018:\u001b\u0005\u0001$BA\u00193\u0003\u0019\u0019G.[3oi*\u00111\u0007N\u0001\u000fg\u000eDW-\\1sK\u001eL7\u000f\u001e:z\u0015\tQSG\u0003\u00027o\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0002q\u0005\u0011\u0011n\\\u0005\u0003uA\u0012AcU2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$\bC\u0001\u001f>\u001b\u0005\u0019\u0012B\u0001 \u0014\u0005Q\teO]8NKN\u001c\u0018mZ3G_Jl\u0017\r\u001e;fe\u00061!/Z1eKJ\u0004\"\u0001P!\n\u0005\t\u001b\"!E!we>lUm]:bO\u0016\u0014V-\u00193fe\u0006Iam\u001c:nCR\\U-\u001f\t\u0003E\u0015K!AR\u0012\u0003\u000f\t{w\u000e\\3b]\u00061A(\u001b8jiz\"R!\u0013&L\u00196\u0003\"\u0001\u0010\u0001\t\u000b5*\u0001\u0019\u0001\u0018\t\u000bQ)\u0001\u0019A\u001e\t\u000b}*\u0001\u0019\u0001!\t\u000b\r+\u0001\u0019\u0001#\u0002\u0019\u0019|'/\\1u%\u0016\u001cwN\u001d3\u0015\u0005A3\u0006c\u0001\u0012R'&\u0011!k\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003EQK!!V\u0012\u0003\t\tKH/\u001a\u0005\u0006/\u001a\u0001\r\u0001W\u0001\u0007e\u0016\u001cwN\u001d3\u0011\te\u001b\u0007\u000bU\u0007\u00025*\u00111\fX\u0001\tG>t7/^7fe*\u0011QLX\u0001\bG2LWM\u001c;t\u0015\tQsL\u0003\u0002aC\u00061\u0011\r]1dQ\u0016T\u0011AY\u0001\u0004_J<\u0017B\u00013[\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\fq\u0001\u001d:j]RLE\rF\u0002hU2\u0004\"A\t5\n\u0005%\u001c#\u0001B+oSRDQa[\u0004A\u0002A\u000bQAY=uKNDQ!\\\u0004A\u00029\f1\u0002\u001d:j]R\u001cFO]3b[B\u0011qn]\u0007\u0002a*\u0011\u0001(\u001d\u0006\u0002e\u0006!!.\u0019<b\u0013\t!\bOA\u0006Qe&tGo\u0015;sK\u0006l\u0017A\u0002:fC\u0012LE\r\u0006\u0002xuB\u0011!\u0005_\u0005\u0003s\u000e\u00121!\u00138u\u0011\u0015Y\u0007\u00021\u0001Q\u000359W\r\u001e\"zi\u0016\u0014UO\u001a4feR\u0019Q0a\u0002\u0011\u0007y\f\u0019!D\u0001\u0000\u0015\r\t\t!]\u0001\u0004]&|\u0017bAA\u0003\u007f\nQ!)\u001f;f\u0005V4g-\u001a:\t\r\u0005%\u0011\u00021\u0001Q\u0003\u001d\u0001\u0018-\u001f7pC\u0012\f1\u0002]1sg\u0016\u0014VmY8sIR!\u0011qBA\u000e!\u0019\t\t\"a\u0006Q!6\u0011\u00111\u0003\u0006\u0004\u0003+a\u0016\u0001\u00039s_\u0012,8-\u001a:\n\t\u0005e\u00111\u0003\u0002\u000f!J|G-^2feJ+7m\u001c:e\u0011\u0019\tiB\u0003a\u0001!\u0006Iam\u001c:nCR$X\rZ\u0001\re\u0016\fGmU2iK6\f\u0017\n\u001a\u000b\u0005\u0003G\ty\u0004E\u0004#\u0003K\tI#a\r\n\u0007\u0005\u001d2E\u0001\u0004UkBdWM\r\t\u0005\u0003W\ty#\u0004\u0002\u0002.)\u0011acX\u0005\u0005\u0003c\tiC\u0001\u0004TG\",W.\u0019\t\u0005\u0003k\tY$\u0004\u0002\u00028)\u0019\u0011\u0011H9\u0002\t1\fgnZ\u0005\u0005\u0003{\t9D\u0001\u0004TiJLgn\u001a\u0005\b\u0003\u0003Z\u0001\u0019AA\"\u0003\r\u0019HO\u001d\t\u0005\u0003\u000b\n\u0019F\u0004\u0003\u0002H\u0005=\u0003cAA%G5\u0011\u00111\n\u0006\u0004\u0003\u001bz\u0012A\u0002\u001fs_>$h(C\u0002\u0002R\r\na\u0001\u0015:fI\u00164\u0017\u0002BA\u001f\u0003+R1!!\u0015$\u0003M\teO]8U_*\u001bxN\u001c$pe6\fG\u000f^3s!\taTb\u0005\u0002\u000eCQ\u0011\u0011\u0011L\u0001\n'\u0016\u0004\u0018M]1u_J,\"!a\r\u0002\u0015M+\u0007/\u0019:bi>\u0014\b%A\u0003baBd\u0017\u0010F\u0004J\u0003S\nY'a\u001c\t\u000b5\n\u0002\u0019\u0001\u0018\t\u000f\u00055\u0014\u00031\u0001\u0002D\u0005)Ao\u001c9jG\")1)\u0005a\u0001\t\u0002")
public class AvroToJsonFormatter
implements RecordFormatter {
    private final SchemaRegistryClient schemaRegistryClient;
    private final AvroMessageFormatter formatter;
    private final AvroMessageReader reader;
    private final boolean formatKey;

    public static AvroToJsonFormatter apply(SchemaRegistryClient schemaRegistryClient, String string, boolean bl) {
        return AvroToJsonFormatter$.MODULE$.apply(schemaRegistryClient, string, bl);
    }

    public byte[] formatRecord(ConsumerRecord<byte[], byte[]> record) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream((OutputStream)bos, true, StandardCharsets.UTF_8.toString());
        if (this.formatKey) {
            this.printId((byte[])record.key(), printStream);
        }
        this.printId((byte[])record.value(), printStream);
        if (this.formatKey) {
            this.formatter.writeTo((byte[])record.key(), true, printStream);
            printStream.print(AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator());
        }
        this.formatter.writeTo((byte[])record.value(), false, printStream);
        return bos.toByteArray();
    }

    private void printId(byte[] bytes, PrintStream printStream) {
        int id = this.readId(bytes);
        printStream.print(id);
        printStream.print(AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator());
    }

    private int readId(byte[] bytes) {
        ByteBuffer buffer = this.getByteBuffer(bytes);
        return buffer.getInt();
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer getByteBuffer(byte[] payload) {
        void var2_2;
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        if (buffer.get() != 0) {
            throw new SerializationException("Unknown magic byte!");
        }
        return var2_2;
    }

    public ProducerRecord<byte[], byte[]> parseRecord(byte[] formatted) {
        Tuple3 tuple3;
        Tuple3 tuple32;
        String str = new String(formatted, StandardCharsets.UTF_8);
        if (this.formatKey) {
            Tuple2<Schema, String> tuple2 = this.readSchemaId(str);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Schema ks = (Schema)tuple2._1();
            String valueSchemaIdAndRest = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)ks, (Object)valueSchemaIdAndRest);
            Tuple2 tuple23 = tuple22;
            Schema ks2 = (Schema)tuple23._1();
            String valueSchemaIdAndRest2 = (String)tuple23._2();
            Tuple2<Schema, String> tuple24 = this.readSchemaId(valueSchemaIdAndRest2);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            Schema vs = (Schema)tuple24._1();
            String rs = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)vs, (Object)rs);
            Tuple2 tuple26 = tuple25;
            Schema vs2 = (Schema)tuple26._1();
            String rs2 = (String)tuple26._2();
            tuple32 = new Tuple3((Object)ks2, (Object)vs2, (Object)rs2);
        } else {
            Tuple2<Schema, String> tuple2 = this.readSchemaId(str);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Schema vs = (Schema)tuple2._1();
            String rs = (String)tuple2._2();
            Tuple2 tuple27 = new Tuple2((Object)vs, (Object)rs);
            Tuple2 tuple28 = tuple27;
            Schema vs3 = (Schema)tuple28._1();
            String rs3 = (String)tuple28._2();
            tuple32 = tuple3 = new Tuple3(null, (Object)vs3, (Object)rs3);
        }
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Schema keySchema = (Schema)tuple3._1();
        Schema valueSchema = (Schema)tuple3._2();
        String remainingString = (String)tuple3._3();
        Tuple3 tuple33 = new Tuple3((Object)keySchema, (Object)valueSchema, (Object)remainingString);
        Tuple3 tuple34 = tuple33;
        Schema keySchema2 = (Schema)tuple34._1();
        Schema valueSchema2 = (Schema)tuple34._2();
        String remainingString2 = (String)tuple34._3();
        return this.reader.readMessage(remainingString2, keySchema2, valueSchema2);
    }

    private Tuple2<Schema, String> readSchemaId(String str) {
        int separatorIndx = str.indexOf(AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator());
        if (separatorIndx < 1) {
            throw new IllegalStateException(new StringBuilder(42).append("Cannot find schema id separtor: ").append(AvroToJsonFormatter$.MODULE$.pl$touk$nussknacker$engine$avro$formatter$AvroToJsonFormatter$$Separator()).append(" in text: ").append(str).toString());
        }
        int id = Integer.parseInt(str.substring(0, separatorIndx));
        String remaining = separatorIndx + 1 > str.length() ? "" : str.substring(separatorIndx + 1);
        return new Tuple2((Object)this.schemaRegistryClient.getById(id), (Object)remaining);
    }

    public AvroToJsonFormatter(SchemaRegistryClient schemaRegistryClient, AvroMessageFormatter formatter, AvroMessageReader reader, boolean formatKey) {
        this.schemaRegistryClient = schemaRegistryClient;
        this.formatter = formatter;
        this.reader = reader;
        this.formatKey = formatKey;
    }
}

