/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.formatter;

import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.serializers.AbstractKafkaAvroSerializer;
import java.io.IOException;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.ConfluentUtils$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055a!\u0002\b\u0010\u0001Ey\u0002\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011Q\u0002!\u0011!Q\u0001\nUB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005k!)\u0001\n\u0001C\u0001\u0013\"9\u0001\u000b\u0001b\u0001\n\u0013\t\u0006B\u0002*\u0001A\u0003%Q\u0007C\u0004T\u0001\t\u0007I\u0011B)\t\rQ\u0003\u0001\u0015!\u00036\u0011\u001d)\u0006A1A\u0005\nYCa!\u0019\u0001!\u0002\u00139\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B?\u0001\t\u0013q(AG\"p]\u001adW/\u001a8u\u0003Z\u0014x.T3tg\u0006<WMU3bI\u0016\u0014(B\u0001\t\u0012\u0003%1wN]7biR,'O\u0003\u0002\u0013'\u0005I1m\u001c8gYV,g\u000e\u001e\u0006\u0003)U\tab]2iK6\f'/Z4jgR\u0014\u0018P\u0003\u0002\u0017/\u0005!\u0011M\u001e:p\u0015\tA\u0012$\u0001\u0004f]\u001eLg.\u001a\u0006\u00035m\t1B\\;tg.t\u0017mY6fe*\u0011A$H\u0001\u0005i>,8NC\u0001\u001f\u0003\t\u0001Hn\u0005\u0002\u0001AA\u0011\u0011%K\u0007\u0002E)\u00111\u0005J\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148O\u0003\u0002&M\u0005)1.\u00194lC*\u0011!c\n\u0006\u0002Q\u0005\u0011\u0011n\\\u0005\u0003U\t\u00121$\u00112tiJ\f7\r^&bM.\f\u0017I\u001e:p'\u0016\u0014\u0018.\u00197ju\u0016\u0014\u0018\u0001F:dQ\u0016l\u0017MU3hSN$(/_\"mS\u0016tGo\u0001\u0001\u0011\u00059\u0012T\"A\u0018\u000b\u0005A\n\u0014AB2mS\u0016tGO\u0003\u0002\u0015I%\u00111g\f\u0002\u0015'\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u00072LWM\u001c;\u0002\u000bQ|\u0007/[2\u0011\u0005YzdBA\u001c>!\tA4(D\u0001:\u0015\tQD&\u0001\u0004=e>|GO\u0010\u0006\u0002y\u0005)1oY1mC&\u0011ahO\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?w\u0005A\u0001/\u0019:tK.+\u0017\u0010\u0005\u0002E\u000b6\t1(\u0003\u0002Gw\t9!i\\8mK\u0006t\u0017\u0001D6fsN+\u0007/\u0019:bi>\u0014\u0018A\u0002\u001fj]&$h\bF\u0003K\u00196su\n\u0005\u0002L\u00015\tq\u0002C\u0003,\u000b\u0001\u0007Q\u0006C\u00035\u000b\u0001\u0007Q\u0007C\u0003C\u000b\u0001\u00071\tC\u0003H\u000b\u0001\u0007Q'\u0001\u0006lKf\u001cVO\u00196fGR,\u0012!N\u0001\fW\u0016L8+\u001e2kK\u000e$\b%\u0001\u0007wC2,XmU;cU\u0016\u001cG/A\u0007wC2,XmU;cU\u0016\u001cG\u000fI\u0001\u000fI\u0016\u001cw\u000eZ3s\r\u0006\u001cGo\u001c:z+\u00059\u0006C\u0001-`\u001b\u0005I&B\u0001\u0015[\u0015\t12L\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<\u0017B\u00011Z\u00059!UmY8eKJ4\u0015m\u0019;pef\fq\u0002Z3d_\u0012,'OR1di>\u0014\u0018\u0010I\u0001\fe\u0016\fG-T3tg\u0006<W\r\u0006\u0003egV\\\b\u0003B3l[6l\u0011A\u001a\u0006\u0003O\"\f\u0001\u0002\u001d:pIV\u001cWM\u001d\u0006\u0003S*\fqa\u00197jK:$8O\u0003\u0002&7&\u0011AN\u001a\u0002\u000f!J|G-^2feJ+7m\u001c:e!\r!e\u000e]\u0005\u0003_n\u0012Q!\u0011:sCf\u0004\"\u0001R9\n\u0005I\\$\u0001\u0002\"zi\u0016DQ\u0001\u001e\u0007A\u0002U\n1a\u001d;s\u0011\u00151H\u00021\u0001x\u0003%YW-_*dQ\u0016l\u0017\r\u0005\u0002ys6\t!,\u0003\u0002{5\n11k\u00195f[\u0006DQ\u0001 \u0007A\u0002]\f1B^1mk\u0016\u001c6\r[3nC\u0006Q!n]8o)>\feO]8\u0015\u000b}\f)!!\u0003\u0011\u0007\u0011\u000b\t!C\u0002\u0002\u0004m\u0012a!\u00118z%\u00164\u0007BBA\u0004\u001b\u0001\u0007Q'\u0001\u0006kg>t7\u000b\u001e:j]\u001eDa!a\u0003\u000e\u0001\u00049\u0018AB:dQ\u0016l\u0017\r")
public class ConfluentAvroMessageReader
extends AbstractKafkaAvroSerializer {
    private final String topic;
    private final boolean parseKey;
    private final String keySeparator;
    private final String keySubject;
    private final String valueSubject;
    private final DecoderFactory decoderFactory;

    private String keySubject() {
        return this.keySubject;
    }

    private String valueSubject() {
        return this.valueSubject;
    }

    private DecoderFactory decoderFactory() {
        return this.decoderFactory;
    }

    public ProducerRecord<byte[], byte[]> readMessage(String str, Schema keySchema, Schema valueSchema) {
        ProducerRecord producerRecord;
        try {
            if (!this.parseKey) {
                Object value = this.jsonToAvro(str, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedValue);
            } else {
                int keyIndex = str.indexOf(this.keySeparator);
                if (keyIndex < 0) {
                    throw new SerializationException(new StringBuilder(21).append("No key found in line ").append(str).toString());
                }
                String keyString = str.substring(0, keyIndex);
                String valueString = keyIndex + 1 > str.length() ? "" : str.substring(keyIndex + 1);
                Object key = this.jsonToAvro(keyString, keySchema);
                byte[] serializedKey = this.serializeImpl(this.keySubject(), key);
                Object value = this.jsonToAvro(valueString, valueSchema);
                byte[] serializedValue = this.serializeImpl(this.valueSubject(), value);
                producerRecord = new ProducerRecord(this.topic, (Object)serializedKey, (Object)serializedValue);
            }
        }
        catch (IOException ex) {
            throw new SerializationException("Error reading from input", (Throwable)ex);
        }
        return producerRecord;
    }

    private Object jsonToAvro(String jsonString, Schema schema) {
        Object object;
        try {
            GenericDatumReader reader = new GenericDatumReader(schema);
            Object obj = reader.read(null, (Decoder)this.decoderFactory().jsonDecoder(schema, jsonString));
            Schema.Type type = schema.getType();
            Schema.Type type2 = Schema.Type.STRING;
            object = !(type != null ? !type.equals(type2) : type2 != null) ? ((Utf8)obj).toString() : obj;
        }
        catch (IOException ex) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)ex);
        }
        catch (AvroRuntimeException ex) {
            throw new SerializationException(String.format("Error deserializing json %s to Avro of schema %s", jsonString, schema), (Throwable)ex);
        }
        return object;
    }

    public ConfluentAvroMessageReader(SchemaRegistryClient schemaRegistryClient, String topic, boolean parseKey, String keySeparator) {
        this.topic = topic;
        this.parseKey = parseKey;
        this.keySeparator = keySeparator;
        this.schemaRegistry = schemaRegistryClient;
        this.keySubject = ConfluentUtils$.MODULE$.keySubject(topic);
        this.valueSubject = ConfluentUtils$.MODULE$.valueSubject(topic);
        this.decoderFactory = DecoderFactory.get();
    }
}

