/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.client;

import cats.data.Validated;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import java.io.Serializable;
import org.apache.avro.Schema;
import pl.touk.nussknacker.engine.avro.AvroUtils$;
import pl.touk.nussknacker.engine.avro.schemaregistry.SchemaRegistryClient;
import pl.touk.nussknacker.engine.avro.schemaregistry.SchemaRegistryError;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.ConfluentUtils$;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.client.ConfluentSchemaRegistryClient;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.client.SchemaRegistryCaches;
import scala.Function0;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\u0006\r\u0001uA\u0001\"\u0004\u0001\u0003\u0006\u0004%\tA\r\u0005\t}\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003D\u0001\u0011\u0005A\tC\u0003I\u0001\u0011\u0005\u0013\nC\u0003r\u0001\u0011\u0005#\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005E\u0002\u0001\"\u0003\u00024\t\u00193)Y2iK\u0012\u001cuN\u001c4mk\u0016tGoU2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$(BA\u0007\u000f\u0003\u0019\u0019G.[3oi*\u0011q\u0002E\u0001\nG>tg\r\\;f]RT!!\u0005\n\u0002\u001dM\u001c\u0007.Z7be\u0016<\u0017n\u001d;ss*\u00111\u0003F\u0001\u0005CZ\u0014xN\u0003\u0002\u0016-\u00051QM\\4j]\u0016T!a\u0006\r\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u00033i\tA\u0001^8vW*\t1$\u0001\u0002qY\u000e\u00011\u0003\u0002\u0001\u001fI!\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005a\u0011BA\u0014\r\u0005u\u0019uN\u001c4mk\u0016tGoU2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$\bCA\u00151\u001b\u0005Q#BA\u0016-\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tic&\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0013aA2p[&\u0011\u0011G\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-F\u00014!\t!D(D\u00016\u0015\tiaG\u0003\u0002\u0012o)\u0011\u0001(O\u0001\u0006W\u000647.\u0019\u0006\u0003\u001fiR\u0011aO\u0001\u0003S>L!!P\u001b\u0003)M\u001b\u0007.Z7b%\u0016<\u0017n\u001d;ss\u000ec\u0017.\u001a8u\u0003\u001d\u0019G.[3oi\u0002\naaY1dQ\u0016\u001c\bCA\u0013B\u0013\t\u0011EB\u0001\u000bTG\",W.\u0019*fO&\u001cHO]=DC\u000eDWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00153u\t\u0005\u0002&\u0001!)Q\u0002\u0002a\u0001g!)q\b\u0002a\u0001\u0001\u0006!r-\u001a;MCR,7\u000f\u001e$sKND7k\u00195f[\u0006$2AS0m!\u0011Y\u0005K\u0015,\u000e\u00031S!!\u0014(\u0002\t\u0011\fG/\u0019\u0006\u0002\u001f\u0006!1-\u0019;t\u0013\t\tFJA\u0005WC2LG-\u0019;fIB\u00111\u000bV\u0007\u0002!%\u0011Q\u000b\u0005\u0002\u0014'\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u000bJ\u0014xN\u001d\t\u0003/vk\u0011\u0001\u0017\u0006\u0003'eS!AW.\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0016aA8sO&\u0011a\f\u0017\u0002\u0007'\u000eDW-\\1\t\u000b\u0001,\u0001\u0019A1\u0002\u000bQ|\u0007/[2\u0011\u0005\tLgBA2h!\t!\u0007%D\u0001f\u0015\t1G$\u0001\u0004=e>|GOP\u0005\u0003Q\u0002\na\u0001\u0015:fI\u00164\u0017B\u00016l\u0005\u0019\u0019FO]5oO*\u0011\u0001\u000e\t\u0005\u0006[\u0016\u0001\rA\\\u0001\u0006SN\\U-\u001f\t\u0003?=L!\u0001\u001d\u0011\u0003\u000f\t{w\u000e\\3b]\u0006yq-\u001a;MCR,7\u000f^*dQ\u0016l\u0017\rF\u0002KgRDQ\u0001\u0019\u0004A\u0002\u0005DQ!\u001c\u0004A\u00029\facZ3u\u0005f\u001cVO\u00196fGR\fe\u000e\u001a,feNLwN\u001c\u000b\u0005\u0015^DX\u0010C\u0003a\u000f\u0001\u0007\u0011\rC\u0003z\u000f\u0001\u0007!0A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005}Y\u0018B\u0001?!\u0005\rIe\u000e\u001e\u0005\u0006[\u001e\u0001\rA\\\u0001\rO\u0016$\u0018\t\u001c7U_BL7m]\u000b\u0003\u0003\u0003\u0001Ra\u0013)S\u0003\u0007\u0001R!!\u0002\u0002\u0010\u0005tA!a\u0002\u0002\f9\u0019A-!\u0003\n\u0003\u0005J1!!\u0004!\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0005\u0002\u0014\t!A*[:u\u0015\r\ti\u0001I\u0001\u000fO\u0016$\u0018\t\u001c7WKJ\u001c\u0018n\u001c8t)\u0019\tI\"!\f\u00020A)1\n\u0015*\u0002\u001cA1\u0011QAA\b\u0003;\u0001B!a\b\u0002*5\u0011\u0011\u0011\u0005\u0006\u0005\u0003G\t)#\u0001\u0003mC:<'BAA\u0014\u0003\u0011Q\u0017M^1\n\t\u0005-\u0012\u0011\u0005\u0002\b\u0013:$XmZ3s\u0011\u0015\u0001\u0017\u00021\u0001b\u0011\u0015i\u0017\u00021\u0001o\u0003Ma\u0017\r^3tiN\u001b\u0007.Z7b%\u0016\fX/Z:u)\r1\u0016Q\u0007\u0005\u0007\u0003oQ\u0001\u0019A1\u0002\u000fM,(M[3di\u0002")
public class CachedConfluentSchemaRegistryClient
implements ConfluentSchemaRegistryClient {
    private final io.confluent.kafka.schemaregistry.client.SchemaRegistryClient client;
    private final SchemaRegistryCaches caches;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <T> Validated<SchemaRegistryError, T> handleClientError(Function0<T> data) {
        return ConfluentSchemaRegistryClient.handleClientError$(this, data);
    }

    @Override
    public Validated<SchemaRegistryError, Schema> getSchema(String topic, Option<Object> version, boolean isKey) {
        return SchemaRegistryClient.getSchema$(this, topic, version, isKey);
    }

    @Override
    public Validated<SchemaRegistryError, Schema> getFreshSchema(String topic, Option<Object> version, boolean isKey) {
        return SchemaRegistryClient.getFreshSchema$(this, topic, version, isKey);
    }

    private Logger logger$lzycompute() {
        CachedConfluentSchemaRegistryClient cachedConfluentSchemaRegistryClient = this;
        synchronized (cachedConfluentSchemaRegistryClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public io.confluent.kafka.schemaregistry.client.SchemaRegistryClient client() {
        return this.client;
    }

    @Override
    public Validated<SchemaRegistryError, Schema> getLatestFreshSchema(String topic, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return this.latestSchemaRequest(subject);
        });
    }

    @Override
    public Validated<SchemaRegistryError, Schema> getLatestSchema(String topic, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return (Schema)$this.caches.latestSchemaCache().getOrCreate((Object)subject, (Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Cache latest schema for subject: {}.", new Object[]{subject});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.latestSchemaRequest(subject);
            });
        });
    }

    @Override
    public Validated<SchemaRegistryError, Schema> getBySubjectAndVersion(String topic, int version, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return (Schema)$this.caches.schemaCache().getOrCreate((Object)new StringBuilder(1).append(subject).append("-").append(version).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Cache schema for subject: {} and version: {}.", new Object[]{subject, BoxesRunTime.boxToInteger((int)version)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                SchemaMetadata schemaMetadata = this.client().getSchemaMetadata(subject, version);
                return AvroUtils$.MODULE$.parseSchema(schemaMetadata.getSchema());
            });
        });
    }

    @Override
    public Validated<SchemaRegistryError, List<String>> getAllTopics() {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> (List)$this.caches.topicsCache().getOrCreate((Function0 & Serializable & scala.Serializable)() -> (List)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.client().getAllSubjects()).asScala()).toList().collect(ConfluentUtils$.MODULE$.topicFromSubject(), List$.MODULE$.canBuildFrom())));
    }

    @Override
    public Validated<SchemaRegistryError, List<Integer>> getAllVersions(String topic, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return (List)$this.caches.versionsCache().getOrCreate((Object)subject, (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.client().getAllVersions(subject)).asScala()).toList());
        });
    }

    private Schema latestSchemaRequest(String subject) {
        SchemaMetadata schemaMetadata = this.client().getLatestSchemaMetadata(subject);
        return (Schema)this.caches.schemaCache().getOrCreate((Object)new StringBuilder(1).append(subject).append("-").append(schemaMetadata.getVersion()).toString(), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Cache parsed latest schema for subject: {}, version: {}.", new Object[]{subject, BoxesRunTime.boxToInteger((int)schemaMetadata.getVersion())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return AvroUtils$.MODULE$.parseSchema(schemaMetadata.getSchema());
        });
    }

    public CachedConfluentSchemaRegistryClient(io.confluent.kafka.schemaregistry.client.SchemaRegistryClient client, SchemaRegistryCaches caches) {
        this.client = client;
        this.caches = caches;
        SchemaRegistryClient.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        ConfluentSchemaRegistryClient.$init$(this);
    }
}

