/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.serialization;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.serializers.AbstractKafkaAvroDeserializer;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.kafka.common.errors.SerializationException;
import pl.touk.nussknacker.engine.avro.schema.DatumReaderWriterMixin;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.ConfluentUtils$;
import scala.Function1;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001I4Q!\u0002\u0004\u0002\u0002]AQ!\u000b\u0001\u0005\u0002)B\u0001\"\f\u0001\t\u0006\u0004%\tB\f\u0005\u0006s\u0001!\tF\u000f\u0005\u0006M\u0002!\tb\u001a\u0002'\u0003\n\u001cHO]1di\u000e{gN\u001a7vK:$8*\u00194lC\u00063(o\u001c#fg\u0016\u0014\u0018.\u00197ju\u0016\u0014(BA\u0004\t\u00035\u0019XM]5bY&T\u0018\r^5p]*\u0011\u0011BC\u0001\nG>tg\r\\;f]RT!a\u0003\u0007\u0002\u001dM\u001c\u0007.Z7be\u0016<\u0017n\u001d;ss*\u0011QBD\u0001\u0005CZ\u0014xN\u0003\u0002\u0010!\u00051QM\\4j]\u0016T!!\u0005\n\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u0003'Q\tA\u0001^8vW*\tQ#\u0001\u0002qY\u000e\u00011c\u0001\u0001\u0019GA\u0011\u0011$I\u0007\u00025)\u00111\u0004H\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u00148O\u0003\u0002\u001e=\u0005)1.\u00194lC*\u0011\u0011b\b\u0006\u0002A\u0005\u0011\u0011n\\\u0005\u0003Ei\u0011Q$\u00112tiJ\f7\r^&bM.\f\u0017I\u001e:p\t\u0016\u001cXM]5bY&TXM\u001d\t\u0003I\u001dj\u0011!\n\u0006\u0003M1\taa]2iK6\f\u0017B\u0001\u0015&\u0005Y!\u0015\r^;n%\u0016\fG-\u001a:Xe&$XM]'jq&t\u0017A\u0002\u001fj]&$h\bF\u0001,!\ta\u0003!D\u0001\u0007\u00039!WmY8eKJ4\u0015m\u0019;pef,\u0012a\f\t\u0003a]j\u0011!\r\u0006\u0003AIR!!D\u001a\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003qE\u0012a\u0002R3d_\u0012,'OR1di>\u0014\u00180A\u0006eKN,'/[1mSj,G#B\u001eB\u001db\u0003\u0007C\u0001\u001f@\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$AB!osJ+g\rC\u0003C\u0007\u0001\u00071)A\u0003u_BL7\r\u0005\u0002E\u0017:\u0011Q)\u0013\t\u0003\rvj\u0011a\u0012\u0006\u0003\u0011Z\ta\u0001\u0010:p_Rt\u0014B\u0001&>\u0003\u0019\u0001&/\u001a3fM&\u0011A*\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)k\u0004\"B(\u0004\u0001\u0004\u0001\u0016!B5t\u0017\u0016L\bCA)W\u001b\u0005\u0011&BA*U\u0003\u0011a\u0017M\\4\u000b\u0003U\u000bAA[1wC&\u0011qK\u0015\u0002\b\u0005>|G.Z1o\u0011\u0015I6\u00011\u0001[\u0003\u001d\u0001\u0018-\u001f7pC\u0012\u00042\u0001P.^\u0013\taVHA\u0003BeJ\f\u0017\u0010\u0005\u0002==&\u0011q,\u0010\u0002\u0005\u0005f$X\rC\u0003b\u0007\u0001\u0007!-\u0001\u0007sK\u0006$WM]*dQ\u0016l\u0017\r\u0005\u0002dI6\t!'\u0003\u0002fe\t11k\u00195f[\u0006\fAA]3bIR\u00191\b\u001b9\t\u000b%$\u0001\u0019\u00016\u0002\r\t,hMZ3s!\tYg.D\u0001m\u0015\tiG+A\u0002oS>L!a\u001c7\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0003r\t\u0001\u0007!-\u0001\bfqB,7\r^3e'\u000eDW-\\1")
public abstract class AbstractConfluentKafkaAvroDeserializer
extends AbstractKafkaAvroDeserializer
implements DatumReaderWriterMixin {
    private DecoderFactory decoderFactory;
    private final Map<String, Schema> primitives;
    private volatile boolean bitmap$0;

    @Override
    public GenericDatumWriter<Object> createDatumWriter(Object record, Schema schema, boolean useSchemaReflection) {
        return DatumReaderWriterMixin.createDatumWriter$(this, record, schema, useSchemaReflection);
    }

    @Override
    public DatumReader<Object> createDatumReader(Schema writerSchema, Schema readerSchema, boolean useSchemaReflection, boolean useSpecificAvroReader) {
        return DatumReaderWriterMixin.createDatumReader$(this, writerSchema, readerSchema, useSchemaReflection, useSpecificAvroReader);
    }

    @Override
    public Map<String, Schema> primitives() {
        return this.primitives;
    }

    @Override
    public void pl$touk$nussknacker$engine$avro$schema$DatumReaderWriterMixin$_setter_$primitives_$eq(Map<String, Schema> x$1) {
        this.primitives = x$1;
    }

    private DecoderFactory decoderFactory$lzycompute() {
        AbstractConfluentKafkaAvroDeserializer abstractConfluentKafkaAvroDeserializer = this;
        synchronized (abstractConfluentKafkaAvroDeserializer) {
            if (!this.bitmap$0) {
                this.decoderFactory = DecoderFactory.get();
                this.bitmap$0 = true;
            }
        }
        return this.decoderFactory;
    }

    public DecoderFactory decoderFactory() {
        return !this.bitmap$0 ? this.decoderFactory$lzycompute() : this.decoderFactory;
    }

    public Object deserialize(String topic, Boolean isKey, byte[] payload, Schema readerSchema) {
        ByteBuffer buffer = (ByteBuffer)ConfluentUtils$.MODULE$.parsePayloadToByteBuffer(payload).valueOr((Function1 & Serializable & scala.Serializable)ex -> {
            throw ex;
        });
        return this.read(buffer, readerSchema);
    }

    public Object read(ByteBuffer buffer, Schema expectedSchema) {
        Object object;
        int schemaId = -1;
        try {
            schemaId = buffer.getInt();
            ParsedSchema parsedSchema = this.schemaRegistry.getSchemaById(schemaId);
            Schema writerSchema = ConfluentUtils$.MODULE$.extractSchema(parsedSchema);
            Schema readerSchema = expectedSchema == null ? writerSchema : expectedSchema;
            DatumReader<Object> reader = this.createDatumReader(writerSchema, readerSchema, this.useSchemaReflection, this.useSpecificAvroReader);
            int length = buffer.limit() - 1 - 4;
            Schema.Type type = writerSchema.getType();
            Schema.Type type2 = Schema.Type.BYTES;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                byte[] bytes = new byte[length];
                buffer.get(bytes, 0, length);
                object = bytes;
            } else {
                int start = buffer.position() + buffer.arrayOffset();
                BinaryDecoder binaryDecoder = this.decoderFactory().binaryDecoder(buffer.array(), start, length, null);
                Object result = reader.read(null, (Decoder)binaryDecoder);
                Schema.Type type3 = writerSchema.getType();
                Schema.Type type4 = Schema.Type.STRING;
                object = !(type3 != null ? !type3.equals(type4) : type4 != null) ? (Object)result.toString() : (Object)result;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof RestClientException) {
                RestClientException restClientException = (RestClientException)throwable2;
                throw new SerializationException(new StringBuilder(38).append("Error retrieving Avro schema for id : ").append(schemaId).toString(), (Throwable)restClientException);
            }
            boolean bl = throwable2 instanceof RuntimeException ? true : throwable2 instanceof IOException;
            if (bl) {
                throw new SerializationException(new StringBuilder(41).append("Error deserializing Avro message for id: ").append(schemaId).toString(), throwable2);
            }
            throw throwable;
        }
        return object;
    }

    public AbstractConfluentKafkaAvroDeserializer() {
        DatumReaderWriterMixin.$init$(this);
    }
}

