/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.engine.avro.schemaregistry.confluent.client;

import cats.data.Validated;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.schemaregistry.client.SchemaMetadata;
import java.io.Serializable;
import pl.touk.nussknacker.engine.avro.AvroUtils$;
import pl.touk.nussknacker.engine.avro.schemaregistry.SchemaRegistryClient;
import pl.touk.nussknacker.engine.avro.schemaregistry.SchemaRegistryError;
import pl.touk.nussknacker.engine.avro.schemaregistry.SchemaWithMetadata;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.ConfluentUtils$;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.client.ConfluentSchemaRegistryClient;
import pl.touk.nussknacker.engine.avro.schemaregistry.confluent.client.SchemaRegistryCaches;
import scala.Function0;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055b\u0001B\u0006\r\u0001uA\u0001\"\u0004\u0001\u0003\u0006\u0004%\tA\r\u0005\t}\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003D\u0001\u0011\u0005A\tC\u0003I\u0001\u0011\u0005\u0013\nC\u0003l\u0001\u0011\u0005C\u000eC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003y\u0001\u0011\u0005\u0013\u0010C\u0004\u0002\n\u0001!\t%a\u0003\t\u000f\u0005\u0015\u0002\u0001\"\u0003\u0002(\t\u00193)Y2iK\u0012\u001cuN\u001c4mk\u0016tGoU2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$(BA\u0007\u000f\u0003\u0019\u0019G.[3oi*\u0011q\u0002E\u0001\nG>tg\r\\;f]RT!!\u0005\n\u0002\u001dM\u001c\u0007.Z7be\u0016<\u0017n\u001d;ss*\u00111\u0003F\u0001\u0005CZ\u0014xN\u0003\u0002\u0016-\u00051QM\\4j]\u0016T!a\u0006\r\u0002\u00179,8o]6oC\u000e\\WM\u001d\u0006\u00033i\tA\u0001^8vW*\t1$\u0001\u0002qY\u000e\u00011\u0003\u0002\u0001\u001fI!\u0002\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012a!\u00118z%\u00164\u0007CA\u0013'\u001b\u0005a\u0011BA\u0014\r\u0005u\u0019uN\u001c4mk\u0016tGoU2iK6\f'+Z4jgR\u0014\u0018p\u00117jK:$\bCA\u00151\u001b\u0005Q#BA\u0016-\u00031\u00198-\u00197bY><w-\u001b8h\u0015\tic&\u0001\u0005usB,7/\u00194f\u0015\u0005y\u0013aA2p[&\u0011\u0011G\u000b\u0002\f\u0019\u0006T\u0018\u0010T8hO&tw-F\u00014!\t!D(D\u00016\u0015\tiaG\u0003\u0002\u0012o)\u0011\u0001(O\u0001\u0006W\u000647.\u0019\u0006\u0003\u001fiR\u0011aO\u0001\u0003S>L!!P\u001b\u0003)M\u001b\u0007.Z7b%\u0016<\u0017n\u001d;ss\u000ec\u0017.\u001a8u\u0003\u001d\u0019G.[3oi\u0002\naaY1dQ\u0016\u001c\bCA\u0013B\u0013\t\u0011EB\u0001\u000bTG\",W.\u0019*fO&\u001cHO]=DC\u000eDWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u00153u\t\u0005\u0002&\u0001!)Q\u0002\u0002a\u0001g!)q\b\u0002a\u0001\u0001\u0006!r-\u001a;MCR,7\u000f\u001e$sKND7k\u00195f[\u0006$2AS-g!\u0011Y\u0005K\u0015,\u000e\u00031S!!\u0014(\u0002\t\u0011\fG/\u0019\u0006\u0002\u001f\u0006!1-\u0019;t\u0013\t\tFJA\u0005WC2LG-\u0019;fIB\u00111\u000bV\u0007\u0002!%\u0011Q\u000b\u0005\u0002\u0014'\u000eDW-\\1SK\u001eL7\u000f\u001e:z\u000bJ\u0014xN\u001d\t\u0003'^K!\u0001\u0017\t\u0003%M\u001b\u0007.Z7b/&$\b.T3uC\u0012\fG/\u0019\u0005\u00065\u0016\u0001\raW\u0001\u0006i>\u0004\u0018n\u0019\t\u00039\u000et!!X1\u0011\u0005y\u0003S\"A0\u000b\u0005\u0001d\u0012A\u0002\u001fs_>$h(\u0003\u0002cA\u00051\u0001K]3eK\u001aL!\u0001Z3\u0003\rM#(/\u001b8h\u0015\t\u0011\u0007\u0005C\u0003h\u000b\u0001\u0007\u0001.A\u0003jg.+\u0017\u0010\u0005\u0002 S&\u0011!\u000e\t\u0002\b\u0005>|G.Z1o\u0003=9W\r\u001e'bi\u0016\u001cHoU2iK6\fGc\u0001&n]\")!L\u0002a\u00017\")qM\u0002a\u0001Q\u00061r-\u001a;CsN+(M[3di\u0006sGMV3sg&|g\u000e\u0006\u0003KcJ<\b\"\u0002.\b\u0001\u0004Y\u0006\"B:\b\u0001\u0004!\u0018a\u0002<feNLwN\u001c\t\u0003?UL!A\u001e\u0011\u0003\u0007%sG\u000fC\u0003h\u000f\u0001\u0007\u0001.\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7/F\u0001{!\u0011Y\u0005KU>\u0011\tq\f\u0019a\u0017\b\u0003{~t!A\u0018@\n\u0003\u0005J1!!\u0001!\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0002\u0002\b\t!A*[:u\u0015\r\t\t\u0001I\u0001\u000fO\u0016$\u0018\t\u001c7WKJ\u001c\u0018n\u001c8t)\u0019\ti!!\t\u0002$A)1\n\u0015*\u0002\u0010A)A0a\u0001\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011\u0001\u00027b]\u001eT!!a\u0007\u0002\t)\fg/Y\u0005\u0005\u0003?\t)BA\u0004J]R,w-\u001a:\t\u000biK\u0001\u0019A.\t\u000b\u001dL\u0001\u0019\u00015\u0002'1\fG/Z:u'\u000eDW-\\1SKF,Xm\u001d;\u0015\u0007Y\u000bI\u0003\u0003\u0004\u0002,)\u0001\raW\u0001\bgV\u0014'.Z2u\u0001")
public class CachedConfluentSchemaRegistryClient
implements ConfluentSchemaRegistryClient {
    private final io.confluent.kafka.schemaregistry.client.SchemaRegistryClient client;
    private final SchemaRegistryCaches caches;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public <T> Validated<SchemaRegistryError, T> handleClientError(Function0<T> data) {
        return ConfluentSchemaRegistryClient.handleClientError$(this, data);
    }

    @Override
    public Validated<SchemaRegistryError, SchemaWithMetadata> getSchema(String topic, Option<Object> version, boolean isKey) {
        return SchemaRegistryClient.getSchema$(this, topic, version, isKey);
    }

    @Override
    public Validated<SchemaRegistryError, SchemaWithMetadata> getFreshSchema(String topic, Option<Object> version, boolean isKey) {
        return SchemaRegistryClient.getFreshSchema$(this, topic, version, isKey);
    }

    private Logger logger$lzycompute() {
        CachedConfluentSchemaRegistryClient cachedConfluentSchemaRegistryClient = this;
        synchronized (cachedConfluentSchemaRegistryClient) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public io.confluent.kafka.schemaregistry.client.SchemaRegistryClient client() {
        return this.client;
    }

    @Override
    public Validated<SchemaRegistryError, SchemaWithMetadata> getLatestFreshSchema(String topic, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return this.latestSchemaRequest(subject);
        });
    }

    @Override
    public Validated<SchemaRegistryError, SchemaWithMetadata> getLatestSchema(String topic, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return (SchemaWithMetadata)$this.caches.latestSchemaCache().getOrCreate((Object)subject, (Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Cache latest schema for subject: {}.", new Object[]{subject});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                return this.latestSchemaRequest(subject);
            });
        });
    }

    @Override
    public Validated<SchemaRegistryError, SchemaWithMetadata> getBySubjectAndVersion(String topic, int version, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return (SchemaWithMetadata)$this.caches.schemaCache().getOrCreate((Object)new StringBuilder(1).append(subject).append("-").append(version).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Cache schema for subject: {} and version: {}.", new Object[]{subject, BoxesRunTime.boxToInteger((int)version)});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                SchemaMetadata schemaMetadata = this.client().getSchemaMetadata(subject, version);
                return new SchemaWithMetadata(AvroUtils$.MODULE$.nonRestrictiveParseSchema(schemaMetadata.getSchema()), schemaMetadata.getId());
            });
        });
    }

    @Override
    public Validated<SchemaRegistryError, List<String>> getAllTopics() {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> (List)$this.caches.topicsCache().getOrCreate((Function0 & Serializable & scala.Serializable)() -> (List)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.client().getAllSubjects()).asScala()).toList().collect(ConfluentUtils$.MODULE$.topicFromSubject(), List$.MODULE$.canBuildFrom())));
    }

    @Override
    public Validated<SchemaRegistryError, List<Integer>> getAllVersions(String topic, boolean isKey) {
        return this.handleClientError((Function0 & Serializable & scala.Serializable)() -> {
            String subject = ConfluentUtils$.MODULE$.topicSubject(topic, isKey);
            return (List)$this.caches.versionsCache().getOrCreate((Object)subject, (Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(this.client().getAllVersions(subject)).asScala()).toList());
        });
    }

    private SchemaWithMetadata latestSchemaRequest(String subject) {
        SchemaMetadata schemaMetadata = this.client().getLatestSchemaMetadata(subject);
        return (SchemaWithMetadata)this.caches.schemaCache().getOrCreate((Object)new StringBuilder(1).append(subject).append("-").append(schemaMetadata.getVersion()).toString(), (Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Cache parsed latest schema for subject: {}, version: {}.", new Object[]{subject, BoxesRunTime.boxToInteger((int)schemaMetadata.getVersion())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new SchemaWithMetadata(AvroUtils$.MODULE$.nonRestrictiveParseSchema(schemaMetadata.getSchema()), schemaMetadata.getId());
        });
    }

    public CachedConfluentSchemaRegistryClient(io.confluent.kafka.schemaregistry.client.SchemaRegistryClient client, SchemaRegistryCaches caches) {
        this.client = client;
        this.caches = caches;
        SchemaRegistryClient.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        ConfluentSchemaRegistryClient.$init$(this);
    }
}

